/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak.security;

import java.security.Principal;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.authorization.ProviderCtx;
import org.apache.jackrabbit.oak.security.authorization.monitor.AuthorizationMonitor;
import org.apache.jackrabbit.oak.security.authorization.monitor.AuthorizationMonitorImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.AllPermissionProviderImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.silverpeas.core.jcr.impl.oak.security.SilverpeasPermissionProvider;

public class SilverpeasAuthorizationConfiguration
extends ConfigurationBase
implements AuthorizationConfiguration,
ProviderCtx {
    private final MountInfoProvider mountInfoProvider = Mounts.defaultMountInfoProvider();
    private final AuthorizationMonitor monitor = new AuthorizationMonitorImpl(StatisticsProvider.NOOP);

    public SilverpeasAuthorizationConfiguration(@Nonnull SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.authorization"));
    }

    @Nonnull
    public MountInfoProvider getMountInfoProvider() {
        return this.mountInfoProvider;
    }

    @Nonnull
    public AuthorizationMonitor getMonitor() {
        return this.monitor;
    }

    @Nonnull
    public AccessControlManager getAccessControlManager(@Nonnull Root root, @Nonnull NamePathMapper namePathMapper) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public RestrictionProvider getRestrictionProvider() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public PermissionProvider getPermissionProvider(@Nonnull Root root, @Nonnull String workspaceName, @Nonnull Set<Principal> principals) {
        if (PermissionUtil.isAdminOrSystem(principals, (ConfigurationParameters)this.getParameters())) {
            return new AllPermissionProviderImpl(root, (ProviderCtx)this);
        }
        return new SilverpeasPermissionProvider(root, principals, this);
    }
}

