/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.Objects;
import java.util.Optional;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.jcr.RepositoryProvider;
import org.silverpeas.core.jcr.SilverpeasRepository;
import org.silverpeas.core.jcr.security.JCRUserCredentialsProvider;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.logging.SilverLogger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JCRSession
implements Session,
Closeable {
    private static final String SESSION_KEY_CACHE = JCRSession.class.getSimpleName() + "#SESSION";
    private final Session session;
    private int opened = 1;

    static JCRSession open(Credentials credentials, JCRLogin login) throws RepositoryException {
        JCRSession session;
        Optional<JCRSession> current = JCRSession.getCurrent();
        if (current.isPresent()) {
            String userId = JCRSession.getUserID(credentials);
            session = current.get();
            String sessionUserId = session.getUserID();
            if (!Objects.equals(sessionUserId, userId)) {
                String suid = sessionUserId == null ? "guest" : sessionUserId;
                String uid = userId == null ? "unknown" : userId;
                throw new IllegalStateException("Attempt of " + uid + " to log into the repository whereas a session was already opened in the same thread by the user " + suid);
            }
        } else {
            session = new JCRSession(login.proceed(credentials));
        }
        return session.open();
    }

    private static Optional<JCRSession> getCurrent() {
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        return Optional.ofNullable((JCRSession)cache.get((Object)SESSION_KEY_CACHE, JCRSession.class));
    }

    private static String getUserID(Credentials credentials) {
        AuthenticationCredential authCred;
        SimpleCredentials simpleCred;
        User user = credentials instanceof SimpleCredentials ? ((simpleCred = (SimpleCredentials)credentials).getUserID().equals("jcr-system@domain0") ? User.getSystemUser() : ((authCred = JCRUserCredentialsProvider.getAuthCredentials((SimpleCredentials)credentials)) != null ? User.provider().getUserByLoginAndDomainId(authCred.getLogin(), authCred.getDomainId()) : null)) : (credentials instanceof TokenCredentials ? User.provider().getUserByToken(((TokenCredentials)credentials).getToken()) : null);
        return user == null ? null : user.getId();
    }

    public static JCRSession openSystemSession() throws RepositoryException {
        SilverpeasRepository repo = RepositoryProvider.get().getRepository();
        Credentials credentials = JCRUserCredentialsProvider.getJcrSystemCredentials();
        return repo.login(credentials);
    }

    public static JCRSession openUserSession(String login, String domainId, String password) throws RepositoryException {
        SilverpeasRepository repo = RepositoryProvider.get().getRepository();
        Credentials credentials = JCRUserCredentialsProvider.getUserCredentials(login, domainId, password);
        return repo.login(credentials);
    }

    private JCRSession(Session session) {
        JCRSession.getCurrent().ifPresent(s -> {
            throw new IllegalStateException("A session is already opened!");
        });
        this.session = session;
    }

    public Repository getRepository() {
        return RepositoryProvider.get().getRepository();
    }

    public String getUserID() {
        return this.session.getUserID();
    }

    public String[] getAttributeNames() {
        return this.session.getAttributeNames();
    }

    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    public Workspace getWorkspace() {
        return this.session.getWorkspace();
    }

    public Node getRootNode() throws RepositoryException {
        return this.session.getRootNode();
    }

    public Session impersonate(Credentials credentials) throws RepositoryException {
        return this.session.impersonate(credentials);
    }

    public Node getNodeByUUID(String uuid) throws RepositoryException {
        return this.session.getNodeByIdentifier(uuid);
    }

    public Node getNodeByIdentifier(String id) throws RepositoryException {
        return this.session.getNodeByIdentifier(id);
    }

    public Item getItem(String absPath) throws RepositoryException {
        return this.session.getItem(absPath);
    }

    public Node getNode(String absPath) throws RepositoryException {
        return this.session.getNode(absPath);
    }

    public Property getProperty(String absPath) throws RepositoryException {
        return this.session.getProperty(absPath);
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        return this.session.itemExists(absPath);
    }

    public boolean nodeExists(String absPath) throws RepositoryException {
        return this.session.nodeExists(absPath);
    }

    public boolean propertyExists(String absPath) throws RepositoryException {
        return this.session.propertyExists(absPath);
    }

    public void move(String srcAbsPath, String destAbsPath) throws RepositoryException {
        this.session.move(srcAbsPath, destAbsPath);
    }

    public void removeItem(String absPath) throws RepositoryException {
        this.session.removeItem(absPath);
    }

    public void save() throws RepositoryException {
        this.session.save();
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        this.session.refresh(keepChanges);
    }

    public boolean hasPendingChanges() throws RepositoryException {
        return this.session.hasPendingChanges();
    }

    public ValueFactory getValueFactory() throws RepositoryException {
        return this.session.getValueFactory();
    }

    public boolean hasPermission(String absPath, String actions) throws RepositoryException {
        return this.session.hasPermission(absPath, actions);
    }

    public void checkPermission(String absPath, String actions) throws AccessControlException, RepositoryException {
        this.session.checkPermission(absPath, actions);
    }

    public boolean hasCapability(String methodName, Object target, Object[] arguments) throws RepositoryException {
        return this.session.hasCapability(methodName, target, arguments);
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws RepositoryException {
        return this.session.getImportContentHandler(parentAbsPath, uuidBehavior);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, RepositoryException {
        this.session.importXML(parentAbsPath, in, uuidBehavior);
    }

    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws SAXException, RepositoryException {
        this.session.exportSystemView(absPath, contentHandler, skipBinary, noRecurse);
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, RepositoryException {
        this.session.exportSystemView(absPath, out, skipBinary, noRecurse);
    }

    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws SAXException, RepositoryException {
        this.session.exportDocumentView(absPath, contentHandler, skipBinary, noRecurse);
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, RepositoryException {
        this.session.exportDocumentView(absPath, out, skipBinary, noRecurse);
    }

    public void setNamespacePrefix(String prefix, String uri) throws RepositoryException {
        this.session.setNamespacePrefix(prefix, uri);
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        return this.session.getNamespacePrefixes();
    }

    public String getNamespaceURI(String prefix) throws RepositoryException {
        return this.session.getNamespaceURI(prefix);
    }

    public String getNamespacePrefix(String uri) throws RepositoryException {
        return this.session.getNamespacePrefix(uri);
    }

    public void logout() {
        if (this.opened <= 1) {
            SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
            cache.remove((Object)SESSION_KEY_CACHE);
            this.session.logout();
        } else {
            --this.opened;
        }
    }

    public boolean isLive() {
        return this.session.isLive();
    }

    public void addLockToken(String lt) {
        try {
            this.session.getWorkspace().getLockManager().addLockToken(lt);
        }
        catch (RepositoryException e) {
            SilverLogger.getLogger((Object)this).error("Unable to add lock token " + lt + " to session", (Throwable)e);
        }
    }

    public String[] getLockTokens() {
        try {
            return this.session.getWorkspace().getLockManager().getLockTokens();
        }
        catch (RepositoryException e) {
            SilverLogger.getLogger((Object)this).error("Unable to retrieve lock tokens from session", (Throwable)e);
            return new String[0];
        }
    }

    public void removeLockToken(String lt) {
        try {
            this.session.getWorkspace().getLockManager().removeLockToken(lt);
        }
        catch (RepositoryException e) {
            SilverLogger.getLogger((Object)this).error("Unable to remove lock token " + lt + " from session", (Throwable)e);
        }
    }

    public AccessControlManager getAccessControlManager() throws RepositoryException {
        return this.session.getAccessControlManager();
    }

    public RetentionManager getRetentionManager() throws RepositoryException {
        return this.session.getRetentionManager();
    }

    @Override
    public void close() {
        this.logout();
    }

    private JCRSession open() {
        JCRSession.getCurrent().ifPresentOrElse(s -> ++this.opened, () -> {
            SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
            cache.put((Object)SESSION_KEY_CACHE, (Object)this);
        });
        return this;
    }

    @FunctionalInterface
    static interface JCRLogin {
        public Session proceed(Credentials var1) throws RepositoryException;
    }
}

