/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container.impl;

import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.ChannelState;
import com.sun.portal.container.ChannelURLFactory;
import com.sun.portal.container.ContainerRequest;
import com.sun.portal.container.ContainerUtil;
import com.sun.portal.container.EntityID;
import com.sun.portal.container.PortletID;
import com.sun.portal.container.PortletWindowContext;
import com.sun.portal.container.service.policy.PolicyManager;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerRequestImpl
implements ContainerRequest {
    private HttpServletRequest request;
    private ChannelState windowState = ChannelState.NORMAL;
    private ChannelMode channelMode = ChannelMode.VIEW;
    private ChannelState previousWindowState;
    private ChannelMode previousChannelMode;
    private EntityID entityID;
    private String userID;
    private Principal userPrincipal;
    private Locale locale;
    private List<String> roles;
    private List<ChannelState> allowableWindowStates;
    private List<ChannelMode> allowableChannelModes;
    private List<String> allowableContentTypes;
    private Map<String, String> userInfo;
    private ChannelURLFactory channelURLFactory;
    private String charEncoding;
    private boolean isReadOnly;
    private Map<String, Object> attributes;
    private PortletWindowContext portletWindowContext;
    private Map<String, List<String>> properties;
    private Map<String, Map<String, Serializable>> scopedAttributes;
    private PolicyManager policyManager;
    private String namespace;
    private String windowID;
    private String portalInfo;
    private Map<PortletID, List<String>> portletNamespaces;
    private Map<PortletID, List<String>> portletWindowIDs;
    private List<String> requestSharedAttributes;
    private HttpSession session;
    private Map<String, Object> sharedSessionAttributes;

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    @Override
    public void setHttpServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public HttpSession getHttpSession() {
        return this.session;
    }

    @Override
    public void setHttpSession(HttpSession session) {
        this.session = session;
    }

    @Override
    public ChannelState getWindowState() {
        return this.windowState;
    }

    @Override
    public void setWindowState(ChannelState windowState) {
        this.windowState = windowState;
    }

    @Override
    public ChannelMode getChannelMode() {
        return this.channelMode;
    }

    @Override
    public void setChannelMode(ChannelMode channelMode) {
        this.channelMode = channelMode;
    }

    @Override
    public EntityID getEntityID() {
        return this.entityID;
    }

    @Override
    public void setEntityID(EntityID entityID) {
        this.entityID = entityID;
    }

    @Override
    public Locale getLocale() {
        Locale theLocale = this.locale;
        if (theLocale == null && this.request != null) {
            theLocale = this.request.getLocale();
        }
        return theLocale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public void setUserID(String userID) {
        this.userID = userID;
    }

    @Override
    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    @Override
    public List<String> getRoles() {
        return this.roles;
    }

    @Override
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    @Override
    public List<ChannelState> getAllowableWindowStates() {
        return this.allowableWindowStates;
    }

    @Override
    public void setAllowableWindowStates(List<ChannelState> allowableWindowStates) {
        this.allowableWindowStates = allowableWindowStates;
    }

    @Override
    public List<ChannelMode> getAllowableChannelModes() {
        return this.allowableChannelModes;
    }

    @Override
    public void setAllowableChannelModes(List<ChannelMode> allowableChannelModes) {
        this.allowableChannelModes = allowableChannelModes;
    }

    @Override
    public List<String> getAllowableContentTypes() {
        return this.allowableContentTypes;
    }

    @Override
    public void setAllowableContentTypes(List<String> allowableContentTypes) {
        this.allowableContentTypes = allowableContentTypes;
    }

    @Override
    public Map<String, String> getUserInfo() {
        return this.userInfo;
    }

    @Override
    public void setUserInfo(Map<String, String> userInfo) {
        this.userInfo = userInfo;
    }

    public ChannelMode getPreviousChannelMode() {
        return this.previousChannelMode;
    }

    public void setPreviousChannelMode(ChannelMode channelMode) {
        this.previousChannelMode = channelMode;
    }

    public ChannelState getPreviousWindowState() {
        return this.previousWindowState;
    }

    public void setPreviousWindowState(ChannelState windowState) {
        this.previousWindowState = windowState;
    }

    @Override
    public ChannelURLFactory getChannelURLFactory() {
        return this.channelURLFactory;
    }

    @Override
    public void setChannelURLFactory(ChannelURLFactory channelURLFactory) {
        this.channelURLFactory = channelURLFactory;
    }

    @Override
    public void setCharacterEncoding(String charEncoding) {
        this.charEncoding = charEncoding;
    }

    @Override
    public String getCharacterEncoding() {
        return this.charEncoding;
    }

    @Override
    public void setIsReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public boolean getIsReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            return Collections.EMPTY_MAP;
        }
        return this.attributes;
    }

    @Override
    public void setPortletWindowContext(PortletWindowContext portletWindowContext) {
        this.portletWindowContext = portletWindowContext;
    }

    @Override
    public PortletWindowContext getPortletWindowContext() {
        return this.portletWindowContext;
    }

    @Override
    public Map<String, List<String>> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Property name should not be null.");
        }
        if (this.properties == null) {
            this.properties = new HashMap<String, List<String>>();
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.properties.put(key, values);
    }

    @Override
    public void addProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Property name should not be null.");
        }
        List<String> values = null;
        if (this.properties == null) {
            this.properties = new HashMap<String, List<String>>();
        } else {
            values = this.properties.get(key);
        }
        if (values == null) {
            values = new ArrayList<String>();
        }
        values.add(value);
        this.properties.put(key, values);
    }

    @Override
    public void setScopedAttributes(String scopeID, Map<String, Serializable> scopedAttributes) {
        if (this.scopedAttributes == null) {
            this.scopedAttributes = new HashMap<String, Map<String, Serializable>>();
        }
        this.scopedAttributes.put(scopeID, scopedAttributes);
    }

    @Override
    public Map<String, Serializable> getScopedAttributes(String scopeID) {
        Map<String, Serializable> localScopedAttributes = null;
        if (this.scopedAttributes != null) {
            localScopedAttributes = this.scopedAttributes.get(scopeID);
        }
        if (localScopedAttributes != null) {
            return localScopedAttributes;
        }
        return Collections.emptyMap();
    }

    @Override
    public PolicyManager getPolicyManager() {
        return this.policyManager;
    }

    @Override
    public void setPolicyManager(PolicyManager policyManager) {
        this.policyManager = policyManager;
    }

    @Override
    public String getNamespace() {
        if (this.namespace == null && this.entityID != null) {
            this.namespace = this.getJsSafeDefaultNamespace();
        }
        return this.namespace;
    }

    private String getJsSafeDefaultNamespace() {
        return ContainerUtil.getJavascriptSafeName(this.entityID.toString());
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = ContainerUtil.getJavascriptSafeName(namespace);
    }

    @Override
    public String getWindowID() {
        if (this.windowID == null && this.entityID != null) {
            this.windowID = this.entityID.toString();
        }
        return this.windowID;
    }

    @Override
    public void setWindowID(String windowID) {
        this.windowID = windowID;
    }

    @Override
    public String getPortalInfo() {
        return this.portalInfo;
    }

    @Override
    public void setPortalInfo(String portalInfo) {
        this.portalInfo = portalInfo;
    }

    @Override
    public String getNamespace(PortletID portletID) {
        List<String> namespaces;
        if (this.portletNamespaces != null && (namespaces = this.portletNamespaces.get(portletID)) != null && !namespaces.isEmpty()) {
            return namespaces.get(0);
        }
        return null;
    }

    @Override
    public Map<PortletID, List<String>> getPortletNamespaces() {
        return this.portletNamespaces;
    }

    @Override
    public void setPortletNamespaces(Map<PortletID, List<String>> portletNamespaces) {
        this.portletNamespaces = portletNamespaces;
    }

    @Override
    public String getWindowID(PortletID portletID) {
        List<String> windowIDs;
        if (this.portletWindowIDs != null && (windowIDs = this.portletWindowIDs.get(portletID)) != null && !windowIDs.isEmpty()) {
            return windowIDs.get(0);
        }
        return null;
    }

    @Override
    public Map<PortletID, List<String>> getPortletWindowIDs() {
        return this.portletWindowIDs;
    }

    @Override
    public void setPortletWindowIDs(Map<PortletID, List<String>> portletWindowIDs) {
        this.portletWindowIDs = portletWindowIDs;
    }

    @Override
    public List<String> getRequestSharedAttributes() {
        return this.requestSharedAttributes;
    }

    @Override
    public void setRequestSharedAttributes(List<String> requestSharedAttributes) {
        this.requestSharedAttributes = requestSharedAttributes;
    }

    @Override
    public void setSharedSessionAttributesPublish(Map<String, Object> sharedSessionAttributes) {
        this.sharedSessionAttributes = sharedSessionAttributes;
    }

    @Override
    public Map<String, Object> getSharedSessionAttributesPublish() {
        return this.sharedSessionAttributes;
    }
}

