/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.authentication;

import java.util.Collections;
import java.util.Map;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.authentication.SimplePrincipal;
import org.jasig.cas.client.proxy.ProxyRetriever;
import org.jasig.cas.client.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributePrincipalImpl
extends SimplePrincipal
implements AttributePrincipal {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributePrincipalImpl.class);
    private static final long serialVersionUID = -1443182634624927187L;
    private final Map<String, Object> attributes;
    private final String proxyGrantingTicket;
    private final ProxyRetriever proxyRetriever;

    public AttributePrincipalImpl(String name) {
        this(name, Collections.emptyMap());
    }

    public AttributePrincipalImpl(String name, Map<String, Object> attributes) {
        this(name, attributes, null, null);
    }

    public AttributePrincipalImpl(String name, String proxyGrantingTicket, ProxyRetriever proxyRetriever) {
        this(name, Collections.emptyMap(), proxyGrantingTicket, proxyRetriever);
    }

    public AttributePrincipalImpl(String name, Map<String, Object> attributes, String proxyGrantingTicket, ProxyRetriever proxyRetriever) {
        super(name);
        this.attributes = attributes;
        this.proxyGrantingTicket = proxyGrantingTicket;
        this.proxyRetriever = proxyRetriever;
        CommonUtils.assertNotNull(this.attributes, "attributes cannot be null.");
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getProxyTicketFor(String service) {
        if (this.proxyGrantingTicket != null) {
            return this.proxyRetriever.getProxyTicketIdFor(this.proxyGrantingTicket, service);
        }
        LOGGER.debug("No ProxyGrantingTicket was supplied, so no Proxy Ticket can be retrieved.");
        return null;
    }
}

