/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.MessageAgent;
import com.novell.ldap.client.Debug;
import com.novell.ldap.client.ExtResponseFactory;
import com.novell.ldap.client.IntermediateResponseFactory;
import com.novell.ldap.rfc2251.RfcLDAPMessage;

public abstract class LDAPMessageQueue {
    MessageAgent agent;
    String name = "";
    static Object nameLock = new Object();
    static int queueNum = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LDAPMessageQueue(String myname, MessageAgent agent) {
        Object object = nameLock;
        synchronized (object) {
            this.name = myname + "(" + ++queueNum + "): ";
        }
        Debug.trace("Messages", this.name + "Created");
        this.agent = agent;
    }

    String getDebugName() {
        return this.name;
    }

    MessageAgent getMessageAgent() {
        return this.agent;
    }

    public int[] getMessageIDs() {
        return this.agent.getMessageIDs();
    }

    public LDAPMessage getResponse() throws LDAPException {
        return this.getResponse(null);
    }

    public LDAPMessage getResponse(int msgid) throws LDAPException {
        return this.getResponse(new Integer(msgid));
    }

    private LDAPMessage getResponse(Integer msgid) throws LDAPException {
        LDAPMessage response;
        Debug.trace("APIRequests", this.name + "getResponse(" + msgid + ")");
        Object resp = this.agent.getLDAPMessage(msgid);
        if (resp == null) {
            return null;
        }
        if (resp instanceof LDAPResponse) {
            return (LDAPMessage)resp;
        }
        RfcLDAPMessage message = (RfcLDAPMessage)resp;
        switch (message.getType()) {
            case 4: {
                response = new LDAPSearchResult(message);
                break;
            }
            case 19: {
                response = new LDAPSearchResultReference(message);
                break;
            }
            case 25: {
                response = IntermediateResponseFactory.convertToIntermediateResponse(message);
                break;
            }
            case 24: {
                ExtResponseFactory fac = new ExtResponseFactory();
                response = ExtResponseFactory.convertToExtendedResponse(message);
                break;
            }
            default: {
                response = new LDAPResponse(message);
            }
        }
        return response;
    }

    public boolean isResponseReceived() {
        return this.agent.isResponseReceived();
    }

    public boolean isResponseReceived(int msgid) {
        return this.agent.isResponseReceived(msgid);
    }

    public boolean isComplete(int msgid) {
        return this.agent.isComplete(msgid);
    }
}

