/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.test;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.jcetaglib.lib.Keystore;
import net.sourceforge.jcetaglib.lib.X509Cert;
import net.sourceforge.jcetaglib.test.RunTest;

public class KeyTest
extends TestCase {
    public void testGenerateKeys() throws Exception {
        for (int i = 0; i < RunTest.alg.length; ++i) {
            String fileloc = "C:/tmp/" + RunTest.alg[i][0] + "_" + RunTest.alg[i][1] + ".key";
            Keystore.generateKey(RunTest.alg[i][0], Integer.parseInt(RunTest.alg[i][1]), null, fileloc, new StringBuffer("password"));
        }
    }

    public void testGenerateCertificates() throws Exception {
        KeyPair kp = X509Cert.generateKeyPair("RSA", 1024, null);
        X509Certificate cacert = X509Cert.selfsign(kp.getPrivate(), kp.getPublic(), "MD5WithRSAEncryption", 365L, "C=BE, O=NET, OU=Sourceforge, CN=CertAuthority, EmailAddress=info@certauthority.org", true, null);
        X509Cert.saveAsP12(cacert, cacert, kp.getPrivate(), "C:/tmp/ca.p12", "ca", new StringBuffer("password"));
        KeyPair kpAlice = X509Cert.generateKeyPair("RSA", 1024, null);
        X509Certificate alicecert = X509Cert.sign(kpAlice.getPublic(), kp.getPrivate(), cacert, "MD5WithRSAEncryption", 365L, "C=BE, O=NET, OU=Sourceforge, CN=Alice, EmailAddress=alice@sourceforge.net", true, null, "client");
        X509Cert.saveAsP12(alicecert, cacert, kpAlice.getPrivate(), "C:/tmp/alice.p12", "alice", new StringBuffer("password"));
        KeyPair kpBob = X509Cert.generateKeyPair("RSA", 1024, null);
        X509Certificate bobcert = X509Cert.sign(kpBob.getPublic(), kp.getPrivate(), cacert, "MD5WithRSAEncryption", 365L, "C=BE, O=NET, OU=Sourceforge, CN=Bob, EmailAddress=bob@sourceforge.net", true, null, "all");
        X509Cert.saveAsP12(bobcert, cacert, kpBob.getPrivate(), "C:/tmp/bob.p12", "bob", new StringBuffer("password"));
    }

    public void testReadCertificates() throws Exception {
        X509Certificate alicecert = X509Cert.getCertificateFromP12("C:/tmp/alice.p12", "alice", new StringBuffer("password"));
        alicecert.checkValidity();
        Assert.assertEquals((String)((Object)alicecert.getSubjectDN()).toString(), (String)"C=BE,O=NET,OU=Sourceforge,CN=Alice,E=alice@sourceforge.net");
        Assert.assertEquals((String)alicecert.getSigAlgName(), (String)"MD5WithRSAEncryption");
        Assert.assertEquals((String)((Object)alicecert.getIssuerDN()).toString(), (String)"C=BE,O=NET,OU=Sourceforge,CN=CertAuthority,E=info@certauthority.org");
        X509Certificate bobcert = X509Cert.getCertificateFromP12("C:/tmp/bob.p12", "bob", new StringBuffer("password"));
        bobcert.checkValidity();
        Assert.assertEquals((String)((Object)bobcert.getSubjectDN()).toString(), (String)"C=BE,O=NET,OU=Sourceforge,CN=Bob,E=bob@sourceforge.net");
        Assert.assertEquals((String)bobcert.getSigAlgName(), (String)"MD5WithRSAEncryption");
        Assert.assertEquals((String)((Object)bobcert.getIssuerDN()).toString(), (String)"C=BE,O=NET,OU=Sourceforge,CN=CertAuthority,E=info@certauthority.org");
    }
}

