/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.test;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.jcetaglib.lib.Digesters;
import net.sourceforge.jcetaglib.test.RunTest;

public class DigestTest
extends TestCase {
    private StringBuffer digest1 = null;
    private StringBuffer digest2 = null;

    protected void setUp() throws IOException {
        FileOutputStream outStr = new FileOutputStream("C:/tmp/readable.txt");
        DataOutputStream dataStr = new DataOutputStream(outStr);
        dataStr.writeBytes("This is a readable string inside a file");
        dataStr.flush();
        dataStr.close();
        outStr.close();
    }

    public void testDigest() throws Exception {
        for (int i = 0; i < RunTest.digestalg.length; ++i) {
            for (int j = 0; j < RunTest.text.length; ++j) {
                this.digest1 = Digesters.hash(RunTest.text[j], RunTest.digestalg[i]);
                this.digest2 = Digesters.hash(RunTest.text[j], RunTest.digestalg[i]);
                Assert.assertEquals((String)this.digest1.toString(), (String)this.digest2.toString());
            }
        }
    }

    public void testFileDigest() throws Exception {
        for (int i = 0; i < RunTest.digestalg.length; ++i) {
            this.digest1 = Digesters.hashFile("C:/tmp/readable.txt", RunTest.digestalg[i]);
            this.digest2 = Digesters.hashFile("C:/tmp/readable.txt", RunTest.digestalg[i]);
            Assert.assertEquals((String)this.digest1.toString(), (String)this.digest2.toString());
        }
    }

    public void testFormDigest() throws Exception {
        for (int i = 0; i < RunTest.digestalg.length; ++i) {
            for (int j = 0; j < RunTest.alg.length; ++j) {
                String keyfile = "C:/tmp/" + RunTest.alg[j][0] + "_" + RunTest.alg[j][1] + ".key";
                this.digest1 = Digesters.formDigest(new StringBuffer("field1=a&field2=b"), RunTest.digestalg[i], keyfile, new StringBuffer("password"), RunTest.alg[j][0]);
                this.digest2 = Digesters.formDigest(new StringBuffer("field1=a&field2=b"), RunTest.digestalg[i], keyfile, new StringBuffer("password"), RunTest.alg[j][0]);
                Assert.assertEquals((String)this.digest1.toString(), (String)this.digest2.toString());
            }
        }
    }
}

