/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.lib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import net.sourceforge.jcetaglib.exceptions.CryptoException;
import net.sourceforge.jcetaglib.lib.Seed;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class PBECrypt {
    private static int PBE_COUNT = 20;
    private static int BUFFERSIZE_TEXT = 64;
    private static int BUFFERSIZE_FILE = 8192;

    public static StringBuffer encrypt(StringBuffer text, StringBuffer passphrase, String algorithm) throws CryptoException {
        return PBECrypt.encrypt(text, passphrase, null, algorithm);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer encrypt(StringBuffer text, StringBuffer passphrase, byte[] seed, String algorithm) throws CryptoException {
        StringBuffer stringBuffer;
        ByteArrayOutputStream bao = null;
        DataOutputStream dao = null;
        try {
            try {
                bao = new ByteArrayOutputStream();
                dao = new DataOutputStream(bao);
                PBECrypt.encrypt(new ByteArrayInputStream(text.toString().getBytes()), dao, seed, passphrase, algorithm, BUFFERSIZE_TEXT);
                stringBuffer = new StringBuffer(new String(Base64.encode((byte[])bao.toByteArray())));
                Object var8_8 = null;
                if (dao == null) return stringBuffer;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (dao == null) throw throwable;
            try {
                dao.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return stringBuffer;
        }
        dao.close();
        return stringBuffer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encrypt(InputStream is, DataOutputStream daos, byte[] seed, StringBuffer passphrase, String algorithm, int bufferlength) throws CryptoException, IOException {
        CipherOutputStream cStr = null;
        try {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
                byte[] randomsalt = new byte[8];
                SecureRandom sr = Seed.getSecureRandom(seed);
                sr.nextBytes(randomsalt);
                PBEParameterSpec pbeParamSpec = new PBEParameterSpec(randomsalt, PBE_COUNT);
                PBEKeySpec pbeKeySpec = new PBEKeySpec(passphrase.toString().toCharArray());
                SecretKeyFactory keyFac = SecretKeyFactory.getInstance(algorithm);
                SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
                Cipher pbeCipher = Cipher.getInstance(algorithm);
                pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
                cStr = new CipherOutputStream(daos, pbeCipher);
                daos.write(randomsalt);
                byte[] buffer = new byte[bufferlength];
                int length = 0;
                while ((length = is.read(buffer)) != -1) {
                    cStr.write(buffer, 0, length);
                }
                Object var17_18 = null;
                if (cStr == null) return;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new IOException(ioe.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new CryptoException(ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            if (cStr == null) throw throwable;
            try {
                cStr.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        cStr.close();
        return;
    }

    public static void encryptFile(String file, String newfile, StringBuffer passphrase, String algorithm) throws CryptoException, IOException {
        PBECrypt.encryptFile(file, newfile, passphrase, null, algorithm);
    }

    /*
     * Loose catch block
     */
    public static void encryptFile(String file, String newfile, StringBuffer passphrase, byte[] seed, String algorithm) throws CryptoException, IOException {
        block14: {
            IOException e22;
            FilterOutputStream dao;
            FileInputStream fis;
            block13: {
                fis = null;
                FileOutputStream fos = null;
                dao = null;
                fis = new FileInputStream(file);
                fos = new FileOutputStream(newfile);
                dao = new DataOutputStream(fos);
                PBECrypt.encrypt(fis, (DataOutputStream)dao, seed, passphrase, algorithm, BUFFERSIZE_FILE);
                Object var10_8 = null;
                if (dao == null) break block13;
                try {
                    dao.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e22) {}
            }
            break block14;
            {
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    throw new IOException(ioe.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var10_9 = null;
                if (dao != null) {
                    try {
                        dao.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer decrypt(StringBuffer text, StringBuffer passphrase, String algorithm) throws CryptoException {
        StringBuffer stringBuffer;
        ByteArrayOutputStream bao = null;
        DataOutputStream dao = null;
        try {
            try {
                bao = new ByteArrayOutputStream();
                dao = new DataOutputStream(bao);
                PBECrypt.decrypt(new ByteArrayInputStream(Base64.decode((String)text.toString())), dao, passphrase, algorithm, BUFFERSIZE_TEXT);
                stringBuffer = new StringBuffer(new String(bao.toByteArray()));
                Object var7_7 = null;
                if (dao == null) return stringBuffer;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (dao == null) throw throwable;
            try {
                dao.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return stringBuffer;
        }
        dao.close();
        return stringBuffer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decrypt(InputStream is, DataOutputStream daos, StringBuffer passphrase, String algorithm, int bufferlength) throws CryptoException, IOException {
        CipherInputStream ciStr = null;
        try {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
                byte[] randomsalt = new byte[8];
                is.read(randomsalt);
                PBEParameterSpec pbeParamSpec = new PBEParameterSpec(randomsalt, PBE_COUNT);
                PBEKeySpec pbeKeySpec = new PBEKeySpec(passphrase.toString().toCharArray());
                SecretKeyFactory keyFac = SecretKeyFactory.getInstance(algorithm);
                SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
                Cipher pbeCipher = Cipher.getInstance(algorithm);
                pbeCipher.init(2, (Key)pbeKey, pbeParamSpec);
                ciStr = new CipherInputStream(is, pbeCipher);
                byte[] buffer = new byte[bufferlength];
                int length = 0;
                while ((length = ciStr.read(buffer)) != -1) {
                    daos.write(buffer, 0, length);
                }
                Object var15_16 = null;
                if (ciStr == null) return;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new IOException(ioe.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new CryptoException(ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (ciStr == null) throw throwable;
            try {
                ciStr.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        ciStr.close();
        return;
    }

    /*
     * Loose catch block
     */
    public static void decryptFile(String file, String newfile, StringBuffer passphrase, String algorithm) throws CryptoException, IOException {
        block14: {
            IOException e22;
            FilterOutputStream dao;
            FileInputStream fis;
            block13: {
                fis = null;
                FileOutputStream fos = null;
                dao = null;
                fis = new FileInputStream(file);
                fos = new FileOutputStream(newfile);
                dao = new DataOutputStream(fos);
                PBECrypt.decrypt(fis, (DataOutputStream)dao, passphrase, algorithm, BUFFERSIZE_FILE);
                Object var9_7 = null;
                if (dao == null) break block13;
                try {
                    dao.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e22) {}
            }
            break block14;
            {
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    throw new IOException(ioe.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var9_8 = null;
                if (dao != null) {
                    try {
                        dao.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }
}

