/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import org.silverpeas.kernel.logging.SilverLogger;

public class ExecutionAttempts {
    public static void retry(int maxAttempts, Job aJob) throws Exception {
        int attempts = 1;
        while (true) {
            try {
                aJob.execute();
            }
            catch (Exception ex) {
                SilverLogger.getLogger(ExecutionAttempts.class).warn("Execution of job {0} failed. Try once more", new Object[]{aJob.getClass().getSimpleName()});
                if (++attempts <= maxAttempts) continue;
                throw ex;
            }
            break;
        }
    }

    public static interface Job {
        public void execute() throws Exception;
    }
}

