/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.system;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.notification.system.AbstractResourceEvent;
import org.silverpeas.core.notification.system.AbstractResourceEventListener;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class JMSResourceEventListener<T extends AbstractResourceEvent<?>>
extends AbstractResourceEventListener<T>
implements MessageListener {
    protected abstract Class<T> getResourceEventClass();

    protected boolean retryAtFailure() {
        return false;
    }

    public void onMessage(Message message) {
        CacheAccessorProvider.getThreadCacheAccessor().getCache().clear();
        try {
            AbstractResourceEvent event = (AbstractResourceEvent)message.getBody(this.getResourceEventClass());
            this.dispatchEvent(event);
        }
        catch (Exception e) {
            if (this.retryAtFailure()) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }
}

