/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.date;

import java.time.ZoneId;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

public class TimeZoneUtil {
    private static final SettingBundle TIMEZONE_MAPPING = ResourceLocator.getSettingBundle((String)"org.silverpeas.util.timezone");
    private static final String ZONE_ID_MAP_KEY_PREFIX = "zoneid.map.";

    private TimeZoneUtil() {
    }

    private static String getFromMapping(String timeZoneId) {
        return TIMEZONE_MAPPING.getString(ZONE_ID_MAP_KEY_PREFIX + timeZoneId.replace(" ", "_"));
    }

    public static ZoneId toZoneId(String timeZoneId) {
        try {
            return ZoneId.of(timeZoneId);
        }
        catch (Exception e) {
            SilverLogger.getLogger(TimeZoneUtil.class).warn((Throwable)e);
            return ZoneId.of(TimeZoneUtil.getFromMapping(timeZoneId));
        }
    }
}

