/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.notification;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.function.Consumer;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.calendar.Attendee;
import org.silverpeas.core.calendar.AttendeeSet;
import org.silverpeas.core.calendar.PlannedOnCalendar;
import org.silverpeas.core.calendar.notification.AttendeeLifeCycleEvent;
import org.silverpeas.core.calendar.notification.LifeCycleEventSubType;
import org.silverpeas.core.notification.system.CDIResourceEventNotifier;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.util.ServiceProvider;

@Bean
public class AttendeeLifeCycleEventNotifier
extends CDIResourceEventNotifier<Attendee, AttendeeLifeCycleEvent> {
    private PlannedOnCalendar planned;

    public static AttendeeLifeCycleEventNotifier get() {
        return ServiceProvider.getService(AttendeeLifeCycleEventNotifier.class, new Annotation[0]);
    }

    protected AttendeeLifeCycleEvent createResourceEventFrom(ResourceEvent.Type type, Attendee ... attendees) {
        return new AttendeeLifeCycleEvent(this.planned, type, LifeCycleEventSubType.SINGLE, attendees);
    }

    protected final void notifyEventOn(ResourceEvent.Type type, LifeCycleEventSubType subType, Attendee ... attendees) {
        this.notify(new AttendeeLifeCycleEvent(this.planned, type, subType, attendees));
    }

    public static void notifyAttendees(LifeCycleEventSubType subtype, PlannedOnCalendar eventOrOccurrence, AttendeeSet before, AttendeeSet after) {
        AttendeeLifeCycleEventNotifier notifier = AttendeeLifeCycleEventNotifier.get();
        notifier.planned = eventOrOccurrence;
        HashSet allIds = new HashSet();
        if (before != null) {
            before.forEach((Consumer<? super Attendee>)((Consumer<Attendee>)a -> allIds.add(a.getId())));
        }
        if (after != null) {
            after.forEach((Consumer<? super Attendee>)((Consumer<Attendee>)a -> allIds.add(a.getId())));
        }
        allIds.forEach(i -> {
            Attendee attendeeOnRight;
            Attendee attendeeOnLeft = before != null ? (Attendee)before.get((String)i).orElse(null) : null;
            Attendee attendee = attendeeOnRight = after != null ? (Attendee)after.get((String)i).orElse(null) : null;
            if (attendeeOnLeft != null && attendeeOnRight != null) {
                if (AttendeeLifeCycleEventNotifier.areDifferent(attendeeOnLeft, attendeeOnRight)) {
                    notifier.notifyEventOn(ResourceEvent.Type.UPDATE, subtype, attendeeOnLeft, attendeeOnRight);
                }
            } else if (attendeeOnRight != null) {
                notifier.notifyEventOn(ResourceEvent.Type.CREATION, subtype, attendeeOnRight);
            } else {
                notifier.notifyEventOn(ResourceEvent.Type.DELETION, subtype, attendeeOnLeft);
            }
        });
    }

    private static boolean areDifferent(Attendee attendeeOnLeft, Attendee attendeeOnRight) {
        return attendeeOnLeft.getPresenceStatus() != attendeeOnRight.getPresenceStatus() || attendeeOnLeft.getParticipationStatus() != attendeeOnRight.getParticipationStatus();
    }
}

