/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core;

import java.text.MessageFormat;
import java.util.stream.Stream;

public class SilverpeasExceptionMessages {
    private static final MessageFormat ADDING_FAILURE = new MessageFormat("Fail to add {0} {1}");
    private static final MessageFormat UPDATE_FAILURE = new MessageFormat("Fail to update {0} {1}");
    private static final MessageFormat DELETION_FAILURE = new MessageFormat("Fail to delete {0} {1}");
    private static final MessageFormat REMOVE_FAILURE = new MessageFormat("Fail to remove {0} {1}");
    private static final MessageFormat GETTING_FAILURE = new MessageFormat("Fail to get {0} {1}");
    private static final MessageFormat MOVE_FAILURE = new MessageFormat("Fail to move {0} {1} to {2} {3}");
    private static final MessageFormat RESTORATION_FAILURE = new MessageFormat("Fail to restore {0} {1}");
    private static final MessageFormat VALIDATION_FAILURE = new MessageFormat("Fail to validate {0} {1}");
    private static final MessageFormat INDEXATION_FAILURE = new MessageFormat("Fail to index {0} {1}");
    private static final MessageFormat UNINDEXATION_FAILURE = new MessageFormat("Fail to unindex {0} {1}");
    private static final MessageFormat CONNECION_OPENING_FAILURE = new MessageFormat("Fail to open connection to {0}");
    private static final MessageFormat CONNECION_CLOSING_FAILURE = new MessageFormat("Fail to close connection to {0}");
    private static final MessageFormat CONNECTION_FAILURE = new MessageFormat("Fail to connect/access {0}");
    private static final MessageFormat UNAVAILABLE_RESOURCE = new MessageFormat("{0} {1} not found");
    private static final MessageFormat UNDEFINED_RESOURCE = new MessageFormat("{0} identifier not defined");
    private static final MessageFormat RENDERING_FAILURE = new MessageFormat("Fail to render {0} {1}");
    private static final MessageFormat OPENING_FILE_FAILURE = new MessageFormat("Fail to open file {0}");
    private static final MessageFormat CLOSING_FILE_FAILURE = new MessageFormat("Fail to close file {0}");
    private static final MessageFormat SUBSCRIPTION_FAILURE = new MessageFormat("Fail to subscribe to {0} {1}");
    private static final MessageFormat UNSUBSCRIPTION_FAILURE = new MessageFormat("Fail to unsubscribe to {0} {1}");

    private SilverpeasExceptionMessages() {
    }

    public static String failureOnAdding(String resource, Object id) {
        return ADDING_FAILURE.format(new Object[]{resource, id == null ? "" : id});
    }

    public static String failureOnUpdate(String resource, Object id) {
        return UPDATE_FAILURE.format(new Object[]{resource, id});
    }

    public static String failureOnRemoving(String resource, Object id) {
        return REMOVE_FAILURE.format(new Object[]{resource, id});
    }

    public static String failureOnDeleting(String resource, Object id) {
        return DELETION_FAILURE.format(new Object[]{resource, id});
    }

    public static String failureOnMoving(String resource, Object id, String target, Object targetId) {
        return MOVE_FAILURE.format(new Object[]{resource, id, target, targetId});
    }

    public static String failureOnRestoring(String resource, Object id) {
        return RESTORATION_FAILURE.format(new Object[]{resource, id});
    }

    public static String failureOnGetting(String resource, Object id) {
        return GETTING_FAILURE.format(new Object[]{resource, id});
    }

    public static String failureOnOpeningConnectionTo(String service) {
        return CONNECION_OPENING_FAILURE.format(service);
    }

    public static String failureOnClosingConnectionTo(String service) {
        return CONNECION_CLOSING_FAILURE.format(service);
    }

    public static String failureOnConnecting(String service) {
        return CONNECTION_FAILURE.format(service);
    }

    public static String failureOnValidating(String resource, Object id) {
        return VALIDATION_FAILURE.format(new Object[]{resource, id});
    }

    public static String failureOnIndexing(String resource, Object id) {
        return INDEXATION_FAILURE.format(new Object[]{resource, id});
    }

    public static String failureOnUnindexing(String resource, Object id) {
        return UNINDEXATION_FAILURE.format(new Object[]{resource, id});
    }

    public static String failureOnRendering(String resource, Object id) {
        return RENDERING_FAILURE.format(new Object[]{resource, id});
    }

    public static String failureOnOpeningFile(String resource) {
        return OPENING_FILE_FAILURE.format(new Object[]{resource});
    }

    public static String failureOnClosingFile(String resource) {
        return CLOSING_FILE_FAILURE.format(new Object[]{resource});
    }

    public static String failureOnSubscribing(String resource, String id) {
        return SUBSCRIPTION_FAILURE.format(new Object[]{resource, id});
    }

    public static String failureOnUnsubscribing(String resource, String id) {
        return UNSUBSCRIPTION_FAILURE.format(new Object[]{resource, id});
    }

    public static String unknown(String resource, Object id) {
        return UNAVAILABLE_RESOURCE.format(new Object[]{resource, id});
    }

    public static String undefined(String resource) {
        return UNDEFINED_RESOURCE.format(new Object[]{resource});
    }

    public static class LightExceptionMessage {
        private final Class<?> source;
        private final Exception exception;

        public LightExceptionMessage(Object source, Exception exception) {
            this(source.getClass(), exception);
        }

        public LightExceptionMessage(Class<?> source, Exception exception) {
            this.source = source;
            this.exception = exception;
        }

        public String singleLineWith(String message) {
            String currentClass = this.source.getName();
            return MessageFormat.format("{0} -> {1}", message, Stream.of(this.exception.getStackTrace()).filter(s -> s.getClassName().equals(currentClass)).findFirst().orElseGet(() -> this.exception.getStackTrace()[0]));
        }
    }
}

