/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core;

import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.inject.Singleton;
import org.silverpeas.core.ApplicationService;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Provider
@Singleton
public class ApplicationServiceProvider {
    private static final String CACHE_PREFIX_KEY = ApplicationServiceProvider.class.getSimpleName() + "#";
    public static final String SERVICE_NAME_SUFFIX = "Service";

    public static ApplicationServiceProvider get() {
        return ServiceProvider.getService(ApplicationServiceProvider.class, new Annotation[0]);
    }

    public Optional<ApplicationService> getApplicationServiceById(String appId) {
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        String appName = SilverpeasComponentInstance.getComponentName(appId);
        if (StringUtil.isNotDefined((String)appName)) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable((ApplicationService)cache.computeIfAbsent((Object)(CACHE_PREFIX_KEY + appName), ApplicationService.class, () -> (ApplicationService)ServiceProvider.getService(appId, SERVICE_NAME_SUFFIX)));
        }
        catch (SilverpeasRuntimeException e) {
            SilverLogger.getLogger((Object)this).warn(e.getMessage(), new Object[0]);
            return Optional.empty();
        }
    }
}

