/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.ChannelState;
import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.common.PortletContainerConstants;
import com.sun.portal.portletcontainer.common.PortletContainerRequest;
import com.sun.portal.portletcontainer.common.PortletContainerResponse;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.SecurityRoleRefDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.SharedSessionAttributeDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.PortalContextImpl;
import com.sun.portal.portletcontainer.portlet.impl.PortletSessionImpl;
import com.sun.portal.portletcontainer.portlet.impl.PortletSharedSessionImpl;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletRequestImpl
implements PortletRequest {
    private HttpServletRequest request;
    private PortletContainerRequest pcRequest;
    private PortletContainerResponse pcResponse;
    private PortletContext portletContext;
    private PortalContext portalContext;
    private PortletDescriptor portletDescriptor;
    private PortletSession portletSession;
    private String windowID;
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static Logger logger = ContainerLogger.getLogger(PortletRequestImpl.class, (String)"PAELogMessages");

    protected void init(HttpServletRequest request, HttpServletResponse response, PortletContainerRequest pcRequest, PortletContainerResponse pcResponse, PortletContext portletContext, PortalContext portalContext, PortletDescriptor portletDescriptor, Map<String, Object> scopedAtttributes) {
        this.request = request;
        this.pcRequest = pcRequest;
        this.pcResponse = pcResponse;
        this.portletContext = portletContext;
        this.portalContext = portalContext;
        this.portletDescriptor = portletDescriptor;
        this.windowID = this.pcRequest.getWindowID();
        this.setAttribute("javax.portlet.portletc.portletName", pcRequest.getPortletName());
        this.setAttribute("javax.portlet.portletc.portletWindowName", pcRequest.getPortletWindowName());
        this.setAttribute("javax.portlet.portletc.httpServletRequest", request);
        this.setAttribute("javax.portlet.portletc.httpServletResponse", response);
        Map pcRequestAttributes = this.pcRequest.getAttributes();
        Set pcRequestAttributesEntries = pcRequestAttributes.entrySet();
        for (Map.Entry mapEntry : pcRequestAttributesEntries) {
            this.setAttribute((String)mapEntry.getKey(), mapEntry.getValue());
        }
        if (scopedAtttributes != null && !scopedAtttributes.isEmpty()) {
            Set<Map.Entry<String, Object>> scopedAttributesEntries = scopedAtttributes.entrySet();
            for (Map.Entry<String, Object> mapEntry : scopedAttributesEntries) {
                this.setAttribute(mapEntry.getKey(), mapEntry.getValue());
            }
        }
    }

    protected void clear() {
        this.request = null;
        this.pcRequest = null;
        this.pcResponse = null;
        this.portletContext = null;
        this.portalContext = null;
        this.portletDescriptor = null;
        this.portletSession = null;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    protected PortletContainerRequest getPortletContainerRequest() {
        return this.pcRequest;
    }

    protected PortletContainerResponse getPortletContainerResponse() {
        return this.pcResponse;
    }

    protected PortletContext getPortletContext() {
        return this.portletContext;
    }

    protected PortletDescriptor getPortletDescriptor() {
        return this.portletDescriptor;
    }

    public String getPortletName() {
        return this.getPortletDescriptor().getPortletName();
    }

    public boolean isWindowStateAllowed(WindowState state) {
        boolean retVal = false;
        ChannelState newState = new ChannelState(state.toString());
        if (this.getPortletContainerRequest().getAllowableWindowStates().contains(newState)) {
            retVal = true;
        }
        return retVal;
    }

    public boolean isPortletModeAllowed(PortletMode portletMode) {
        boolean isAllowed = false;
        ChannelMode newMode = new ChannelMode(portletMode.toString());
        if (this.getPortletContainerRequest().getAllowablePortletWindowModes().contains(newMode)) {
            if (portletMode.equals((Object)PortletMode.VIEW)) {
                isAllowed = true;
            } else if (this.getPortletDescriptor() != null) {
                String mimeType = this.getResponseContentType();
                List<String> supportedPortletModes = this.getPortletDescriptor().getSupportedPortletModes(mimeType);
                if (supportedPortletModes != null) {
                    for (int i = 0; i < supportedPortletModes.size() && !isAllowed; ++i) {
                        String mode = supportedPortletModes.get(i);
                        if (!portletMode.toString().equalsIgnoreCase(mode)) continue;
                        isAllowed = true;
                    }
                }
            }
        }
        if (!isAllowed && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "PSPL_PAECSPPI0041", portletMode.toString());
        }
        return isAllowed;
    }

    public PortletPreferences getPreferences() {
        return this.getPortletContainerRequest().getPortletPreferences();
    }

    public PortletSession getPortletSession() {
        return this.getPortletSession(true);
    }

    public PortletSession getPortletSession(boolean create) {
        HttpSession session;
        block11: {
            session = null;
            try {
                session = this.createSession(this.getHttpServletRequest(), create);
            }
            catch (IllegalStateException ise) {
                if (!logger.isLoggable(Level.WARNING)) break block11;
                logger.log(Level.WARNING, "PSPL_PAECSPPI0037", ise.toString());
            }
        }
        if (session != null) {
            String sessionId = (String)this.getHttpServletRequest().getAttribute(PortletContainerConstants.HTTP_SESSION_ID);
            Boolean sessionInvalid = (Boolean)this.getHttpServletRequest().getAttribute("javax.portlet.session_invalid");
            if (!session.getId().equals(sessionId) && Boolean.TRUE.equals(sessionInvalid)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "PSPL_PAECSPPI0039", new String[]{session.getId(), sessionId, String.valueOf(sessionInvalid)});
                }
                if (this.getHttpServletRequest().isRequestedSessionIdValid()) {
                    session.invalidate();
                }
                session = this.createSession(this.getHttpServletRequest(), create);
            }
            if (session != null) {
                if (this.portletSession == null) {
                    this.portletSession = this.createPortletSession(session, this.getPortletContext(), this.getWindowID());
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "PSPL_PAECSPPI0040", this.getWindowID());
                    }
                }
            } else {
                logger.log(Level.WARNING, "PSPL_PAECSPPI0038");
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "PSPL_PAECSPPI0044", this.portletSession);
        }
        this.getPortletContainerRequest().setHttpSession(session);
        return this.portletSession;
    }

    public String getAuthType() {
        return this.getHttpServletRequest().getAuthType();
    }

    public String getRemoteUser() {
        return this.getPortletContainerRequest().getUserID();
    }

    public Principal getUserPrincipal() {
        Principal userPrincipal = this.getPortletContainerRequest().getUserPrincipal();
        if (userPrincipal == null) {
            userPrincipal = this.getHttpServletRequest().getUserPrincipal();
        }
        return userPrincipal;
    }

    public boolean isUserInRole(String role) {
        boolean isInRole = false;
        List<SecurityRoleRefDescriptor> securityRoleRefDescriptors = this.getPortletDescriptor().getSecurityRoleRefDescriptors();
        List<String> portalSupportedRoles = this.getPortletContainerRequest().getRoles();
        if (portalSupportedRoles != null) {
            for (int i = 0; i < securityRoleRefDescriptors.size() && !isInRole; ++i) {
                SecurityRoleRefDescriptor refDescriptor = securityRoleRefDescriptors.get(i);
                String roleName = refDescriptor.getRoleName();
                String roleLink = refDescriptor.getRoleLink();
                if (!role.equalsIgnoreCase(roleName)) continue;
                for (int j = 0; j < portalSupportedRoles.size() && !isInRole; ++j) {
                    String portalSupportedRole = portalSupportedRoles.get(j);
                    if (roleLink != null) {
                        if (!portalSupportedRole.equalsIgnoreCase(roleLink)) continue;
                        isInRole = true;
                        continue;
                    }
                    if (!portalSupportedRole.equalsIgnoreCase(roleName)) continue;
                    isInRole = true;
                }
            }
        }
        return isInRole;
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name should not be null.");
        }
        if (name.equals("javax.portlet.userinfo")) {
            return this.pcRequest.getUserInfo();
        }
        return this.getHttpServletRequest().getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.getHttpServletRequest().getAttributeNames();
    }

    public String getParameter(String name) {
        Map map = this.getParameterMap();
        String retVal = null;
        if (name == null) {
            throw new IllegalArgumentException("Parameter name should not be null.");
        }
        if (map != null) {
            String[] values = (String[])map.get(name);
            if (values == null && this.pcRequest != null) {
                values = (String[])map.get(this.pcRequest.getNamespace() + name);
            }
            if (values != null) {
                retVal = values[0];
            }
        }
        return retVal;
    }

    public Enumeration<String> getParameterNames() {
        HashMap map = new HashMap(this.getParameterMap());
        return Collections.enumeration(map.keySet());
    }

    public String[] getParameterValues(String name) {
        String[] values;
        Map map = this.getParameterMap();
        String[] retVals = null;
        if (name == null) {
            throw new IllegalArgumentException("Parameter name should not be null.");
        }
        if (map != null && (values = (String[])map.get(name)) != null) {
            retVals = values;
        }
        return retVals;
    }

    public Locale getLocale() {
        return this.getPortletContainerRequest().getLocale();
    }

    public Enumeration<Locale> getLocales() {
        ArrayList<Locale> localeList = new ArrayList<Locale>(1);
        localeList.add(this.getPortletContainerRequest().getLocale());
        return Collections.enumeration(localeList);
    }

    public String getScheme() {
        return this.getHttpServletRequest().getScheme();
    }

    public String getServerName() {
        return this.getHttpServletRequest().getServerName();
    }

    public int getServerPort() {
        return this.getHttpServletRequest().getServerPort();
    }

    public boolean isSecure() {
        return this.getHttpServletRequest().isSecure();
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Can not set attribue with null name.");
        }
        this.getHttpServletRequest().setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name should not be null.");
        }
        this.getHttpServletRequest().removeAttribute(name);
    }

    public String getResponseContentType() {
        String responseContentType = this.getPortletContainerRequest().getResponseContentType();
        if (responseContentType == null || responseContentType.length() == 0) {
            responseContentType = DEFAULT_CONTENT_TYPE;
        }
        return responseContentType;
    }

    public Enumeration<String> getResponseContentTypes() {
        List<String> contentTypes = this.getPortletContainerRequest().getAllowableContentTypes();
        List<String> mimeTypes = this.getPortletDescriptor().getSupportedMimeTypes();
        List<Object> returnList = new ArrayList();
        boolean stop = false;
        for (int i = 0; i < contentTypes.size() && !stop; ++i) {
            String contentType = contentTypes.get(i).toLowerCase(Locale.ENGLISH);
            for (int j = 0; j < mimeTypes.size() && !stop; ++j) {
                String mimeType = mimeTypes.get(j).toLowerCase(Locale.ENGLISH);
                if (mimeType.equals("*/*")) {
                    returnList = contentTypes;
                    stop = true;
                    continue;
                }
                if (contentType.equals(mimeType)) {
                    returnList.add(contentType);
                    continue;
                }
                if (!mimeType.equals("text/*") || !contentType.startsWith("text/")) continue;
                returnList.add(contentType);
            }
        }
        return Collections.enumeration(returnList);
    }

    public String getProperty(String name) {
        List<String> values;
        Map<String, List<String>> properties;
        if (name == null) {
            throw new IllegalArgumentException("Property name should not be null.");
        }
        String value = this.getHttpServletRequest().getHeader(name);
        if (value == null && (properties = this.pcRequest.getProperties()) != null && properties.size() != 0 && (values = properties.get(name)) != null) {
            value = values.get(0);
        }
        return value;
    }

    public Enumeration<String> getProperties(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name should not be null.");
        }
        Enumeration headers = this.getHttpServletRequest().getHeaders(name);
        if (!headers.hasMoreElements()) {
            List<String> values;
            Map<String, List<String>> properties = this.pcRequest.getProperties();
            if (properties != null && properties.size() != 0 && (values = properties.get(name)) != null) {
                return Collections.enumeration(values);
            }
            List emptyList = Collections.emptyList();
            return Collections.enumeration(emptyList);
        }
        return headers;
    }

    public Enumeration<String> getPropertyNames() {
        Enumeration headerNames = this.getHttpServletRequest().getHeaderNames();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            map.put(name, this.getHttpServletRequest().getHeader(name));
        }
        Map<String, List<String>> properties = this.pcRequest.getProperties();
        if (properties != null && properties.size() != 0) {
            map.putAll(properties);
        }
        return Collections.enumeration(map.keySet());
    }

    public PortalContext getPortalContext() {
        ((PortalContextImpl)this.portalContext).setPortalInfo(this.pcRequest.getPortalInfo());
        return this.portalContext;
    }

    public String getContextPath() {
        String contextPath = (String)this.request.getAttribute("javax.servlet.include.context_path");
        if (contextPath == null || contextPath.length() == 0) {
            contextPath = this.portletContext.getPortletContextName();
            if (contextPath == null || contextPath.length() == 0) {
                return "/";
            }
            return "/" + contextPath;
        }
        return contextPath;
    }

    public String getRequestedSessionId() {
        return this.getHttpServletRequest().getRequestedSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.getHttpServletRequest().isRequestedSessionIdValid();
    }

    public String getWindowID() {
        return this.windowID;
    }

    public Cookie[] getCookies() {
        List<Cookie> cookieProperties = this.pcResponse.getCookieProperties();
        Cookie[] requestCookies = this.request.getCookies();
        int requestCookieLength = 0;
        if (requestCookies != null) {
            requestCookieLength = requestCookies.length;
        }
        if (cookieProperties != null && cookieProperties.size() != 0) {
            Cookie[] cookies = new Cookie[requestCookieLength + cookieProperties.size()];
            for (int i = 0; i < requestCookieLength; ++i) {
                cookies[i] = requestCookies[i];
            }
            int j = requestCookieLength;
            for (Cookie cookie : cookieProperties) {
                cookies[j++] = cookie;
            }
            return cookies;
        }
        return requestCookies;
    }

    protected Map<String, String[]> getPublicPrivateParameterMap(Map<String, String[]> parameters, boolean publicParametersOnly) {
        if (parameters != null) {
            List<String> publicRenderParameters = this.getSupportedPublicRenderParameters();
            HashMap<String, String[]> renderParameters = new HashMap<String, String[]>(parameters.size());
            Set<Map.Entry<String, String[]>> entrySet = parameters.entrySet();
            for (Map.Entry<String, String[]> mapEntry : entrySet) {
                String parameter = mapEntry.getKey();
                if (publicParametersOnly) {
                    if (!publicRenderParameters.contains(parameter)) continue;
                    renderParameters.put(parameter, mapEntry.getValue());
                    continue;
                }
                if (publicRenderParameters.contains(parameter)) continue;
                renderParameters.put(parameter, mapEntry.getValue());
            }
            return Collections.unmodifiableMap(renderParameters);
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpSession createSession(HttpServletRequest request, boolean create) {
        HttpSession session = null;
        if (create) {
            HttpServletRequest httpServletRequest = request;
            synchronized (httpServletRequest) {
                session = request.getSession(true);
            }
        } else {
            session = request.getSession(false);
        }
        if (session != null && session.getId().indexOf("Null") != -1) {
            return null;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "PSPL_PAECSPPI0045", session);
        }
        return session;
    }

    private List<String> getSupportedPublicRenderParameters() {
        List<String> publicRenderParameters = this.portletDescriptor.getSupportedPublicRenderParameterIdentifiers();
        if (publicRenderParameters != null) {
            return publicRenderParameters;
        }
        return Collections.emptyList();
    }

    private PortletSession createPortletSession(HttpSession session, PortletContext portletContext, String windowID) {
        PortletSessionImpl newPortletSession = null;
        if (this.hasSharedSessionAttributes()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "PSPL_PAECSPPI0053", windowID);
            }
            newPortletSession = new PortletSharedSessionImpl(session, portletContext, windowID, this.getPortletContainerRequest());
        } else {
            newPortletSession = new PortletSessionImpl(session, portletContext, windowID);
        }
        return newPortletSession;
    }

    private boolean hasSharedSessionAttributes() {
        List<SharedSessionAttributeDescriptor> sharedSessionAttributeDescriptors = this.getPortletContainerRequest().getSharedSessionAttributeDescriptors();
        return sharedSessionAttributeDescriptors != null && !sharedSessionAttributeDescriptors.isEmpty();
    }
}

