/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.portletcontainer.common.descriptor.PortletXMLDocumentHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class PortletInfoDescriptor {
    public static final String TITLE = "title";
    public static final String SHORT_TITLE = "short-title";
    public static final String KEYWORDS = "keywords";
    private String title;
    private String shortTitle;
    private List keywords = new ArrayList();

    public void load(Element element, String namespaceURI) {
        this.title = PortletXMLDocumentHelper.getChildTextTrim(element, TITLE);
        this.shortTitle = PortletXMLDocumentHelper.getChildTextTrim(element, SHORT_TITLE);
        String keywordsStr = PortletXMLDocumentHelper.getChildTextTrim(element, KEYWORDS);
        if (keywordsStr != null) {
            this.loadKeywords(keywordsStr);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public List getKeywords() {
        return this.keywords;
    }

    private void loadKeywords(String keywordsStr) {
        StringTokenizer st = new StringTokenizer(keywordsStr, ",", false);
        while (st.hasMoreTokens()) {
            String kw = st.nextToken().trim();
            this.keywords.add(kw);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PortletInfoDescriptor ");
        if (this.title != null) {
            sb.append(" title [");
            sb.append(this.title);
            sb.append("]");
        }
        if (this.shortTitle != null) {
            sb.append(" short title [");
            sb.append(this.shortTitle);
            sb.append("]");
        }
        sb.append(" keywords [");
        for (int i = 0; i < this.keywords.size(); ++i) {
            sb.append((String)this.keywords.get(i));
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

