/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.questioncontainer.result.service;

import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.questioncontainer.answer.model.AnswerPK;
import org.silverpeas.core.questioncontainer.result.dao.QuestionResultDAO;
import org.silverpeas.core.questioncontainer.result.model.QuestionResult;
import org.silverpeas.core.questioncontainer.result.model.QuestionResultRuntimeException;
import org.silverpeas.core.questioncontainer.result.model.Results;
import org.silverpeas.core.questioncontainer.result.service.QuestionResultService;

@Service
@Singleton
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultQuestionResultService
implements QuestionResultService {
    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void setQuestionResultToUser(QuestionResult result) {
        Connection con = this.getConnection();
        try {
            QuestionResultDAO.setQuestionResultToUser(con, result);
        }
        catch (Exception e) {
            throw new QuestionResultRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<QuestionResult> getQuestionResultToQuestion(ResourceReference questionPK) {
        Connection con = this.getConnection();
        try {
            Collection<QuestionResult> collection = QuestionResultDAO.getQuestionResultToQuestion(con, questionPK);
            return collection;
        }
        catch (Exception e) {
            throw new QuestionResultRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<QuestionResult> getUserQuestionResultsToQuestion(String userId, ResourceReference questionPK) {
        Connection con = this.getConnection();
        try {
            Collection<QuestionResult> collection = QuestionResultDAO.getUserQuestionResultsToQuestion(con, userId, questionPK);
            return collection;
        }
        catch (Exception e) {
            throw new QuestionResultRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<String> getUsersByAnswer(String answerId) {
        Connection con = this.getConnection();
        try {
            Collection<String> collection = QuestionResultDAO.getUsersByAnswer(con, answerId);
            return collection;
        }
        catch (Exception e) {
            throw new QuestionResultRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteQuestionResultsToQuestion(ResourceReference questionPK) {
        Connection con = this.getConnection();
        try {
            QuestionResultDAO.deleteQuestionResultToQuestion(con, questionPK);
        }
        catch (Exception e) {
            throw new QuestionResultRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<QuestionResult> getQuestionResultToQuestionByParticipation(ResourceReference questionPK, int participationId) {
        Connection con = this.getConnection();
        try {
            Collection<QuestionResult> collection = QuestionResultDAO.getQuestionResultToQuestionByParticipation(con, questionPK, participationId);
            return collection;
        }
        catch (Exception e) {
            throw new QuestionResultRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<QuestionResult> getUserQuestionResultsToQuestionByParticipation(String userId, ResourceReference questionPK, int participationId) {
        Connection con = this.getConnection();
        try {
            Collection<QuestionResult> collection = QuestionResultDAO.getUserQuestionResultsToQuestionByParticipation(con, userId, questionPK, participationId);
            return collection;
        }
        catch (Exception e) {
            throw new QuestionResultRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void setQuestionResultsToUser(Collection<QuestionResult> results) {
        if (results != null) {
            for (QuestionResult questionResult : results) {
                this.setQuestionResultToUser(questionResult);
            }
        }
    }

    @Override
    public QuestionResult getUserAnswerToQuestion(String userId, ResourceReference questionPK, AnswerPK answerPK) {
        Connection con = this.getConnection();
        try {
            QuestionResult questionResult = QuestionResultDAO.getUserAnswerToQuestion(con, userId, questionPK, answerPK);
            return questionResult;
        }
        catch (Exception e) {
            throw new QuestionResultRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Results getResultsOfQuestions(List<ResourceReference> pks) {
        Connection con = this.getConnection();
        try {
            Results results = QuestionResultDAO.getResults(con, pks);
            return results;
        }
        catch (Exception e) {
            throw new QuestionResultRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new QuestionResultRuntimeException(e);
        }
    }
}

