/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.versioning;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.importexport.versioning.DocumentPK;
import org.silverpeas.core.importexport.versioning.DocumentVersion;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Document
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DocumentPK pk;
    private WAPrimaryKey foreignKey;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="description")
    private String description;
    private int status;
    private String instanceId;
    @XmlElementWrapper(name="versions")
    @XmlElement(name="version", namespace="http://www.silverpeas.org/exchange")
    private List<DocumentVersion> versionsType;

    public DocumentPK getPk() {
        return this.pk;
    }

    public void setPk(DocumentPK pk) {
        this.pk = pk;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String toString() {
        return "Worker object : [ pk = " + String.valueOf(this.pk) + ", foreignKey = " + String.valueOf(this.foreignKey) + ", name = " + this.name + ", description = " + this.description + ", status = " + this.status + ", instanceId = " + this.instanceId + " ];";
    }

    public Document copy() {
        Document copy = new Document();
        copy.pk = this.pk;
        copy.foreignKey = this.foreignKey;
        copy.name = this.name;
        copy.description = this.description;
        copy.status = this.status;
        copy.instanceId = this.instanceId;
        if (!this.versionsType.isEmpty()) {
            copy.versionsType = this.versionsType.stream().map(DocumentVersion::copy).collect(Collectors.toList());
        }
        return copy;
    }

    public List<DocumentVersion> getVersionsType() {
        return this.versionsType;
    }

    public void setVersionsType(List<DocumentVersion> versions) {
        this.versionsType = versions;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Document other = (Document)obj;
        if (!(this.pk == other.pk || this.pk != null && this.pk.equals(other.pk))) {
            return false;
        }
        if (!(this.foreignKey == other.foreignKey || this.foreignKey != null && this.foreignKey.equals((Object)other.foreignKey))) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return this.instanceId == null ? other.instanceId == null : this.instanceId.equals(other.instanceId);
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + (this.pk != null ? this.pk.hashCode() : 0);
        hash = 41 * hash + (this.foreignKey != null ? this.foreignKey.hashCode() : 0);
        hash = 41 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 41 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 41 * hash + this.status;
        hash = 41 * hash + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        return hash;
    }
}

