/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.control;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.internet.InternetAddress;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.EntityArrays;
import org.apache.commons.text.translate.LookupTranslator;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.ActifyDocumentProcessor;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.HistorisedDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.model.UnlockContext;
import org.silverpeas.core.contribution.attachment.model.UnlockOption;
import org.silverpeas.core.contribution.attachment.util.AttachmentSettings;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldDisplayer;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.form.TypeManager;
import org.silverpeas.core.contribution.content.form.XMLField;
import org.silverpeas.core.contribution.content.form.displayers.WysiwygFCKFieldDisplayer;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.importexport.attachment.AttachmentDetail;
import org.silverpeas.core.importexport.attachment.AttachmentImportExport;
import org.silverpeas.core.importexport.attachment.AttachmentPK;
import org.silverpeas.core.importexport.control.GEDImportExport;
import org.silverpeas.core.importexport.control.ImportExportFactory;
import org.silverpeas.core.importexport.control.ImportSettings;
import org.silverpeas.core.importexport.control.PublicationImportExport;
import org.silverpeas.core.importexport.form.XMLModelContentType;
import org.silverpeas.core.importexport.model.ImportExportException;
import org.silverpeas.core.importexport.model.RepositoryType;
import org.silverpeas.core.importexport.publication.PublicationContentType;
import org.silverpeas.core.importexport.report.ImportReportManager;
import org.silverpeas.core.importexport.report.MassiveReport;
import org.silverpeas.core.importexport.report.UnitReport;
import org.silverpeas.core.importexport.versioning.VersioningImport;
import org.silverpeas.core.io.media.MetaData;
import org.silverpeas.core.io.media.MetadataExtractor;
import org.silverpeas.core.mail.MailException;
import org.silverpeas.core.mail.extractor.Extractor;
import org.silverpeas.core.mail.extractor.Mail;
import org.silverpeas.core.mail.extractor.MailAttachment;
import org.silverpeas.core.mail.extractor.MailExtractor;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.pdc.pdc.importexport.PdcImportExport;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.error.SilverpeasTransverseErrorUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class RepositoriesTypeManager {
    public static final CharSequenceTranslator ESCAPE_ISO8859_1 = new LookupTranslator(EntityArrays.ISO8859_1_ESCAPE);
    private static final String MAIL_TEMPLATE_NAME = "mail";
    private static final String BODY_XML_FIELD_NAME = "body";
    @Inject
    private PdcImportExport pdcImportExport;

    protected RepositoriesTypeManager() {
    }

    public void processImport(List<RepositoryType> repositoryTypes, ImportSettings settings, ImportReportManager reportManager) {
        for (RepositoryType repType : repositoryTypes) {
            String componentId = repType.getComponentId();
            int topicId = repType.getTopicId();
            String sPath = repType.getPath();
            MassiveReport massiveReport = new MassiveReport();
            reportManager.addMassiveReport(massiveReport, componentId);
            massiveReport.setRepositoryPath(sPath);
            ComponentInst componentInst = OrganizationControllerProvider.getOrganisationController().getComponentInst(componentId);
            if (componentInst == null) {
                massiveReport.setError(1);
                continue;
            }
            reportManager.setComponentName(componentId, componentInst.getLabel());
            File path = new File(sPath);
            if (!path.isDirectory()) {
                massiveReport.setError(3);
                continue;
            }
            GEDImportExport gedIE = ImportExportFactory.createGEDImportExport(settings.getUser(), componentId);
            List<File> children = this.getPathContent(path);
            for (File file : children) {
                this.processFile(file, topicId, settings, reportManager, repType, massiveReport, gedIE);
            }
        }
    }

    private void processFile(File file, int topicId, ImportSettings settings, ImportReportManager reportManager, RepositoryType repType, MassiveReport massiveReport, GEDImportExport gedIE) {
        if (file.isFile()) {
            settings.setFolderId(String.valueOf(topicId));
            this.importFile(null, file, reportManager, massiveReport, gedIE, this.pdcImportExport, settings);
        } else if (file.isDirectory()) {
            switch (repType.getMassiveTypeInt()) {
                case 0: {
                    break;
                }
                case 1: {
                    settings.setPathToImport(file.getAbsolutePath());
                    this.processImportRecursiveNoReplicate(reportManager, massiveReport, gedIE, this.pdcImportExport, settings);
                    break;
                }
                case 2: {
                    try {
                        NodeDetail nodeDetail = gedIE.addSubTopicToTopic(file, topicId, massiveReport);
                        settings.setPathToImport(file.getAbsolutePath());
                        settings.setFolderId(nodeDetail.getNodePK().getId());
                        this.processImportRecursiveReplicate(reportManager, massiveReport, gedIE, this.pdcImportExport, settings);
                    }
                    catch (ImportExportException ex) {
                        massiveReport.setError(3);
                    }
                    break;
                }
                default: {
                    SilverLogger.getLogger((Object)this).warn("Unknown repository type: " + repType.getMassiveTypeInt(), new Object[0]);
                }
            }
        }
    }

    private PublicationDetail importFile(PublicationDetail previousSavedPublication, File file, ImportReportManager reportManager, MassiveReport massiveReport, GEDImportExport gedIE, PdcImportExport pdcIE, ImportSettings settings) {
        String componentId = gedIE.getCurrentComponentId();
        UserDetail userDetail = gedIE.getCurrentUserDetail();
        try {
            UnitReport unitReport = new UnitReport();
            massiveReport.addUnitReport(unitReport);
            long maximumFileSize = FileRepositoryManager.getUploadMaximumFileSize();
            long fileSize = file.length();
            if (fileSize <= 0L) {
                unitReport.setError(2);
                reportManager.addNumberOfFilesNotImported(1);
                return null;
            }
            if (fileSize > maximumFileSize) {
                unitReport.setError(13);
                reportManager.addNumberOfFilesNotImported(1);
                return null;
            }
            PublicationDetail pubDetailToSave = this.fetchPublicationDetail(previousSavedPublication, componentId, file, gedIE, pdcIE, settings, unitReport);
            if (!settings.mustCreateOnePublicationForAllFiles() && FileUtil.isMail((String)file.getName())) {
                this.processMailContent(pubDetailToSave, file, reportManager, unitReport, gedIE, settings.isVersioningUsed());
            }
            Date creationDate = new Date();
            if (settings.useFileDates() && !settings.mustCreateOnePublicationForAllFiles()) {
                creationDate = pubDetailToSave.getLastUpdateDate() != null ? pubDetailToSave.getLastUpdateDate() : pubDetailToSave.getCreationDate();
            }
            AttachmentDescriptor descriptor = new AttachmentDescriptor().setCurrentUser((User)userDetail).setComponentId(componentId).setResourceId(pubDetailToSave.getPK().getId()).setDocumentType(DocumentType.attachment).setFile(file).setContentLanguage(settings.getContentLanguage()).setTitle(settings.getSingleFileTitle()).setDescription(settings.getSingleFileDescription()).setCreationDate(creationDate).setUseFileMetadata(settings.isUseFileMetadata()).setHasToBeIndexed(pubDetailToSave.isIndexable()).setComponentVersionActivated(settings.isVersioningUsed()).setPublicVersionRequired(settings.getVersionType() == 0).setVersionComment(settings.getVersionComment());
            SimpleDocument document = RepositoriesTypeManager.handleFileToAttach(descriptor);
            reportManager.addNumberOfFilesProcessed(1);
            reportManager.addImportedFileSize(document.getSize(), componentId);
            return pubDetailToSave;
        }
        catch (Exception ex) {
            massiveReport.setError(0);
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
            SilverpeasTransverseErrorUtil.throwTransverseErrorIfAny((Exception)ex, (String)I18NHelper.DEFAULT_LANGUAGE);
            return null;
        }
    }

    private PublicationDetail fetchPublicationDetail(PublicationDetail previousSavedPublication, String componentId, File file, GEDImportExport gedIE, PdcImportExport pdcIE, ImportSettings settings, UnitReport unitReport) throws PdcException {
        PublicationDetail pubDetailToSave;
        if (!settings.mustCreateOnePublicationForAllFiles() || previousSavedPublication == null) {
            pubDetailToSave = PublicationImportExport.convertFileInfoToPublicationDetail(file, settings);
            pubDetailToSave.setPk(new PublicationPK("unknown", "useless", componentId));
            if (settings.isDraftUsed() && pdcIE.isClassifyingMandatory(componentId) || settings.isDraftUsed()) {
                pubDetailToSave.setStatus("Draft");
                pubDetailToSave.setStatusMustBeChecked(false);
            }
            pubDetailToSave = gedIE.createPublicationForMassiveImport(unitReport, pubDetailToSave, settings);
            unitReport.setLabel(pubDetailToSave.getPK().getId());
        } else {
            pubDetailToSave = previousSavedPublication;
        }
        return pubDetailToSave;
    }

    public static SimpleDocument handleFileToAttach(AttachmentDescriptor descriptor) throws IOException {
        boolean publicVersion;
        SimpleDocumentPK documentPK = RepositoriesTypeManager.createDocumentPK(descriptor);
        SimpleDocument document = AttachmentServiceProvider.getAttachmentService().findExistingDocument(documentPK, descriptor.getFile().getName(), descriptor.getResourceReference(), descriptor.getContentLanguage());
        boolean needCreation = document == null || !document.isVersioned() || !document.getAttachment().getLanguage().equalsIgnoreCase(descriptor.getContentLanguage());
        boolean bl = publicVersion = descriptor.isComponentVersionActivated() && descriptor.isPublicVersionRequired();
        if (needCreation) {
            document = RepositoriesTypeManager.initializeDocument(documentPK, descriptor);
            boolean notifying = !document.isVersioned() || publicVersion;
            document = AttachmentServiceProvider.getAttachmentService().createAttachment(document, descriptor.getFile(), descriptor.isHasToBeIndexed(), notifying);
        } else {
            document.setLanguage(descriptor.getContentLanguage());
            document.setPublicDocument(publicVersion);
            document.edit(descriptor.getCurrentUser().getId());
            AttachmentServiceProvider.getAttachmentService().updateAttachment(document, descriptor.getFile(), descriptor.isHasToBeIndexed(), publicVersion);
            UnlockContext unlockContext = new UnlockContext(document.getId(), descriptor.getCurrentUser().getId(), descriptor.getContentLanguage(), "");
            unlockContext.addOption(UnlockOption.UPLOAD);
            if (!publicVersion) {
                unlockContext.addOption(UnlockOption.PRIVATE_VERSION);
            }
            AttachmentServiceProvider.getAttachmentService().unlock(unlockContext);
        }
        ActifyDocumentProcessor.getProcessor().process(document);
        return document;
    }

    private static SimpleDocumentPK createDocumentPK(AttachmentDescriptor descriptor) {
        SimpleDocumentPK documentPK = new SimpleDocumentPK(null, descriptor.getComponentId());
        if (StringUtil.isDefined((String)descriptor.getOldSilverpeasId())) {
            if (StringUtil.isInteger((String)descriptor.getOldSilverpeasId())) {
                documentPK.setOldSilverpeasId(Long.parseLong(descriptor.getOldSilverpeasId()));
            } else {
                documentPK.setId(descriptor.getOldSilverpeasId());
            }
        }
        return documentPK;
    }

    private static SimpleDocument initializeDocument(SimpleDocumentPK documentPK, AttachmentDescriptor descriptor) {
        HistorisedDocument document;
        File file = descriptor.getFile();
        String fileName = file.getName();
        long fileSize = file.length();
        String mimeType = FileUtil.getMimeType((String)fileName);
        String docTitle = StringUtil.defaultStringIfNotDefined((String)descriptor.getTitle());
        String docDescription = StringUtil.defaultStringIfNotDefined((String)descriptor.getDescription());
        if (descriptor.isUseFileMetadata()) {
            MetadataExtractor extractor = MetadataExtractor.get();
            MetaData metadata = extractor.extractMetadata(file);
            String metadataTitle = StringUtil.defaultStringIfNotDefined((String)docTitle, (String)metadata.getTitle());
            docTitle = StringUtil.defaultStringIfNotDefined((String)metadataTitle, (String)fileName);
            docDescription = StringUtil.defaultStringIfNotDefined((String)docDescription, (String)metadata.getSubject());
        }
        SimpleAttachment attachment = SimpleAttachment.builder((String)descriptor.contentLanguage).setFilename(fileName).setTitle(docTitle).setDescription(docDescription).setSize(fileSize).setContentType(mimeType).setCreationData(descriptor.getCurrentUser().getId(), descriptor.getCreationDate()).build();
        if (descriptor.isComponentVersionActivated()) {
            document = new HistorisedDocument(documentPK, descriptor.resourceId, 0, descriptor.getCurrentUser().getId(), attachment);
            document.setPublicDocument(descriptor.isPublicVersionRequired());
            if (StringUtil.isDefined((String)descriptor.getVersionComment())) {
                document.setComment(descriptor.getVersionComment());
            }
        } else {
            document = new SimpleDocument(new SimpleDocumentPK(null, descriptor.getComponentId()), descriptor.getResourceId(), 0, false, attachment);
        }
        document.setDocumentType(descriptor.getDocumentType());
        return document;
    }

    private void processMailContent(PublicationDetail pubDetail, File file, ImportReportManager reportManager, UnitReport unitReport, GEDImportExport gedIE, boolean isVersioningUsed) throws ImportExportException {
        String componentId = gedIE.getCurrentComponentId();
        UserDetail userDetail = gedIE.getCurrentUserDetail();
        MailExtractor extractor = null;
        Mail mail = null;
        try {
            extractor = Extractor.getExtractor((File)file);
            mail = extractor.getMail();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Cannot extract mail data", (Throwable)e);
        }
        if (mail != null) {
            String content = mail.getBody();
            PublicationContentType pubContent = new PublicationContentType();
            XMLModelContentType modelContent = new XMLModelContentType(MAIL_TEMPLATE_NAME);
            pubContent.setXMLModelContentType(modelContent);
            ArrayList<XMLField> fields = new ArrayList<XMLField>();
            modelContent.setFields(fields);
            XMLField subject = new XMLField("subject", mail.getSubject());
            fields.add(subject);
            XMLField body2 = new XMLField(BODY_XML_FIELD_NAME, ESCAPE_ISO8859_1.translate((CharSequence)content));
            fields.add(body2);
            XMLField date = new XMLField("date", DateUtil.getOutputDateAndHour((Date)mail.getDate(), (String)"fr"));
            fields.add(date);
            InternetAddress address = mail.getFrom();
            Object from = "";
            if (StringUtil.isDefined((String)address.getPersonal())) {
                from = (String)from + address.getPersonal() + " - ";
            }
            from = (String)from + "<a href=\"mailto:" + address.getAddress() + "\">" + address.getAddress() + "</a>";
            XMLField fieldFROM = new XMLField("from", (String)from);
            fields.add(fieldFROM);
            Address[] recipients = mail.getAllRecipients();
            StringBuilder to = new StringBuilder();
            for (Address recipient : recipients) {
                InternetAddress ia = (InternetAddress)recipient;
                if (StringUtil.isDefined((String)ia.getPersonal())) {
                    to.append(ia.getPersonal()).append(" - ");
                }
                to.append("<a href=\"mailto:").append(ia.getAddress()).append("\">").append(ia.getAddress()).append("</a></br>");
            }
            XMLField fieldTO = new XMLField("to", to.toString());
            fields.add(fieldTO);
            gedIE.createPublicationContent(reportManager, unitReport, Integer.parseInt(pubDetail.getPK().getId()), pubContent, userDetail.getId(), null);
            try {
                List<AttachmentDetail> documents = this.extractAttachmentsFromMail(componentId, userDetail, extractor);
                this.saveMailAttachments(componentId, pubDetail, documents, userDetail, gedIE, isVersioningUsed);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private List<AttachmentDetail> extractAttachmentsFromMail(String componentId, UserDetail userDetail, MailExtractor extractor) throws MailException {
        ArrayList<AttachmentDetail> documents = new ArrayList<AttachmentDetail>();
        List attachments = extractor.getAttachments();
        for (MailAttachment attachment : attachments) {
            if (attachment == null) continue;
            AttachmentDetail attDetail = new AttachmentDetail();
            AttachmentPK pk = new AttachmentPK("unknown", "useless", componentId);
            attDetail.setLogicalName(attachment.getName());
            attDetail.setPhysicalName(attachment.getPath());
            attDetail.setAuthor(userDetail.getId());
            attDetail.setSize(attachment.getSize());
            attDetail.setPK(pk);
            attDetail.setMailContentID(attachment.getContentID());
            documents.add(attDetail);
        }
        return documents;
    }

    private void saveMailAttachments(String componentId, PublicationDetail pubDetail, List<AttachmentDetail> documents, UserDetail userDetail, GEDImportExport gedIE, boolean isVersioningUsed) throws IOException {
        List<Pair<AttachmentDetail, SimpleDocument>> importedDocuments;
        if (isVersioningUsed) {
            VersioningImport versioningIE = new VersioningImport(userDetail);
            importedDocuments = versioningIE.importDocuments(pubDetail.getPK().getId(), componentId, documents, pubDetail.isIndexable());
        } else {
            AttachmentImportExport attachmentIE = new AttachmentImportExport(gedIE.getCurrentUserDetail());
            importedDocuments = attachmentIE.importAttachments(pubDetail.getPK().getId(), componentId, documents, pubDetail.isIndexable());
        }
        try {
            this.adjustAttachmentUrlIntoContent(componentId, pubDetail, importedDocuments);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    private void adjustAttachmentUrlIntoContent(String componentId, PublicationDetail pubDetail, List<Pair<AttachmentDetail, SimpleDocument>> importedDocuments) throws SilverpeasException {
        FieldTemplate fieldTemplate;
        String templateId;
        PublicationTemplateManager templateManager;
        PublicationTemplate pubTemplateFrom;
        RecordSet set;
        DataRecord data;
        Field body2;
        if (!importedDocuments.isEmpty() && (body2 = (data = (set = (pubTemplateFrom = (templateManager = PublicationTemplateManager.getInstance()).getPublicationTemplate(templateId = componentId + ":mail")).getRecordSet()).getRecord(pubDetail.getId())).getField(BODY_XML_FIELD_NAME)) != null && (fieldTemplate = pubTemplateFrom.getRecordTemplate().getFieldTemplate(BODY_XML_FIELD_NAME)) != null) {
            PagesContext formContext = new PagesContext();
            formContext.setComponentId(componentId);
            formContext.setObjectId(pubDetail.getId());
            formContext.setContentLanguage(pubDetail.getLanguage());
            FieldDisplayer fieldDisplayer = TypeManager.getInstance().getDisplayer(body2.getTypeName(), fieldTemplate.getDisplayerName());
            String bodyValue = WysiwygFCKFieldDisplayer.getContentFromFile((String)formContext.getComponentId(), (String)formContext.getObjectId(), (String)BODY_XML_FIELD_NAME, (String)formContext.getContentLanguage());
            Mutable mailContent = Mutable.of((Object)bodyValue);
            importedDocuments.stream().filter(p2 -> StringUtil.isDefined((String)((AttachmentDetail)p2.getFirst()).getMailContentID())).forEach(p2 -> {
                SimpleDocument document = (SimpleDocument)p2.getSecond();
                String url = URLUtil.getApplicationURL() + document.getAttachmentURL();
                String contentID = ((AttachmentDetail)p2.getFirst()).getMailContentID();
                String pattern = "src=\"cid:" + contentID.replaceAll("[<>]", "") + "\"";
                String replacement = "src=\"" + url + "\"";
                mailContent.set((Object)((String)mailContent.get()).replace(pattern, replacement));
            });
            if (!bodyValue.equals(mailContent.get())) {
                fieldDisplayer.update((String)mailContent.get(), body2, fieldTemplate, formContext);
            }
        }
    }

    public void processImportRecursiveNoReplicate(ImportReportManager reportManager, MassiveReport massiveReport, GEDImportExport gedIE, PdcImportExport pdcIE, ImportSettings settings) {
        List<File> children = this.getPathContent(new File(settings.getPathToImport()));
        for (File file : children) {
            if (file.isFile()) {
                this.importFile(null, file, reportManager, massiveReport, gedIE, pdcIE, settings);
                continue;
            }
            if (!file.isDirectory()) continue;
            settings.setPathToImport(file.getAbsolutePath());
            this.processImportRecursiveNoReplicate(reportManager, massiveReport, gedIE, pdcIE, settings);
        }
    }

    public List<PublicationDetail> processImportRecursiveReplicate(ImportReportManager reportManager, MassiveReport massiveReport, GEDImportExport gedIE, PdcImportExport pdcIE, ImportSettings settings) throws ImportExportException {
        ArrayList<PublicationDetail> publications = new ArrayList<PublicationDetail>();
        File path = new File(settings.getPathToImport());
        List<File> children = this.getPathContent(path);
        PublicationDetail publication = null;
        for (File file : children) {
            if (file.isFile()) {
                if ((publication = this.importFile(publication, file, reportManager, massiveReport, gedIE, pdcIE, settings)) == null || settings.mustCreateOnePublicationForAllFiles() && !publications.isEmpty()) continue;
                publications.add(publication);
                continue;
            }
            if (!file.isDirectory()) continue;
            NodeDetail nodeDetail = gedIE.addSubTopicToTopic(file, Integer.parseInt(settings.getFolderId()), massiveReport);
            ImportSettings recursiveSettings = settings.clone();
            recursiveSettings.setPathToImport(file.getAbsolutePath());
            recursiveSettings.setFolderId(nodeDetail.getNodePK().getId());
            publications.addAll(this.processImportRecursiveReplicate(reportManager, massiveReport, gedIE, pdcIE, recursiveSettings));
        }
        return publications;
    }

    private List<File> getPathContent(File path) {
        Object[] listContenuStringPath = path.list();
        if (listContenuStringPath != null) {
            Arrays.sort(listContenuStringPath);
        }
        return this.convertListStringToListFile((String[])listContenuStringPath, path.getPath());
    }

    private List<File> convertListStringToListFile(String[] listFileName, String path) {
        ArrayList<File> listFile = new ArrayList<File>();
        if (listFileName != null) {
            for (String aListFileName : listFileName) {
                listFile.add(new File(path + File.separator + aListFileName));
            }
        }
        return listFile;
    }

    public static class AttachmentDescriptor {
        private User currentUser = null;
        private String componentId = null;
        private String resourceId = null;
        private String oldSilverpeasId = null;
        private DocumentType documentType = null;
        private File file = null;
        private boolean useFileMetadata = AttachmentSettings.isUseFileMetadataForAttachmentDataEnabled();
        private String contentLanguage = null;
        private String title;
        private String description;
        private Date creationDate = null;
        private boolean hasToBeIndexed;
        private boolean isComponentVersionActivated;
        private boolean publicVersionRequired;
        private String versionComment;

        public User getCurrentUser() {
            return this.currentUser;
        }

        public AttachmentDescriptor setCurrentUser(User currentUser) {
            this.currentUser = currentUser;
            return this;
        }

        public String getComponentId() {
            return this.componentId;
        }

        public AttachmentDescriptor setComponentId(String componentId) {
            this.componentId = this.verifyTaintedData(componentId);
            return this;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public AttachmentDescriptor setResourceId(String resourceId) {
            this.resourceId = this.verifyTaintedData(resourceId);
            return this;
        }

        public String getOldSilverpeasId() {
            return this.oldSilverpeasId;
        }

        public AttachmentDescriptor setOldSilverpeasId(String oldSilverpeasId) {
            this.oldSilverpeasId = this.verifyTaintedData(oldSilverpeasId);
            return this;
        }

        public DocumentType getDocumentType() {
            return this.documentType;
        }

        public AttachmentDescriptor setDocumentType(DocumentType documentType) {
            this.documentType = documentType;
            return this;
        }

        public File getFile() {
            return this.file;
        }

        public AttachmentDescriptor setFile(File file) {
            this.file = file;
            return this;
        }

        public boolean isUseFileMetadata() {
            return this.useFileMetadata;
        }

        public AttachmentDescriptor setUseFileMetadata(boolean useFileMetadata) {
            this.useFileMetadata = useFileMetadata;
            return this;
        }

        public String getContentLanguage() {
            return this.contentLanguage;
        }

        public AttachmentDescriptor setContentLanguage(String contentLanguage) {
            this.contentLanguage = this.verifyTaintedData(contentLanguage);
            return this;
        }

        public String getTitle() {
            return this.title;
        }

        public AttachmentDescriptor setTitle(String title2) {
            this.title = title2;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public AttachmentDescriptor setDescription(String description) {
            this.description = description;
            return this;
        }

        public Date getCreationDate() {
            return this.creationDate;
        }

        public AttachmentDescriptor setCreationDate(Date creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public boolean isHasToBeIndexed() {
            return this.hasToBeIndexed;
        }

        public AttachmentDescriptor setHasToBeIndexed(boolean hasToBeIndexed) {
            this.hasToBeIndexed = hasToBeIndexed;
            return this;
        }

        public boolean isComponentVersionActivated() {
            return this.isComponentVersionActivated;
        }

        public AttachmentDescriptor setComponentVersionActivated(boolean componentVersionActivated) {
            this.isComponentVersionActivated = componentVersionActivated;
            return this;
        }

        public boolean isPublicVersionRequired() {
            return this.publicVersionRequired;
        }

        public AttachmentDescriptor setPublicVersionRequired(boolean publicVersionRequired) {
            this.publicVersionRequired = publicVersionRequired;
            return this;
        }

        public String getVersionComment() {
            return this.versionComment;
        }

        public AttachmentDescriptor setVersionComment(String versionComment) {
            this.versionComment = versionComment;
            return this;
        }

        public ResourceReference getResourceReference() {
            return new ResourceReference(this.resourceId, this.componentId);
        }

        private String verifyTaintedData(String value) {
            if (StringUtil.isDefined((String)value) && value.contains("..")) {
                throw new IllegalArgumentException(String.format("Value '%s' is forbidden", value));
            }
            return value;
        }
    }
}

