/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.session;

import java.util.Optional;
import java.util.function.Predicate;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.security.session.SessionManagement;
import org.silverpeas.core.security.session.SessionManagementProvider;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.web.token.SilverpeasWebTokenService;

@WebService
@Path(value="session/token")
@Authenticated
public class SilverpeasUserSessionTokenResource
extends RESTWebService {
    protected static final String PATH = "session/token";

    public void validateUserAuthentication(UserPrivilegeValidation validation) {
        super.validateUserAuthentication(validation.skipLastUserAccessTimeRegistering(this.getHttpServletRequest()));
    }

    @GET
    public Response getToken() {
        String sessionId = Optional.ofNullable(this.getHttpServletRequest().getSession(false)).map(HttpSession::getId).map(arg_0 -> ((SessionManagement)SessionManagementProvider.getSessionManagement()).getSessionInfo(arg_0)).filter(Predicate.not(SessionInfo::isAnonymous)).map(SessionInfo::getId).orElseThrow(() -> new WebApplicationException("User Session does not exist", Response.Status.NOT_FOUND));
        SilverpeasWebTokenService.WebToken token = SilverpeasWebTokenService.get().generateFor(sessionId);
        return Response.ok((Object)JSONCodec.encodeObject(o -> o.put("token", token.getValue()))).build();
    }

    public String getComponentId() {
        return null;
    }

    protected String getResourceBasePath() {
        return PATH;
    }
}

