/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.selection;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.silverpeas.core.BasicIdentifier;
import org.silverpeas.core.SilverpeasResource;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.selection.SelectionBasket;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.selection.BasketItem;
import org.silverpeas.core.webapi.selection.SelectionBasketEntry;

@WebService
@Authenticated
@Path(value="selection")
public class SelectionBasketResource
extends RESTWebService {
    static final String BASE_URI_PATH = "selection";

    @GET
    @Produces(value={"application/json"})
    public List<SelectionBasketEntry> getAll() {
        SelectionBasket basket = SelectionBasket.get();
        return this.listBasketEntries(basket);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response putInBasket(SelectionBasketEntry entry) {
        this.checkEntryIsValid(entry);
        SelectionBasket basket = SelectionBasket.get();
        basket.put((SilverpeasResource)entry.getItem(), entry.getContext());
        return Response.created((URI)this.identifiedBy(entry.getItem().getIdentifier().asString())).entity(this.listBasketEntries(basket)).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    public List<SelectionBasketEntry> pop() {
        SelectionBasket basket = SelectionBasket.get();
        Optional resource = basket.pop();
        if (resource.isEmpty()) {
            throw new NotFoundException("No resource to pop in the basket");
        }
        return this.listBasketEntries(basket);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/item/{id}")
    public List<SelectionBasketEntry> deleteFromBasket(@PathParam(value="id") String itemId) {
        SelectionBasket basket = SelectionBasket.get();
        SilverpeasResource resource = basket.getSelectedResources().filter(e -> e.getResource().getIdentifier().asString().equals(itemId)).findFirst().orElseThrow(() -> new NotFoundException(String.format("No such resource %s in the basket", itemId))).getResource();
        basket.remove(resource);
        return this.listBasketEntries(basket);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/index/{index}")
    public List<SelectionBasketEntry> removeFromBasket(@PathParam(value="index") int index) {
        SelectionBasket basket = SelectionBasket.get();
        Optional entry = basket.removeAt(index);
        if (entry.isEmpty()) {
            throw new NotFoundException(String.format("No such resource at index %d in the basket", index));
        }
        return this.listBasketEntries(basket);
    }

    public String getComponentId() {
        return null;
    }

    protected String getResourceBasePath() {
        return BASE_URI_PATH;
    }

    private URI identifiedBy(String id) {
        return super.identifiedBy(this.getUri().getAbsoluteWebResourcePathBuilder(), new String[]{"/item/", id});
    }

    private List<SelectionBasketEntry> listBasketEntries(SelectionBasket basket) {
        return basket.getSelectedResources().map(SelectionBasketEntry::from).map(SelectionBasketEntry::reload).map(e -> e.withURI(this.identifiedBy(e.getItem().getIdentifier().asString()))).collect(Collectors.toList());
    }

    private void checkEntryIsValid(SelectionBasketEntry entry) {
        if (entry == null || entry.getItem() == null || entry.getItem().getIdentifier() == null) {
            throw new BadRequestException();
        }
        BasketItem item = entry.getItem();
        if (!(item.getIdentifier() instanceof ContributionIdentifier) && !(item.getIdentifier() instanceof BasicIdentifier)) {
            throw new BadRequestException();
        }
    }
}

