/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.calendar;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.calendar.Attendee;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.notification.CalendarEventUserNotificationReminder;
import org.silverpeas.core.contribution.attachment.model.Attachments;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.importexport.ExportDescriptor;
import org.silverpeas.core.importexport.ExportException;
import org.silverpeas.core.importexport.ImportException;
import org.silverpeas.core.io.upload.FileUploadManager;
import org.silverpeas.core.io.upload.UploadedFile;
import org.silverpeas.core.pdc.pdc.model.PdcClassification;
import org.silverpeas.core.pdc.pdc.model.PdcPosition;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.reminder.DurationReminder;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.http.RequestParameterDecoder;
import org.silverpeas.core.web.mvc.webcomponent.WebMessager;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.webapi.calendar.AbstractCalendarResource;
import org.silverpeas.core.webapi.calendar.CalendarEntity;
import org.silverpeas.core.webapi.calendar.CalendarEventAttendeeAnswerEntity;
import org.silverpeas.core.webapi.calendar.CalendarEventAttendeeEntity;
import org.silverpeas.core.webapi.calendar.CalendarEventAttributeEntity;
import org.silverpeas.core.webapi.calendar.CalendarEventEntity;
import org.silverpeas.core.webapi.calendar.CalendarEventOccurrenceDeleteEntity;
import org.silverpeas.core.webapi.calendar.CalendarEventOccurrenceEntity;
import org.silverpeas.core.webapi.calendar.CalendarEventOccurrenceRequestParameters;
import org.silverpeas.core.webapi.calendar.CalendarEventOccurrenceUpdateEntity;
import org.silverpeas.core.webapi.calendar.CalendarWebManager;
import org.silverpeas.core.webapi.calendar.ParticipantCalendarEventOccurrencesEntity;
import org.silverpeas.core.webapi.reminder.ReminderEntity;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="calendar/{componentInstanceId}")
@Authorized
public class CalendarResource
extends AbstractCalendarResource {
    @GET
    @Produces(value={"application/json"})
    public List<CalendarEntity> getCalendars() {
        List calendars = (List)this.process(() -> this.getCalendarWebManager().getCalendarsHandledBy(this.getComponentId())).execute();
        return this.asWebEntities(calendars);
    }

    @GET
    @Path(value="{calendarId}")
    @Produces(value={"application/json"})
    public CalendarEntity getCalendar(@PathParam(value="calendarId") String calendarId) {
        Calendar calendar = (Calendar)this.process(() -> Calendar.getById((String)calendarId)).execute();
        CalendarWebManager.assertDataConsistency(this.getComponentId(), calendar);
        return this.asWebEntity(calendar);
    }

    @POST
    @Produces(value={"application/json"})
    public CalendarEntity createCalendar(CalendarEntity calendarEntity) {
        Calendar calendar = new Calendar(this.getComponentId(), calendarEntity.getTitle());
        calendarEntity.merge(calendar);
        Calendar createdCalendar = (Calendar)this.process(() -> this.getCalendarWebManager().saveCalendar(calendar)).execute();
        if (createdCalendar.isSynchronized()) {
            this.synchronizeCalendar(createdCalendar);
        }
        return this.asWebEntity(createdCalendar);
    }

    @PUT
    @Path(value="{calendarId}")
    @Produces(value={"application/json"})
    public CalendarEntity updateCalendar(@PathParam(value="calendarId") String calendarId, CalendarEntity calendarEntity) {
        Calendar calendar = Calendar.getById((String)calendarId);
        CalendarWebManager.assertDataConsistency(this.getComponentId(), calendar);
        boolean synchronizedRequired = calendar.isSynchronized() && !calendar.getExternalCalendarUrl().toString().equals(calendarEntity.getExternalUrl().toString());
        calendarEntity.merge(calendar);
        Calendar updatedCalendar = (Calendar)this.process(() -> this.getCalendarWebManager().saveCalendar(calendar)).execute();
        if (synchronizedRequired) {
            this.synchronizeCalendar(updatedCalendar);
        }
        return this.asWebEntity(updatedCalendar);
    }

    @DELETE
    @Path(value="{calendarId}")
    @Produces(value={"application/json"})
    public void deleteCalendar(@PathParam(value="calendarId") String calendarId) {
        Calendar calendar = Calendar.getById((String)calendarId);
        CalendarWebManager.assertDataConsistency(this.getComponentId(), calendar);
        this.process(() -> {
            this.getCalendarWebManager().deleteCalendar(calendar);
            return null;
        }).execute();
    }

    @GET
    @Path(value="{calendarId}/export/ical")
    @Produces(value={"text/calendar"})
    public Response exportCalendarAsICalendarFormat(@PathParam(value="calendarId") String calendarId) {
        Calendar calendar = (Calendar)this.process(() -> Calendar.getById((String)calendarId)).execute();
        CalendarWebManager.assertDataConsistency(this.getComponentId(), calendar);
        return Response.ok(output -> {
            try {
                ExportDescriptor descriptor = (ExportDescriptor)ExportDescriptor.withOutputStream((OutputStream)output).withParameter("calendar", (Serializable)calendar);
                this.getCalendarWebManager().exportCalendarAsICalendarFormat(calendar, descriptor);
            }
            catch (ExportException e) {
                SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
        }).header("Content-Disposition", (Object)String.format("inline;filename=\"%s\"", calendar.getTitle() + ".ics")).build();
    }

    @POST
    @Path(value="{calendarId}/import/ical")
    @Produces(value={"application/json"})
    public Response importEventsAsICalendarFormat(@PathParam(value="calendarId") String calendarId) {
        Calendar calendar = (Calendar)this.process(() -> Calendar.getById((String)calendarId)).execute();
        CalendarWebManager.assertDataConsistency(this.getComponentId(), calendar);
        try {
            FileUploadManager.getUploadedFiles((HttpServletRequest)this.getHttpRequest(), (User)this.getUser()).forEach(uploadedFile -> this.performImportEventAsICalendarFormat(calendar, (UploadedFile)uploadedFile));
        }
        catch (WebApplicationException e) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            Response.ResponseBuilder response = Response.fromResponse((Response)e.getResponse());
            if (e.getCause() != null && StringUtil.isDefined((String)e.getCause().getMessage())) {
                response.entity((Object)e.getCause().getMessage());
            } else {
                response.entity((Object)e.getMessage());
            }
            return response.build();
        }
        return Response.ok().build();
    }

    private void performImportEventAsICalendarFormat(Calendar calendar, UploadedFile uploadedFile) {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(uploadedFile.getFile()));){
            this.getCalendarWebManager().importEventsAsICalendarFormat(calendar, bis);
        }
        catch (IOException | ImportException e) {
            throw new WebApplicationException(e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            uploadedFile.getUploadSession().clear();
        }
    }

    @PUT
    @Path(value="{calendarId}/synchronization")
    @Produces(value={"application/json"})
    public Response synchronizeCalendar(@PathParam(value="calendarId") String calendarId) {
        Calendar calendar = (Calendar)this.process(() -> Calendar.getById((String)calendarId)).execute();
        CalendarWebManager.assertDataConsistency(this.getComponentId(), calendar);
        if (!this.synchronizeCalendar(calendar)) {
            return Response.serverError().entity((Object)this.asWebEntity(calendar)).build();
        }
        return Response.ok((Object)this.asWebEntity(calendar)).build();
    }

    @GET
    @Path(value="events/occurrences/next")
    @Produces(value={"application/json"})
    public List<CalendarEventOccurrenceEntity> getNextEventOccurrences(@QueryParam(value="limit") Integer limit) {
        return (List)this.process(() -> {
            CalendarEventOccurrenceRequestParameters params = (CalendarEventOccurrenceRequestParameters)RequestParameterDecoder.decode((HttpRequest)this.getHttpRequest(), CalendarEventOccurrenceRequestParameters.class);
            Stream<CalendarEventOccurrence> occurrences = this.getCalendarWebManager().getNextEventOccurrences(Collections.singletonList(this.getComponentId()), params.getCalendarIdsToExclude(), params.getUsers(), params.getCalendarIdsToInclude(), this.getZoneId(), limit);
            return occurrences.map(this::asOccurrenceWebEntity).collect(Collectors.toList());
        }).execute();
    }

    @GET
    @Path(value="events/occurrences")
    @Produces(value={"application/json"})
    public List<ParticipantCalendarEventOccurrencesEntity> getAllEventOccurrencesFrom() {
        CalendarEventOccurrenceRequestParameters params = (CalendarEventOccurrenceRequestParameters)RequestParameterDecoder.decode((HttpRequest)this.getHttpRequest(), CalendarEventOccurrenceRequestParameters.class);
        LocalDate startDate = params.getStartDateOfWindowTime().toLocalDate();
        LocalDate endDate = params.getEndDateOfWindowTime().toLocalDate();
        Set<User> users = params.getUsers();
        return (List)this.process(() -> this.asParticipantOccurrencesEntities(users, this.getCalendarWebManager().getAllEventOccurrencesByUserIds((Pair<List<String>, User>)Pair.of(Collections.singletonList(this.getComponentId()), (Object)this.getUser()), startDate, endDate, users))).execute();
    }

    @GET
    @Path(value="{calendarId}/events/occurrences")
    @Produces(value={"application/json"})
    public List<CalendarEventOccurrenceEntity> getEventOccurrencesOf(@PathParam(value="calendarId") String calendarId) {
        Calendar calendar = Calendar.getById((String)calendarId);
        CalendarWebManager.assertDataConsistency(this.getComponentId(), calendar);
        CalendarEventOccurrenceRequestParameters params = (CalendarEventOccurrenceRequestParameters)RequestParameterDecoder.decode((HttpRequest)this.getHttpRequest(), CalendarEventOccurrenceRequestParameters.class);
        LocalDate startDate = params.getStartDateOfWindowTime().toLocalDate();
        LocalDate endDate = params.getEndDateOfWindowTime().toLocalDate();
        return (List)this.process(() -> this.asOccurrenceWebEntities(this.getCalendarWebManager().getEventOccurrencesOf(startDate, endDate, Collections.singletonList(calendar)))).execute();
    }

    @GET
    @Path(value="{calendarId}/events/{eventId}/occurrences")
    @Produces(value={"application/json"})
    public List<CalendarEventOccurrenceEntity> getEventOccurrencesOf(@PathParam(value="calendarId") String calendarId, @PathParam(value="eventId") String eventId) {
        Calendar calendar = Calendar.getById((String)calendarId);
        CalendarEvent event = CalendarEvent.getById((String)eventId);
        CalendarWebManager.assertDataConsistency(calendar.getComponentInstanceId(), calendar, event);
        CalendarEventOccurrenceRequestParameters params = (CalendarEventOccurrenceRequestParameters)RequestParameterDecoder.decode((HttpRequest)this.getHttpRequest(), CalendarEventOccurrenceRequestParameters.class);
        LocalDate occStartDate = params.getStartDateOfWindowTime().toLocalDate();
        LocalDate occEndDate = params.getEndDateOfWindowTime().toLocalDate();
        return (List)this.process(() -> {
            List<CalendarEventOccurrence> occurrences = this.getCalendarWebManager().getEventOccurrencesOf(occStartDate, occEndDate, Collections.singletonList(calendar));
            occurrences.removeIf(occurrence -> !occurrence.getCalendarEvent().getId().equals(eventId));
            return this.asOccurrenceWebEntities(occurrences);
        }).execute();
    }

    @GET
    @Path(value="{calendarId}/events/{eventId}")
    @Produces(value={"application/json"})
    public CalendarEventEntity getEvent(@PathParam(value="calendarId") String calendarId, @PathParam(value="eventId") String eventId) {
        Calendar calendar = Calendar.getById((String)calendarId);
        CalendarEvent event = (CalendarEvent)this.process(() -> CalendarEvent.getById((String)eventId)).execute();
        CalendarWebManager.assertDataConsistency(calendar.getComponentInstanceId(), calendar, event);
        return this.asEventWebEntity(event);
    }

    @POST
    @Path(value="{calendarId}/events")
    @Produces(value={"application/json"})
    public CalendarEventEntity createEvent(@PathParam(value="calendarId") String calendarId, CalendarEventEntity eventEntity) {
        Calendar calendar = Calendar.getById((String)calendarId);
        CalendarWebManager.assertDataConsistency(this.getComponentId(), calendar);
        String volatileEventId = eventEntity.getEventId();
        CalendarEvent createdEvent = (CalendarEvent)this.process(() -> {
            ReminderEntity reminderEntity;
            CalendarEvent event = this.getCalendarWebManager().createEvent(calendar, eventEntity.getMergedEvent(), volatileEventId);
            Attachments.from(eventEntity.getAttachmentParameters()).attachTo(LocalizedContribution.from((Contribution)event));
            if (!eventEntity.getPdcClassification().isUndefined()) {
                List<PdcPosition> pdcPositions = eventEntity.getPdcClassification().getPdcPositions();
                PdcClassification.aPdcClassificationOfContent((Contribution)event).withPositions(pdcPositions).classifyContent((Contribution)event);
            }
            if ((reminderEntity = eventEntity.getReminder()) != null) {
                DurationReminder reminder = new DurationReminder(event.getIdentifier(), this.getUser(), CalendarEventUserNotificationReminder.CALENDAR_EVENT_USER_NOTIFICATION);
                try {
                    reminderEntity.mergeInto((Reminder)reminder).schedule();
                }
                catch (Exception e) {
                    this.getMessager().addInfo(this.getBundle().getString("calendar.message.event.reminder.add.error"), event.getTitle());
                }
            }
            return event;
        }).execute();
        return this.asEventWebEntity(createdEvent);
    }

    @GET
    @Path(value="{calendarId}/events/{eventId}/occurrences/{occurrenceId}")
    @Produces(value={"application/json"})
    public CalendarEventOccurrenceEntity getEventOccurrence(@PathParam(value="calendarId") String calendarId, @PathParam(value="eventId") String eventId, @PathParam(value="occurrenceId") String occurrenceId) {
        Calendar calendar = Calendar.getById((String)calendarId);
        CalendarEvent event = CalendarEvent.getById((String)eventId);
        CalendarEventOccurrence occurrence = (CalendarEventOccurrence)CalendarEventOccurrence.getById((String)CalendarEventOccurrenceEntity.decodeId(occurrenceId)).orElseThrow(() -> new WebApplicationException("No such occurrence " + occurrenceId, Response.Status.NOT_FOUND));
        CalendarWebManager.assertDataConsistency(calendar.getComponentInstanceId(), calendar, event, occurrence);
        return this.asOccurrenceWebEntity(occurrence);
    }

    @PUT
    @Path(value="{calendarId}/events/{eventId}/occurrences/{occurrenceId}")
    @Produces(value={"application/json"})
    public List<CalendarEventEntity> updateEventOccurrence(@PathParam(value="calendarId") String calendarId, @PathParam(value="eventId") String eventId, @PathParam(value="occurrenceId") String occurrenceId, CalendarEventOccurrenceUpdateEntity occurrenceEntity) {
        CalendarEventOccurrence occToUpdate = occurrenceEntity.getMergedOccurrence();
        this.checkEventOccurrence(calendarId, eventId, occurrenceId, occToUpdate);
        List updatedEvents = (List)this.process(() -> this.getCalendarWebManager().saveOccurrence(occToUpdate, occurrenceEntity.getUpdateMethodType(), this.getZoneId())).execute();
        if (updatedEvents.size() > 1) {
            CalendarEvent original = (CalendarEvent)updatedEvents.get(0);
            CalendarEvent created = (CalendarEvent)updatedEvents.get(1);
            Mutable reminderError = Mutable.of((Object)false);
            Reminder.getByContribution((ContributionIdentifier)original.getIdentifier()).stream().filter(r -> CalendarEventUserNotificationReminder.CALENDAR_EVENT_USER_NOTIFICATION.asString().equals(r.getProcessName())).map(DurationReminder.class::cast).map(r -> new DurationReminder(created.getIdentifier(), User.getById((String)r.getUserId()), CalendarEventUserNotificationReminder.CALENDAR_EVENT_USER_NOTIFICATION).withText(r.getText()).triggerBefore(r.getDuration(), r.getTimeUnit(), r.getContributionProperty())).forEach(r -> {
                try {
                    r.schedule();
                }
                catch (Exception e) {
                    reminderError.set((Object)true);
                }
            });
            reminderError.ifPresent(e -> this.getMessager().addInfo(this.getBundle().getString("calendar.message.event.reminder.update.error"), occToUpdate.getCalendarEvent().getTitle()));
        }
        return this.asEventWebEntities(updatedEvents);
    }

    private void checkEventOccurrence(String calendarId, String eventId, String occurrenceId, CalendarEventOccurrence occurrence) {
        Calendar originalCalendar = Calendar.getById((String)calendarId);
        CalendarEvent previousEventData = CalendarEvent.getById((String)eventId);
        CalendarWebManager.assertDataConsistency(this.getComponentId(), originalCalendar, previousEventData, occurrence);
        if (!occurrence.getId().equals(CalendarEventOccurrenceEntity.decodeId(occurrenceId))) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @DELETE
    @Path(value="{calendarId}/events/{eventId}/occurrences/{occurrenceId}")
    @Produces(value={"application/json"})
    public CalendarEventEntity deleteEventOccurrence(@PathParam(value="calendarId") String calendarId, @PathParam(value="eventId") String eventId, @PathParam(value="occurrenceId") String occurrenceId, CalendarEventOccurrenceDeleteEntity occurrenceEntity) {
        CalendarEventOccurrence occToDelete = occurrenceEntity.getMergedOccurrence();
        this.checkEventOccurrence(calendarId, eventId, occurrenceId, occToDelete);
        CalendarEvent updatedEvent = (CalendarEvent)this.process(() -> this.getCalendarWebManager().deleteOccurrence(occToDelete, occurrenceEntity.getDeleteMethodType(), this.getZoneId())).execute();
        return updatedEvent != null ? this.asEventWebEntity(updatedEvent) : null;
    }

    @PUT
    @Path(value="{calendarId}/events/{eventId}/occurrences/{occurrenceId}/attendees/{attendeeId}")
    @Produces(value={"application/json"})
    public CalendarEventEntity updateEventAttendeeParticipation(@PathParam(value="calendarId") String calendarId, @PathParam(value="eventId") String eventId, @PathParam(value="occurrenceId") String occurrenceId, @PathParam(value="attendeeId") String attendeeId, CalendarEventAttendeeAnswerEntity answerEntity) {
        if (StringUtil.isLong((String)attendeeId) && !this.getUser().getId().equals(attendeeId)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        Calendar originalCalendar = Calendar.getById((String)calendarId);
        CalendarEvent event = CalendarEvent.getById((String)eventId);
        CalendarEventOccurrence occurrence = CalendarEventOccurrence.getById((String)CalendarEventOccurrenceEntity.decodeId(occurrenceId)).orElse(null);
        CalendarWebManager.assertDataConsistency(originalCalendar.getComponentInstanceId(), originalCalendar, event, occurrence);
        answerEntity.setId(attendeeId);
        CalendarEvent updatedEvent = (CalendarEvent)this.process(() -> this.getCalendarWebManager().updateOccurrenceAttendeeParticipation(occurrence, answerEntity.getId(), answerEntity.getParticipationStatus(), answerEntity.getAnswerMethodType(), this.getZoneId())).lowestAccessRole(null).execute();
        return updatedEvent != null ? this.asEventWebEntity(updatedEvent) : null;
    }

    private boolean synchronizeCalendar(@NonNull Calendar calendar) {
        try {
            this.getCalendarWebManager().synchronizeCalendar(calendar);
            return true;
        }
        catch (ImportException e) {
            if (e.getCause() != null) {
                SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            } else {
                SilverLogger.getLogger((Object)((Object)this)).error(e.getMessage(), new Object[0]);
            }
            this.getMessager().addError(this.getBundle().getString("calendar.message.calendar.synchronize.error"), calendar.getTitle());
            return false;
        }
    }

    public List<CalendarEntity> asWebEntities(Collection<Calendar> calendars) {
        return calendars.stream().map(this::asWebEntity).collect(Collectors.toList());
    }

    public CalendarEntity asWebEntity(Calendar calendar) {
        CalendarWebManager.assertEntityIsDefined((IdentifiableEntity)calendar);
        CalendarEntity calendarEntity = CalendarEntity.fromCalendar(calendar).withURI(this.uri().ofCalendar(calendar));
        SilverpeasRole highestCalendarRole = ((SilverpeasComponentInstance)SilverpeasComponentInstance.getById((String)calendar.getComponentInstanceId()).orElseThrow(() -> new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR))).getHighestSilverpeasRolesFor(this.getUser());
        if (calendarEntity.isUserPersonal() || highestCalendarRole != null && highestCalendarRole.isGreaterThanOrEquals(SilverpeasRole.ADMIN)) {
            calendarEntity.withICalPublicURI(this.uri().ofICalPublic(calendar)).withICalPrivateURI(this.uri().ofICalPrivate(calendar));
        } else if (highestCalendarRole != null && highestCalendarRole.isGreaterThanOrEquals(SilverpeasRole.USER)) {
            calendarEntity.withICalPublicURI(this.uri().ofICalPublic(calendar));
        } else {
            calendarEntity.setExternalUrl(null);
        }
        return calendarEntity;
    }

    public List<CalendarEventEntity> asEventWebEntities(Collection<CalendarEvent> events) {
        return events.stream().map(this::asEventWebEntity).collect(Collectors.toList());
    }

    public CalendarEventEntity asEventWebEntity(CalendarEvent event) {
        CalendarWebManager.assertEntityIsDefined((IdentifiableEntity)event.asCalendarComponent());
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        CalendarEventEntity entity = (CalendarEventEntity)cache.get((Object)event.getId(), CalendarEventEntity.class);
        if (entity == null) {
            entity = CalendarEventEntity.fromEvent(event, this.getComponentId(), this.getZoneId(), this.isEditionMode()).withEventURI(this.uri().ofEvent(event)).withCalendarURI(this.uri().ofCalendar(event.getCalendar()));
            cache.put((Object)event.getId(), (Object)entity);
        }
        return entity;
    }

    public List<CalendarEventOccurrenceEntity> asOccurrenceWebEntities(Collection<CalendarEventOccurrence> occurrences) {
        return occurrences.stream().map(this::asOccurrenceWebEntity).collect(Collectors.toList());
    }

    public CalendarEventOccurrenceEntity asOccurrenceWebEntity(CalendarEventOccurrence occurrence) {
        CalendarWebManager.assertEntityIsDefined((IdentifiableEntity)occurrence.getCalendarEvent().asCalendarComponent());
        List attendeeEntities = occurrence.getAttendees().stream().map(attendee -> this.asAttendeeWebEntity(occurrence, (Attendee)attendee)).collect(Collectors.toList());
        List attributeEntities = occurrence.getAttributes().stream().map(this::asAttributeWebEntity).collect(Collectors.toList());
        return ((CalendarEventOccurrenceEntity)CalendarEventOccurrenceEntity.fromOccurrence(occurrence, this.getComponentId(), this.getZoneId(), this.isEditionMode()).withCalendarURI(this.uri().ofCalendar(occurrence.getCalendarEvent().getCalendar())).withEventURI(this.uri().ofEvent(occurrence.getCalendarEvent())).withOccurrenceURI(this.uri().ofOccurrence(occurrence)).withEventPermalinkURL(this.uri().ofEventPermalink(occurrence)).withOccurrencePermalinkURL(this.uri().ofOccurrencePermalink(occurrence)).withOccurrenceViewURL(this.uri().ofOccurrenceView(occurrence)).withOccurrenceEditionURL(this.uri().ofOccurrenceEdition(occurrence)).withAttendees(attendeeEntities)).withAttributes(attributeEntities);
    }

    private List<ParticipantCalendarEventOccurrencesEntity> asParticipantOccurrencesEntities(Set<User> users, Map<String, List<CalendarEventOccurrence>> occurrences) {
        ArrayList<ParticipantCalendarEventOccurrencesEntity> webEntities = new ArrayList<ParticipantCalendarEventOccurrencesEntity>();
        users.forEach(user -> webEntities.add((ParticipantCalendarEventOccurrencesEntity)ParticipantCalendarEventOccurrencesEntity.from(user).withOccurrences(this.asOccurrenceWebEntities(Optional.ofNullable((List)occurrences.get(user.getId())).orElse(Collections.emptyList())))));
        return webEntities;
    }

    public CalendarEventAttendeeEntity asAttendeeWebEntity(CalendarEventOccurrence occurrence, Attendee attendee) {
        CalendarWebManager.assertEntityIsDefined((IdentifiableEntity)attendee);
        return CalendarEventAttendeeEntity.from(attendee).withURI(this.uri().ofOccurrenceAttendee(occurrence, attendee));
    }

    public CalendarEventAttributeEntity asAttributeWebEntity(Map.Entry<String, String> nameAndValue) {
        return CalendarEventAttributeEntity.from(nameAndValue);
    }

    protected String getBundleLocation() {
        return "org.silverpeas.calendar.multilang.calendarBundle";
    }

    private CalendarWebManager getCalendarWebManager() {
        return CalendarWebManager.get(this.getComponentId());
    }

    private WebMessager getMessager() {
        return WebMessager.getInstance();
    }
}

