/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.search;

import java.time.temporal.Temporal;
import org.silverpeas.core.date.TemporalFormatter;
import org.silverpeas.core.pdc.pdc.model.GlobalSilverResult;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.personalization.service.PersonalizationServiceProvider;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.MultiSilverpeasBundle;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.web.search.ResultDisplayer;
import org.silverpeas.core.web.search.ResultSearchRendererUtil;
import org.silverpeas.core.web.search.SearchResultContentVO;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractResultDisplayer
implements ResultDisplayer {
    protected void setCommonAttributes(SearchResultContentVO searchResult, SilverpeasTemplate componentTemplate) {
        String serverName;
        String sCreationDate;
        String sCreatorName;
        String location;
        GlobalSilverResult silverResult = searchResult.getGsr();
        MultiSilverpeasBundle settings = searchResult.getSettings();
        componentTemplate.setAttribute("gsr", (Object)silverResult);
        componentTemplate.setAttribute("name", (Object)WebEncodeHelper.javaStringToHtmlString((String)silverResult.getName()));
        Object sDescription = silverResult.getDescription();
        if (sDescription != null && ((String)sDescription).length() > 400) {
            sDescription = ((String)sDescription).substring(0, 400) + "...";
        }
        if (StringUtil.isDefined((String)sDescription)) {
            componentTemplate.setAttribute("description", (Object)WebEncodeHelper.javaStringToHtmlParagraphe((String)sDescription));
        }
        componentTemplate.setAttribute("url", (Object)silverResult.getTitleLink());
        String sDownload = silverResult.getDownloadLink();
        if (StringUtil.isDefined((String)sDownload)) {
            componentTemplate.setAttribute("downloadUrl", (Object)sDownload);
        }
        if (StringUtil.isDefined((String)(location = silverResult.getLocation()))) {
            componentTemplate.setAttribute("location", (Object)WebEncodeHelper.javaStringToHtmlString((String)location));
        }
        if (StringUtil.isDefined((String)(sCreatorName = silverResult.getCreatorName()))) {
            componentTemplate.setAttribute("creatorName", (Object)WebEncodeHelper.javaStringToHtmlString((String)sCreatorName));
        }
        componentTemplate.setAttribute("instanceId", (Object)silverResult.getInstanceId());
        try {
            sCreationDate = searchResult.getSortValue() == 4 ? TemporalFormatter.toLocalized((Temporal)silverResult.getCreationDate(), (String)this.getUserPreferences(searchResult.getUserId()).getLanguage()) : TemporalFormatter.toLocalized((Temporal)silverResult.getLastUpdateDate(), (String)this.getUserPreferences(searchResult.getUserId()).getLanguage());
        }
        catch (Exception e) {
            sCreationDate = null;
        }
        if (StringUtil.isDefined(sCreationDate)) {
            componentTemplate.setAttribute("creationDate", sCreationDate);
        }
        if (StringUtil.isDefined((String)(serverName = silverResult.getServerName()))) {
            componentTemplate.setAttribute("serverName", (Object)serverName);
        }
        componentTemplate.setAttribute("pertinenceVisible", (Object)settings.getSetting("PertinenceVisible", false));
        if (settings.getSetting("PertinenceVisible", false)) {
            componentTemplate.setAttribute("pertinence", (Object)ResultSearchRendererUtil.displayPertinence(silverResult.getScore()));
        }
        componentTemplate.setAttribute("exportEnabled", (Object)searchResult.getExportEnabled());
        componentTemplate.setAttribute("type", (Object)silverResult.getType());
    }

    protected UserPreferences getUserPreferences(String userId) {
        return PersonalizationServiceProvider.getPersonalizationService().getUserSettings(userId);
    }
}

