/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.util.HttpUtil;
import org.silverpeas.core.web.mvc.webcomponent.SilverpeasAuthenticatedHttpServlet;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class ProxyServlet
extends SilverpeasAuthenticatedHttpServlet {
    private static final long serialVersionUID = 5047753714615164680L;
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.proxy.settings.proxy");

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        if (!this.isEnabled()) {
            this.throwHttpForbiddenError();
        }
        String targetUrl = this.getTargetUrl(req);
        String userIdentity = Optional.ofNullable(User.getCurrentRequester()).map(user -> "User " + user.getId()).orElse("Someone");
        Supplier<String> errorDebugSupplier = () -> MessageFormat.format("{0} tried to use proxy with URL ''{1}''", userIdentity, targetUrl);
        if (this.isAuthorizedTargetUrl(targetUrl)) {
            try {
                long copied;
                HttpResponse<InputStream> response = this.client().send(HttpUtil.toUrl((String)targetUrl).header("Accept", "*/*").build(), HttpResponse.BodyHandlers.ofInputStream());
                res.setStatus(response.statusCode());
                response.headers().map().entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase("content-type")).forEach(e -> ((List)e.getValue()).forEach(v -> res.setHeader((String)e.getKey(), v)));
                try (InputStream body2 = response.body();){
                    copied = IOUtils.copyLarge((InputStream)body2, (OutputStream)res.getOutputStream());
                }
                SilverLogger.getLogger((Object)((Object)this)).debug("{0} using proxy with URL ''{1}'' and got {2} bytes (status={3})", new Object[]{userIdentity, targetUrl, String.valueOf(copied), String.valueOf(response.statusCode())});
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                SilverLogger.getLogger((Object)((Object)this)).debug(errorDebugSupplier);
                this.throwHttpNotFoundError();
            }
            catch (IOException | GeneralSecurityException e3) {
                SilverLogger.getLogger((Object)((Object)this)).debug(errorDebugSupplier);
                this.throwHttpNotFoundError();
            }
        } else {
            SilverLogger.getLogger((Object)((Object)this)).warn(errorDebugSupplier.get(), new Object[0]);
            this.throwHttpForbiddenError();
        }
    }

    private HttpClient client() throws GeneralSecurityException {
        return settings.getBoolean("ssl.handshake", true) ? HttpUtil.httpClient() : HttpUtil.httpClientTrustingAnySslContext();
    }

    private String getTargetUrl(HttpServletRequest req) {
        return Optional.ofNullable(req.getPathInfo()).map(p -> p.substring(1)).map(p -> UriBuilder.fromUri((String)(req.getScheme() + "://" + p))).map(b -> {
            req.getParameterMap().forEach((arg_0, arg_1) -> ((UriBuilder)b).queryParam(arg_0, arg_1));
            return b.build(new Object[0]).toString();
        }).orElse("");
    }

    private boolean isAuthorizedTargetUrl(String targetUrl) {
        return Optional.ofNullable(targetUrl).filter(StringUtil::isDefined).stream().flatMap(u -> Stream.of(settings.getString("rules", "").split(" ")).filter(StringUtil::isDefined).map(Pattern::compile).map(p -> p.matcher((CharSequence)u)).map(Matcher::matches)).filter(Boolean::booleanValue).findFirst().orElse(false);
    }

    private boolean isEnabled() {
        return settings.getBoolean("enabled", false);
    }
}

