/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.portlets.portal.portletwindow;

import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.ChannelState;
import com.sun.portal.container.ChannelURLFactory;
import com.sun.portal.container.Container;
import com.sun.portal.container.ContainerFactory;
import com.sun.portal.container.ContainerType;
import com.sun.portal.container.ContentException;
import com.sun.portal.container.EntityID;
import com.sun.portal.container.ErrorCode;
import com.sun.portal.container.PortletWindowContextException;
import com.sun.portal.container.WindowRequestReader;
import com.sun.portal.portletcontainer.invoker.InvokerException;
import com.sun.portal.portletcontainer.invoker.WindowErrorCode;
import com.sun.portal.portletcontainer.invoker.WindowInvoker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.portlets.portal.portletwindow.PortletWindowInvokerUtils;
import org.silverpeas.core.web.portlets.portal.portletwindow.PortletWindowRequestReader;
import org.silverpeas.core.web.portlets.portal.portletwindow.PortletWindowURLFactory;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.StringUtil;

public class PortletWindowInvoker
extends WindowInvoker {
    public static final String JAVAX_PORTLET_TITLE = "javax.portlet.title";
    private WindowRequestReader windowRequestReader = null;
    private static final Logger logger = Logger.getLogger("org.silverpeas.core.web.portlets.portal.portletwindow", "org.silverpeas.portlets.PCDLogMessages");

    @Override
    public void init(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws InvokerException {
        super.init(servletContext, request, response);
        this.windowRequestReader = new PortletWindowRequestReader();
    }

    @Override
    public Map getUserInfoMap(HttpServletRequest request) throws InvokerException {
        return PortletWindowInvokerUtils.getUserInfoMap(this.getPortletWindowContext(), this.getPortletWindowName());
    }

    @Override
    public Container getContainer() {
        return ContainerFactory.getContainer((ContainerType)ContainerType.PORTLET_CONTAINER);
    }

    @Override
    public EntityID getEntityID(HttpServletRequest request) throws InvokerException {
        return PortletWindowInvokerUtils.getEntityID(this.getPortletWindowContext(), this.getPortletWindowName());
    }

    @Override
    public ChannelURLFactory getPortletWindowURLFactory(String desktopURLPrefix, HttpServletRequest request) throws InvokerException {
        return new PortletWindowURLFactory(desktopURLPrefix);
    }

    @Override
    public WindowRequestReader getWindowRequestReader() throws InvokerException {
        return this.windowRequestReader;
    }

    @Override
    public boolean isMarkupSupported(String contentType, String locale, ChannelMode mode, ChannelState state) throws InvokerException {
        boolean supported = false;
        try {
            List supportedContentTypes = this.getPortletWindowContext().getMarkupTypes(this.getPortletWindowName());
            if (ChannelMode.VIEW.equals((Object)mode)) {
                if (supportedContentTypes.contains(contentType) || supportedContentTypes.contains("text/*") || supportedContentTypes.contains("*/*")) {
                    supported = true;
                }
            } else if (ChannelMode.HELP.equals((Object)mode)) {
                if (supportedContentTypes.contains(contentType)) {
                    supported = true;
                }
            } else if (ChannelMode.EDIT.equals((Object)mode) && supportedContentTypes.contains(contentType)) {
                supported = true;
            }
        }
        catch (PortletWindowContextException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return supported;
    }

    @Override
    public String getDefaultTitle() throws InvokerException {
        String title2 = PortletWindowInvokerUtils.getPortletWindowTitle(this.getPortletWindowContext(), this.getPortletWindowName());
        if (title2 == null) {
            logger.log(Level.INFO, "PSPCD_CSPPD0019", this.getPortletWindowName());
            title2 = PortletWindowInvokerUtils.getPortletTitle(this.getPortletWindowName(), this.getPortletWindowContext());
        }
        return title2;
    }

    @Override
    public String getTitle() throws InvokerException {
        if (!StringUtil.isDefined((String)super.getTitle()) || super.getTitle().equals(this.getDefaultTitle())) {
            String translation;
            MainSessionController sessionController = (MainSessionController)this.getOriginalRequest().getSession().getAttribute("SilverSessionController");
            String locale = sessionController != null ? sessionController.getFavoriteLanguage() : DisplayI18NHelper.getDefaultLanguage();
            LocalizationBundle messages = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.portlet.multilang.portletBundle", (String)locale);
            String portletTitle = this.getDefaultTitle();
            try {
                translation = messages.getString(portletTitle);
            }
            catch (MissingResourceException ex) {
                translation = portletTitle;
            }
            this.setTitle(translation);
        }
        return super.getTitle();
    }

    @Override
    public List getRoleList(HttpServletRequest request) throws InvokerException {
        ArrayList<String> rolesList = null;
        try {
            Map roleMap = this.getConfiguredRoleMap();
            if (roleMap != null) {
                List roles = this.getPortletWindowContext().getRoles();
                if (roles.isEmpty()) {
                    rolesList = Collections.EMPTY_LIST;
                } else {
                    Map lowerCaseRoleMap = this.convertMapToLowerCase(roleMap);
                    List lowerCaseWebContainerRoles = this.convertListToLowerCase(roles);
                    rolesList = new ArrayList<String>();
                    for (String webcontainerRole : lowerCaseWebContainerRoles) {
                        if (!lowerCaseRoleMap.containsKey(webcontainerRole)) continue;
                        String logicalRole = (String)lowerCaseRoleMap.get(webcontainerRole);
                        rolesList.add(logicalRole);
                    }
                }
            } else {
                rolesList = Collections.EMPTY_LIST;
            }
        }
        catch (InvokerException pce) {
            throw new InvokerException("PortletWindowInvoker.getRoleList(): couldn't check for exists on roleMap collection", pce);
        }
        return rolesList;
    }

    private List convertListToLowerCase(List list) {
        ArrayList<String> lowerCaseKeys = new ArrayList<String>();
        for (String role : list) {
            lowerCaseKeys.add(role.toLowerCase());
        }
        return lowerCaseKeys;
    }

    private Map convertMapToLowerCase(Map map) {
        HashMap lowerCaseMap = new HashMap();
        for (Map.Entry mapEntry : map.entrySet()) {
            String key = (String)mapEntry.getKey();
            lowerCaseMap.put(key.toLowerCase(), mapEntry.getValue());
        }
        return lowerCaseMap;
    }

    private Map getConfiguredRoleMap() throws InvokerException {
        return PortletWindowInvokerUtils.getRoleMap(this.getPortletWindowContext(), this.getPortletWindowName());
    }

    @Override
    protected ErrorCode getErrorCode(ContentException ex) {
        return WindowErrorCode.CONTENT_EXCEPTION;
    }
}

