/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.security.authentication.verifier.AuthenticationUserVerifierFactory;
import org.silverpeas.core.security.authentication.verifier.UserCanLoginVerifier;
import org.silverpeas.core.web.authentication.credentials.CredentialsFunctionHandler;
import org.silverpeas.core.web.authentication.credentials.HttpFunctionHandler;
import org.silverpeas.core.web.authentication.credentials.HttpFunctionHandlerRegistering;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.Defined;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class CredentialsServlet
extends HttpServlet
implements HttpFunctionHandlerRegistering {
    private static final long serialVersionUID = -7586840606648226466L;
    private final Map<String, HttpFunctionHandler> handlers = new HashMap<String, HttpFunctionHandler>(20);
    private final List<String> preProcessingByPassers = new ArrayList<String>();
    @Inject
    private Instance<CredentialsFunctionHandler> handlerInstances;

    @PostConstruct
    void loadHandlers() {
        this.handlerInstances.forEach(h -> h.registerWith(this));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            CredentialsProcessContext context = new CredentialsProcessContext(request);
            HttpFunctionHandler handler = this.handlers.get(context.getFunction());
            if (handler != null) {
                this.preHandlerProcessing(request, context);
                if (!context.isProcessed()) {
                    String nextPage = handler.doAction(request);
                    context.setDestination(nextPage);
                }
                this.postHandlerProcessing(request, response, context);
            } else {
                response.sendError(404, "command not found : " + context.getFunction());
            }
        }
        catch (IOException | ServletException e) {
            SilverLogger.getLogger((Object)this).error(e);
            response.setStatus(500);
        }
    }

    private void preHandlerProcessing(HttpServletRequest request, CredentialsProcessContext context) {
        String login = request.getParameter("Login");
        String domainId = request.getParameter("DomainId");
        AuthenticationUserVerifierFactory.getUserCanTryAgainToLoginVerifier((User)null).clearSession(request);
        if (StringUtil.isDefined((String)login) && StringUtil.isDefined((String)domainId) && !this.preProcessingByPassers.contains(context.getFunction())) {
            UserCanLoginVerifier userStateVerifier = AuthenticationUserVerifierFactory.getUserCanLoginVerifier((AuthenticationCredential)this.getAuthenticationCredential(login, domainId));
            context.setUser(userStateVerifier.getUser());
            context.setDestination(this.checkUserState(userStateVerifier));
        }
    }

    private void postHandlerProcessing(HttpServletRequest request, HttpServletResponse response, CredentialsProcessContext context) throws IOException, ServletException {
        String destinationPage = context.getDestination();
        if (destinationPage.startsWith("http")) {
            AuthenticationUserVerifierFactory.getUserCanTryAgainToLoginVerifier((User)context.getUser()).clearCache();
            response.sendRedirect(response.encodeRedirectURL(destinationPage));
        } else {
            RequestDispatcher dispatcher = request.getRequestDispatcher(destinationPage);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private String checkUserState(UserCanLoginVerifier userStateVerifier) {
        try {
            userStateVerifier.verify();
        }
        catch (AuthenticationException e) {
            SilverLogger.getLogger((Object)this).debug(e.getMessage(), new Object[]{e});
            return userStateVerifier.getErrorDestination();
        }
        return "";
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private AuthenticationCredential getAuthenticationCredential(@Defined String login, @Defined String domain) {
        try {
            return AuthenticationCredential.newWithAsLogin((String)login).withAsDomainId(domain);
        }
        catch (AuthenticationException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    @Override
    public void register(HttpFunctionHandler handler, boolean bypassPreHandleProcessing) {
        this.handlers.put(handler.getFunction(), handler);
        if (bypassPreHandleProcessing) {
            this.preProcessingByPassers.add(handler.getFunction());
        }
    }

    private static class CredentialsProcessContext {
        private String destination;
        private User user;
        private final String function;

        private CredentialsProcessContext(HttpServletRequest request) {
            this.function = CredentialsProcessContext.getFunction(request);
        }

        public String getFunction() {
            return this.function;
        }

        public boolean isProcessed() {
            return StringUtil.isDefined((String)this.destination);
        }

        public String getDestination() {
            return this.destination;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        public User getUser() {
            return this.user;
        }

        public void setUser(User user) {
            this.user = user;
        }

        private static String getFunction(HttpServletRequest request) {
            String function = "Error";
            String pathInfo = request.getPathInfo();
            if (pathInfo != null) {
                pathInfo = pathInfo.substring(1);
                function = pathInfo.substring(pathInfo.indexOf(47) + 1);
            }
            return function;
        }
    }
}

