/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.service;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.socialnetwork.connectors.SocialNetworkConnector;
import org.silverpeas.core.socialnetwork.dao.ExternalAccountRepository;
import org.silverpeas.core.socialnetwork.model.ExternalAccount;
import org.silverpeas.core.socialnetwork.model.ExternalAccountIdentifier;
import org.silverpeas.core.socialnetwork.model.SocialNetworkID;
import org.silverpeas.core.socialnetwork.qualifiers.Facebook;
import org.silverpeas.core.socialnetwork.qualifiers.LinkedIn;
import org.silverpeas.core.socialnetwork.service.AccessToken;
import org.silverpeas.core.util.ServiceProvider;

@Service
public class SocialNetworkService {
    private static final String AUTHORIZATION_TOKEN_SESSION_ATTR = "socialnetwork_authorization_token_";
    private static final String SOCIALNETWORK_ID_SESSION_ATTR = "socialnetwork_id";
    @Inject
    @Facebook
    private SocialNetworkConnector facebook;
    @Inject
    @LinkedIn
    private SocialNetworkConnector linkedIn;
    @Inject
    private ExternalAccountRepository dao;

    protected SocialNetworkService() {
    }

    public static SocialNetworkService getInstance() {
        return (SocialNetworkService)ServiceProvider.getService(SocialNetworkService.class, (Annotation[])new Annotation[0]);
    }

    public SocialNetworkConnector getSocialNetworkConnector(SocialNetworkID networkId) {
        switch (networkId) {
            case FACEBOOK: {
                return this.facebook;
            }
            case LINKEDIN: {
                return this.linkedIn;
            }
        }
        return null;
    }

    public SocialNetworkConnector getSocialNetworkConnector(String networkIdAsString) {
        SocialNetworkID networkId = SocialNetworkID.valueOf(networkIdAsString);
        return this.getSocialNetworkConnector(networkId);
    }

    public ExternalAccount getExternalAccount(SocialNetworkID networkId, String profileId) {
        return (ExternalAccount)this.dao.getById(new ExternalAccountIdentifier(networkId, profileId).asString());
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public void createExternalAccount(SocialNetworkID networkId, String userId, String profileId) {
        ExternalAccount account = new ExternalAccount();
        account.setExternalId(networkId, profileId);
        account.setSilverpeasUserId(userId);
        this.dao.saveAndFlush((IdentifiableEntity)account);
    }

    public List<ExternalAccount> getUserExternalAccounts(String userId) {
        List<ExternalAccount> accounts = this.dao.findBySilverpeasUserId(userId);
        if (accounts == null) {
            return new ArrayList<ExternalAccount>();
        }
        return accounts;
    }

    public void removeAuthorizationToken(HttpSession session) {
        SocialNetworkID networkId;
        if (session != null && (networkId = (SocialNetworkID)((Object)session.getAttribute(SOCIALNETWORK_ID_SESSION_ATTR))) != null) {
            session.setAttribute(SOCIALNETWORK_ID_SESSION_ATTR, null);
            session.setAttribute(AUTHORIZATION_TOKEN_SESSION_ATTR + String.valueOf((Object)networkId), null);
        }
    }

    public void storeAuthorizationToken(HttpSession session, SocialNetworkID networkId, AccessToken authorizationToken) {
        session.setAttribute(AUTHORIZATION_TOKEN_SESSION_ATTR + String.valueOf((Object)networkId), (Object)authorizationToken);
        session.setAttribute(SOCIALNETWORK_ID_SESSION_ATTR, (Object)networkId);
    }

    public AccessToken getStoredAuthorizationToken(HttpSession session, SocialNetworkID networkId) {
        return (AccessToken)session.getAttribute(AUTHORIZATION_TOKEN_SESSION_ATTR + String.valueOf((Object)networkId));
    }

    public SocialNetworkID getSocialNetworkIDUsedForLogin(HttpSession session) {
        return (SocialNetworkID)((Object)session.getAttribute(SOCIALNETWORK_ID_SESSION_ATTR));
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public void removeExternalAccount(String userId, SocialNetworkID networkId) {
        List<ExternalAccount> accounts = this.dao.findBySilverpeasUserId(userId);
        if (accounts != null) {
            for (ExternalAccount account : accounts) {
                if (account.getNetworkId() != networkId) continue;
                this.dao.delete((IdentifiableEntity[])new ExternalAccount[]{account});
                break;
            }
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public void removeAllExternalAccount(String userId) {
        List<ExternalAccount> accounts = this.dao.findBySilverpeasUserId(userId);
        if (accounts != null) {
            for (ExternalAccount account : accounts) {
                this.dao.delete((IdentifiableEntity[])new ExternalAccount[]{account});
            }
        }
    }
}

