/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.encryption;

import java.util.Map;
import org.silverpeas.core.security.encryption.ConcurrentEncryptionTaskExecutor;
import org.silverpeas.core.security.encryption.DefaultContentEncryptionService;
import org.silverpeas.core.security.encryption.EncryptionContentIterator;
import org.silverpeas.core.security.encryption.cipher.Cipher;
import org.silverpeas.core.security.encryption.cipher.CipherKey;
import org.silverpeas.core.security.encryption.cipher.CryptoException;

class CryptographicTask
implements ConcurrentEncryptionTaskExecutor.ConcurrentEncryptionTask<Void> {
    private final Type task;
    private final EncryptionContentIterator[] iterators;
    private boolean privileged = false;

    public static CryptographicTask encryptionOf(EncryptionContentIterator ... contents) {
        return new CryptographicTask(Type.ENCRYPTION, contents);
    }

    public static CryptographicTask decryptionOf(EncryptionContentIterator ... contents) {
        return new CryptographicTask(Type.DECRYPTION, contents);
    }

    public static CryptographicTask renewEncryptionOf(EncryptionContentIterator ... contents) {
        return new CryptographicTask(Type.RENEW, contents);
    }

    public CryptographicTask inPrivilegedMode() {
        this.privileged = true;
        return this;
    }

    @Override
    public boolean isPrivileged() {
        return this.privileged;
    }

    @Override
    public Void execute() throws CryptoException {
        Cipher cipher = DefaultContentEncryptionService.getCipherForContentEncryption();
        CipherKey actualKey = DefaultContentEncryptionService.getActualCipherKey();
        CipherKey previousKey = this.task == Type.RENEW ? DefaultContentEncryptionService.getPreviousCipherKey() : null;
        for (EncryptionContentIterator encryptionContentIterator : this.iterators) {
            this.process(encryptionContentIterator, cipher, actualKey, previousKey);
        }
        return null;
    }

    private void process(EncryptionContentIterator theContents, Cipher cipher, CipherKey actualKey, CipherKey previousKey) {
        theContents.init();
        while (theContents.hasNext()) {
            Map<String, String> content = theContents.next();
            try {
                switch (this.task) {
                    case ENCRYPTION: {
                        content = DefaultContentEncryptionService.encryptContent(content, cipher, actualKey);
                        break;
                    }
                    case DECRYPTION: {
                        content = DefaultContentEncryptionService.decryptContent(content, cipher, actualKey);
                        break;
                    }
                    case RENEW: {
                        content = DefaultContentEncryptionService.decryptContent(content, cipher, previousKey);
                        content = DefaultContentEncryptionService.encryptContent(content, cipher, actualKey);
                    }
                }
                theContents.update(content);
            }
            catch (Exception ex) {
                CryptoException error = ex instanceof CryptoException ? (CryptoException)ex : new CryptoException(ex.getMessage(), ex);
                theContents.onError(content, error);
            }
        }
    }

    CryptographicTask(Type taskType, EncryptionContentIterator ... iterators) {
        this.task = taskType;
        this.iterators = iterators;
    }

    private static enum Type {
        ENCRYPTION,
        DECRYPTION,
        RENEW;

    }
}

