/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.password.rule;

import org.silverpeas.core.security.authentication.password.constant.PasswordRuleType;
import org.silverpeas.core.security.authentication.password.rule.AbstractPasswordRule;
import org.silverpeas.kernel.util.StringUtil;

public class MaxLengthPasswordRule
extends AbstractPasswordRule {
    private boolean required = settings.getBoolean(this.getType().getSettingKey(), false);
    private Integer value = settings.getInteger(this.getType().getSettingKey() + ".value", 8);

    public MaxLengthPasswordRule() {
        super(PasswordRuleType.MAX_LENGTH);
        if (settings.getInteger(PasswordRuleType.MIN_LENGTH.getSettingKey(), 8) > this.value) {
            this.value = 8;
        }
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public Integer getValue() {
        return this.value;
    }

    @Override
    public boolean check(String password) {
        return StringUtil.isDefined((String)password) && password.length() <= this.getValue();
    }

    @Override
    public String random() {
        return "";
    }
}

