/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.password.rule;

import org.silverpeas.core.security.authentication.password.constant.PasswordRuleType;
import org.silverpeas.core.security.authentication.password.rule.AbstractPasswordRule;
import org.silverpeas.kernel.util.StringUtil;

public class AtLeastXUppercasePasswordRule
extends AbstractPasswordRule {
    private Integer value;
    private boolean required = settings.getBoolean(this.getType().getSettingKey(), false);
    private boolean combined;

    public AtLeastXUppercasePasswordRule() {
        super(PasswordRuleType.AT_LEAST_X_UPPERCASE);
        this.value = this.getIntegerFromSettings(this.getType().getSettingKey() + ".X", 0);
        this.combined = settings.getBoolean(this.getType().getSettingKey() + ".combined", false);
        if (this.value == 0) {
            this.required = false;
            this.combined = false;
        }
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isCombined() {
        return this.combined;
    }

    public Integer getValue() {
        return this.value;
    }

    @Override
    public boolean check(String password) {
        return StringUtil.isDefined((String)password) && this.countRegexOccur(password, "[A-Z]") >= this.value;
    }

    @Override
    public String random() {
        StringBuilder random = new StringBuilder();
        for (int i = 0; i < this.value; ++i) {
            random.append((char)(65 + this.random(26)));
        }
        return random.toString();
    }
}

