/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.process.management;

import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.process.SilverpeasProcess;
import org.silverpeas.core.process.check.ProcessCheck;
import org.silverpeas.core.process.management.InternalContext;
import org.silverpeas.core.process.management.ProcessCheckRegistration;
import org.silverpeas.core.process.management.ProcessErrorType;
import org.silverpeas.core.process.management.ProcessExecutionContext;
import org.silverpeas.core.process.management.ProcessManagement;
import org.silverpeas.core.process.management.ProcessMonitoring;
import org.silverpeas.core.process.session.ProcessSession;
import org.silverpeas.core.process.util.ProcessList;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.logging.SilverLogger;

@Singleton
public class DefaultProcessManagement
implements ProcessManagement {
    private final ThreadLocal<LinkedList<InternalContext<?>>> parentFileTransactions = new ThreadLocal();

    @Override
    public <C extends ProcessExecutionContext> void execute(SilverpeasProcess<C> process, C processExecutionContext) throws Exception {
        this.execute(new ProcessList(process), processExecutionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(value=Transactional.TxType.SUPPORTS)
    public <C extends ProcessExecutionContext> void execute(ProcessList<C> processes, C processExecutionContext) throws Exception {
        if (!processes.isNotEmpty()) {
            return;
        }
        InternalContext<C> context = null;
        LinkedList existingInternalParentContexts = this.parentFileTransactions.get();
        LinkedList internalParentContexts = existingInternalParentContexts == null ? new LinkedList() : existingInternalParentContexts;
        try {
            context = this.initInternalContext(processExecutionContext, internalParentContexts);
            for (Map.Entry<String, Object> entry : processes.getSessionParameters().entrySet()) {
                context.getSession().setAttribute(entry.getKey(), entry.getValue());
            }
            for (SilverpeasProcess silverpeasProcess : processes.getList()) {
                if (context.isFileTransactionInError()) break;
                context.update(silverpeasProcess);
                this.processing(silverpeasProcess, context);
            }
            if (context.isOpeningFileTransaction() && !context.isFileTransactionInError()) {
                this.checks(context);
                if (!context.isFileTransactionInError()) {
                    this.processSuccessfulExecution(context);
                }
            }
        }
        finally {
            if (context != null && context.isOpeningFileTransaction()) {
                internalParentContexts.pollLast();
                if (CollectionUtil.isEmpty(internalParentContexts)) {
                    this.parentFileTransactions.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C extends ProcessExecutionContext> void processSuccessfulExecution(InternalContext<C> context) throws Exception {
        try {
            for (InternalContext<ProcessExecutionContext> curContext = context.getLast(); curContext != null; curContext = curContext.getPrevious()) {
                for (SilverpeasProcess<ProcessExecutionContext> process : curContext.getOnSuccessfulProcesses()) {
                    this.onSuccessful(process, curContext);
                }
            }
        }
        finally {
            this.commit(context);
        }
    }

    @Nonnull
    private <C extends ProcessExecutionContext> InternalContext<C> initInternalContext(C processExecutionContext, LinkedList<InternalContext<?>> internalParentContexts) {
        InternalContext<C> context;
        if (!internalParentContexts.isEmpty() && !processExecutionContext.requiresNewFileTransaction()) {
            context = new InternalContext<C>(Objects.requireNonNull(internalParentContexts.peekLast()).getLast(), processExecutionContext);
        } else {
            if (internalParentContexts.isEmpty()) {
                this.parentFileTransactions.set(internalParentContexts);
            }
            context = new InternalContext<C>(processExecutionContext);
            processExecutionContext.setFileHandler(new FileHandler(context.getSession()));
            internalParentContexts.add(context);
        }
        return context;
    }

    private <C extends ProcessExecutionContext> void processing(SilverpeasProcess<C> process, InternalContext<C> context) throws Exception {
        try {
            process.process(context.getProcessExecutionContext(), context.getSession());
        }
        catch (Exception exception) {
            this.handleError(context, ProcessErrorType.DURING_MAIN_PROCESSING, exception, process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checks(InternalContext<?> context) throws Exception {
        Object object = ProcessMonitoring.SYNCHRONIZE;
        synchronized (object) {
            try {
                for (ProcessCheck check : ProcessCheckRegistration.getChecks()) {
                    if (!context.getCheckTypesToProcess().contains((Object)check.getType())) continue;
                    check.check((ProcessExecutionContext)context.getProcessExecutionContext());
                }
            }
            catch (Exception exception) {
                this.handleError(context, ProcessErrorType.DURING_CHECKS_PROCESSING, exception, null);
            }
        }
    }

    private void onSuccessful(SilverpeasProcess<?> process, InternalContext<?> context) {
        try {
            process.onSuccessful();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("The process has thrown an exception while processing the successful status (sessionId = " + context.getSession().getId() + ")", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(InternalContext<?> context, ProcessErrorType errorType, Exception exception, SilverpeasProcess<?> fromProcess) throws Exception {
        if (!context.isFileTransactionInError()) {
            context.setFileTransactionInError(errorType, exception, fromProcess);
        }
        if (!context.isOpeningFileTransaction()) {
            throw exception;
        }
        try {
            errorType = context.getErrorType();
            exception = context.getException();
            fromProcess = context.getProcessInError();
            SilverLogger.getLogger((Object)this).error("The process has failed. Stack info: sessionId = " + context.getSession().getId() + ", ioErrorType = " + errorType.name() + ", exceptionClassName = " + exception.getClass().getName(), (Throwable)exception);
            Exception continueException = null;
            for (InternalContext<ProcessExecutionContext> curContext = context.getLast(); curContext != null; curContext = curContext.getPrevious()) {
                for (SilverpeasProcess<ProcessExecutionContext> processStarted : curContext.getOnFailureProcesses()) {
                    continueException = this.processFailure(errorType, exception, fromProcess, continueException, processStarted);
                }
            }
            if (continueException != null) {
                throw continueException;
            }
        }
        finally {
            this.rollback(context);
        }
    }

    private Exception processFailure(ProcessErrorType errorType, Exception exception, SilverpeasProcess<?> fromProcess, Exception continueException, SilverpeasProcess<?> processStarted) {
        block2: {
            try {
                processStarted.onFailure(ProcessErrorType.DURING_CHECKS_PROCESSING.equals((Object)errorType) || processStarted == fromProcess ? errorType : ProcessErrorType.OTHER_PROCESS_FAILED, exception);
            }
            catch (Exception e) {
                if (continueException != null) break block2;
                continueException = e;
            }
        }
        return continueException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(InternalContext<?> context) throws Exception {
        Object object = ProcessMonitoring.SYNCHRONIZE;
        synchronized (object) {
            try {
                ((FileHandler)((ProcessExecutionContext)context.getProcessExecutionContext()).getFileHandler()).checkinSessionWorkingPath();
            }
            finally {
                this.clearSession(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback(InternalContext<?> context) {
        if (context.isOpeningFileTransaction()) {
            Object object = ProcessMonitoring.SYNCHRONIZE;
            synchronized (object) {
                this.clearSession(context);
            }
        }
    }

    private void clearSession(InternalContext<?> context) {
        if (context.isOpeningFileTransaction()) {
            ((FileHandler)((ProcessExecutionContext)context.getProcessExecutionContext()).getFileHandler()).deleteSessionWorkingPath();
        }
    }

    private static final class FileHandler
    extends org.silverpeas.core.process.io.file.FileHandler {
        private FileHandler(ProcessSession session) {
            super(session);
        }

        @Override
        public void deleteSessionWorkingPath() {
            super.deleteSessionWorkingPath();
        }

        @Override
        public void checkinSessionWorkingPath() throws Exception {
            super.checkinSessionWorkingPath();
        }
    }
}

