/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.delayed.scheduler;

import java.text.ParseException;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.notification.user.client.NotificationURLProvider;
import org.silverpeas.core.notification.user.delayed.scheduler.DelayedNotificationListener;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.kernel.SilverpeasRuntimeException;

@Service
public class DelayedNotificationSchedulerInitializer
implements NotificationURLProvider,
Initialization {
    public static final String JOB_NAME = "DelayedNotificationJob";
    @Inject
    private Scheduler scheduler;
    @Inject
    private DelayedNotificationListener listener;

    public void init() {
        try {
            String cron = NotificationManagerSettings.getCronOfDelayedNotificationSending();
            this.scheduler.unscheduleJob(JOB_NAME);
            if (StringUtils.isNotBlank((CharSequence)cron)) {
                this.scheduler.scheduleJob(JOB_NAME, JobTrigger.triggerAt((String)cron), (SchedulerEventListener)this.listener);
            }
        }
        catch (ParseException | SchedulerException e) {
            throw new SilverpeasRuntimeException(e.getMessage(), e);
        }
    }
}

