/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.client.model;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.notification.user.client.model.NotifPreferenceRow;
import org.silverpeas.core.persistence.jdbc.AbstractTable;

@Repository
public class NotifPreferenceTable
extends AbstractTable<NotifPreferenceRow> {
    protected static final String NOTIFPREFERENCE_COLUMNS = "id,notifAddressId,componentInstanceId,userId,messageType";
    private static final String SELECT = "select ";
    private static final String SELECT_NOTIFPREFERENCE_BY_ID = "select id,notifAddressId,componentInstanceId,userId,messageType from ST_NotifPreference where id = ?";
    private static final String SELECT_NOTIFPREFERENCE_BY_USERID_AND_COMPONENTINSTANCEID_AND_MESSAGETYPE = "select id,notifAddressId,componentInstanceId,userId,messageType from ST_NotifPreference where userId=? and componentInstanceId=? and messageType=?";
    private static final String SELECT_ALL_NOTIFPREFERENCE_WITH_GIVEN_COMPONENTINSTANCEID = "select id,notifAddressId,componentInstanceId,userId,messageType from ST_NotifPreference where componentInstanceId=?";
    private static final String SELECT_ALL_NOTIFPREFERENCE_WITH_GIVEN_USERID = "select id,notifAddressId,componentInstanceId,userId,messageType from ST_NotifPreference where userId=?";
    private static final String SELECT_ALL_NOTIFPREFERENCE = "select id,notifAddressId,componentInstanceId,userId,messageType from ST_NotifPreference";
    private static final String INSERT_NOTIFPREFERENCE = "insert into ST_NotifPreference (id, notifAddressId, componentInstanceId, userId, messageType) values  (?, ?, ?, ?, ?)";
    private static final String UPDATE_NOTIFPREFERENCE = "update ST_NotifPreference set notifAddressId = ?, componentInstanceId = ?, userId = ?, messageType = ? Where id = ?";
    private static final String DELETE_NOTIFPREFERENCE = "delete from ST_NotifPreference where id=?";

    NotifPreferenceTable() {
        super("ST_NotifPreference");
    }

    public NotifPreferenceRow getNotifPreference(int id) throws SQLException {
        return (NotifPreferenceRow)this.getUniqueRow(SELECT_NOTIFPREFERENCE_BY_ID, id);
    }

    public NotifPreferenceRow getByUserIdAndComponentInstanceIdAndMessageType(int userId, int componentInstanceId, int messageType) throws SQLException {
        int[] intArgs = new int[]{userId, componentInstanceId, messageType};
        return (NotifPreferenceRow)this.getUniqueRow(SELECT_NOTIFPREFERENCE_BY_USERID_AND_COMPONENTINSTANCEID_AND_MESSAGETYPE, intArgs);
    }

    public NotifPreferenceRow[] getAllByComponentInstanceId(int componentInstanceId) throws SQLException {
        List rows = this.getRows(SELECT_ALL_NOTIFPREFERENCE_WITH_GIVEN_COMPONENTINSTANCEID, componentInstanceId);
        return rows.toArray(new NotifPreferenceRow[rows.size()]);
    }

    public NotifPreferenceRow[] getAllByUserId(int userId) throws SQLException {
        List rows = this.getRows(SELECT_ALL_NOTIFPREFERENCE_WITH_GIVEN_USERID, userId);
        return rows.toArray(new NotifPreferenceRow[rows.size()]);
    }

    public NotifPreferenceRow[] getAllRows() throws SQLException {
        List rows = this.getRows(SELECT_ALL_NOTIFPREFERENCE);
        return rows.toArray(new NotifPreferenceRow[rows.size()]);
    }

    public NotifPreferenceRow getNotifPreference(String query) throws SQLException {
        return (NotifPreferenceRow)this.getUniqueRow(query);
    }

    public NotifPreferenceRow[] getNotifPreferences(String query) throws SQLException {
        List rows = this.getRows(query);
        return rows.toArray(new NotifPreferenceRow[rows.size()]);
    }

    public int create(NotifPreferenceRow notifPreference) throws SQLException {
        this.insertRow(INSERT_NOTIFPREFERENCE, notifPreference);
        return notifPreference.getId();
    }

    public void update(NotifPreferenceRow notifPreference) throws SQLException {
        this.updateRow(UPDATE_NOTIFPREFERENCE, notifPreference);
    }

    public void save(NotifPreferenceRow notifPreference) throws SQLException {
        if (notifPreference.getId() == -1) {
            this.create(notifPreference);
        } else {
            this.update(notifPreference);
        }
    }

    public void delete(int id) throws SQLException {
        this.updateRelation(DELETE_NOTIFPREFERENCE, id);
    }

    public void dereferenceComponentInstanceId(int componentInstanceId) throws SQLException {
        NotifPreferenceRow[] notifPreferenceToBeDeleted;
        for (NotifPreferenceRow aNotifPreferenceToBeDeleted : notifPreferenceToBeDeleted = this.getAllByComponentInstanceId(componentInstanceId)) {
            this.delete(aNotifPreferenceToBeDeleted.getId());
        }
    }

    public void dereferenceUserId(int userId) throws SQLException {
        NotifPreferenceRow[] notifPreferenceToBeDeleted;
        for (NotifPreferenceRow aNotifPreferenceToBeDeleted : notifPreferenceToBeDeleted = this.getAllByUserId(userId)) {
            this.delete(aNotifPreferenceToBeDeleted.getId());
        }
    }

    protected NotifPreferenceRow fetchRow(ResultSet rs) throws SQLException {
        return new NotifPreferenceRow(rs.getInt("id"), rs.getInt("notifAddressId"), rs.getInt("componentInstanceId"), rs.getInt("userId"), rs.getInt("messageType"));
    }

    protected void prepareUpdate(String updateQuery, PreparedStatement update, NotifPreferenceRow r) throws SQLException {
        update.setInt(1, r.getNotifAddressId());
        update.setInt(2, r.getComponentInstanceId());
        update.setInt(3, r.getUserId());
        update.setInt(4, r.getMessageType());
        update.setInt(5, r.getId());
    }

    protected void prepareInsert(String insertQuery, PreparedStatement insert, NotifPreferenceRow r) throws SQLException {
        if (r.getId() == -1) {
            r.setId(this.getNextId());
        }
        insert.setInt(1, r.getId());
        insert.setInt(2, r.getNotifAddressId());
        insert.setInt(3, r.getComponentInstanceId());
        insert.setInt(4, r.getUserId());
        insert.setInt(5, r.getMessageType());
    }
}

