/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.file;

import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.exception.RelativeFileAccessException;
import org.silverpeas.core.io.file.AbstractSilverpeasFileProcessor;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.io.file.SilverpeasFileProcessor;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class RelativePathCheckingProcessor
extends AbstractSilverpeasFileProcessor {
    private static final int PRIORITY = 95;

    @Override
    public int getPriority() {
        return 95;
    }

    @Override
    public String processBefore(String path, SilverpeasFileProcessor.ProcessingContext context) {
        return path;
    }

    @Override
    public SilverpeasFile processAfter(SilverpeasFile file, SilverpeasFileProcessor.ProcessingContext context) {
        try {
            FileUtil.assertPathNotRelative(file.getPath());
            return file;
        }
        catch (RelativeFileAccessException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
            return SilverpeasFile.NO_FILE;
        }
    }
}

