/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.displayers.LdapFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.JdbcField;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.kernel.util.StringUtil;

public class JdbcFieldDisplayer
extends AbstractFieldDisplayer<JdbcField> {
    private static final String[] MANAGED_TYPES = new String[]{"jdbc"};
    private static final String MANDATORY_IMG = Util.getIcon("mandatoryField");
    private static final String THIS_O_AUTO_COMP = " this.oAutoComp";

    public String[] getManagedTypes() {
        return MANAGED_TYPES;
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) {
        JdbcFieldDisplayer.produceMandatoryCheck(out, template, pagesContext);
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, JdbcField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        String currentUserId = pagesContext.getUserId();
        String language = pagesContext.getLanguage();
        String fieldName = template.getFieldName();
        Map<String, String> parameters = template.getParameters(language);
        String value = "";
        if (!field.isNull()) {
            value = field.getValue(language);
        }
        String valueFieldType = "1";
        if (parameters.containsKey("valueFieldType")) {
            valueFieldType = parameters.get("valueFieldType");
        }
        Collection<String> listRes = this.getResponses(currentUserId, field, parameters);
        StringBuilder html2 = new StringBuilder(10000);
        if (listRes != null && !listRes.isEmpty()) {
            String displayer = parameters.get("displayer");
            if (!StringUtil.isDefined((String)displayer)) {
                displayer = "autocomplete";
            }
            if ("autocomplete".equals(displayer)) {
                this.getAutocompleteFragment(template, value, valueFieldType, listRes, pagesContext, html2);
            } else {
                this.getListboxFragment(template, value, listRes, pagesContext, html2);
            }
        } else {
            this.generateDefaultView(html2, template, fieldName, valueFieldType);
        }
        out.println(html2);
    }

    private void generateDefaultView(StringBuilder html2, FieldTemplate template, String fieldName, String valueFieldType) {
        if ("1".equals(valueFieldType)) {
            html2.append("<select name=\"").append(fieldName).append("\"");
            if (template.isDisabled() || template.isReadOnly()) {
                html2.append(" disabled");
            }
            html2.append(" >\n");
            html2.append("</select>\n");
        } else {
            html2.append("<input type=\"text\" name=\"").append(fieldName).append("\"");
            if (template.isDisabled() || template.isReadOnly()) {
                html2.append(" disabled=\"disabled\"");
            }
            html2.append(" />\n");
        }
        if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden()) {
            html2.append("&nbsp;<img src=\"").append(MANDATORY_IMG).append("\" width=\"5\" height=\"5\" border=\"0\" alt=\"\"/>&nbsp;\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getResponses(String currentUserId, JdbcField field, Map<String, String> parameters) throws FormException {
        Collection<String> listRes;
        Connection jdbcConnection = null;
        try {
            jdbcConnection = field.connect(parameters.get("dataSourceName"), parameters.get("login"), parameters.get("password"));
            listRes = field.selectSql(jdbcConnection, parameters.get("query"), currentUserId);
        }
        catch (Throwable throwable) {
            DBUtil.close(jdbcConnection);
            throw throwable;
        }
        DBUtil.close((Connection)jdbcConnection);
        return listRes;
    }

    private void getAutocompleteFragment(FieldTemplate template, String fieldValue, String valueFieldType, Collection<String> entries, PagesContext pageContext, StringBuilder html2) {
        String fieldName = template.getFieldName();
        int zindex = 100;
        html2.append("<style type=\"text/css\">\n").append(" #listAutocomplete").append(fieldName).append(" {\n");
        html2.append("  width:15em;\n");
        html2.append("  padding-bottom:2em;\n");
        html2.append(" }\n");
        html2.append(" #container").append(fieldName).append(" {\n");
        html2.append("  z-index:").append(zindex).append("; /* z-index needed on top instance for ie & sf absolute inside relative issue */\n");
        html2.append(" }\n");
        html2.append(" #").append(fieldName).append(" {\n");
        html2.append("  _position:absolute; /* abs pos needed for ie quirks */\n");
        html2.append(" }\n");
        html2.append("</style>\n");
        html2.append("<div id=\"listAutocomplete").append(fieldName).append("\">\n");
        html2.append("<input id=\"").append(fieldName).append("\" name=\"").append(fieldName).append("\" type=\"text\"");
        if (fieldValue != null) {
            html2.append(" value=\"").append(fieldValue).append("\"");
        }
        if (template.isDisabled() || template.isReadOnly()) {
            html2.append(" disabled");
        }
        html2.append("/>\n");
        html2.append("<div id=\"container").append(fieldName).append("\"/>\n");
        html2.append("</div>\n");
        if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pageContext.useMandatory()) {
            html2.append("<img src=\"").append(MANDATORY_IMG).append("\" width=\"5\" height=\"5\" border=\"0\" alt=\"\" style=\"position:absolute;left:16em;top:5px\"/>\n");
        }
        JdbcFieldDisplayer.generateFragmentHTML(entries, html2, fieldName);
        html2.append(" this.oACDS").append(fieldName).append(" = new YAHOO.util.LocalDataSource(listArray").append(fieldName).append(");\n");
        html2.append(THIS_O_AUTO_COMP).append(fieldName).append(" = new YAHOO.widget.AutoComplete('").append(fieldName).append("','container").append(fieldName).append("', this.oACDS").append(fieldName).append(");\n");
        html2.append(THIS_O_AUTO_COMP).append(fieldName).append(".prehighlightClassName = \"yui-ac-prehighlight\";\n");
        LdapFieldDisplayer.generateAutoComp(fieldName, valueFieldType, html2, THIS_O_AUTO_COMP);
        LdapFieldDisplayer.generateYahooCode(fieldName, html2);
    }

    static void generateFragmentHTML(Collection<String> entries, StringBuilder html2, String fieldName) {
        html2.append("<script type=\"text/javascript\">\n");
        html2.append("listArray").append(fieldName).append(" = [\n");
        Iterator<String> itRes = entries.iterator();
        while (itRes.hasNext()) {
            html2.append("\"").append(WebEncodeHelper.javaStringToJsString((String)itRes.next())).append("\"");
            if (!itRes.hasNext()) continue;
            html2.append(",\n");
        }
        html2.append("];\n");
        html2.append("</script>\n");
        html2.append("<script type=\"text/javascript\">\n");
    }

    private void getListboxFragment(FieldTemplate template, String fieldValue, Collection<String> entries, PagesContext pageContext, StringBuilder html2) {
        html2.append("<select name=\"").append(template.getFieldName()).append("\"");
        html2.append(" id=\"").append(template.getFieldName()).append("\"");
        if (template.isDisabled() || template.isReadOnly()) {
            html2.append(" disabled=\"disabled\"");
        }
        html2.append(" >\n");
        html2.append("<option value=\"\"></option>");
        for (String entry : entries) {
            html2.append("<option");
            if (entry.equals(fieldValue)) {
                html2.append(" selected=\"selected\"");
            }
            html2.append(" value=\"").append(entry).append("\">").append(entry).append("</option>\n");
        }
        html2.append("</select>\n");
        if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pageContext.useMandatory()) {
            html2.append(Util.getMandatorySnippet());
        }
    }

    @Override
    public List<String> update(String newValue, JdbcField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (!"jdbc".equals(field.getTypeName())) {
            throw new FormException("Incorrect field type '{0}', expected; {0}", "jdbc");
        }
        if (!field.acceptValue(newValue, pagesContext.getLanguage())) {
            throw new FormException("Incorrect field value type. Expected {0}", "jdbc");
        }
        field.setValue(newValue, pagesContext.getLanguage());
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }
}

