/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.fileupload.FileItem;
import org.apache.ecs.Element;
import org.apache.ecs.html.A;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.Input;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldDisplayer;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.TypeManager;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.util.error.SilverpeasTransverseErrorUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractForm
implements Form {
    private final List<FieldTemplate> fieldTemplates;
    private String title = "";
    private String name = "";
    private String formName = "";
    private DataRecord data;
    private boolean viewForm = false;
    public static final String REPEATED_FIELD_CSS_SHOW = "field-occurrence-shown";
    public static final String REPEATED_FIELD_CSS_HIDE = "field-occurrence-hidden";
    public static final String REPEATED_FIELD_SEPARATOR = "__SSPP__";

    public AbstractForm(RecordTemplate template) throws FormException {
        this.fieldTemplates = template != null ? Arrays.asList(template.getFieldTemplates()) : new ArrayList<FieldTemplate>();
    }

    @Override
    public void setFormName(String name) {
        this.formName = name;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    @Override
    public List<FieldTemplate> getFieldTemplates() {
        return this.fieldTemplates;
    }

    @Override
    public String getTitle() {
        return this.title == null ? "" : this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void displayScripts(JspWriter jw, PagesContext pagesContext) {
        try {
            ComponentInstLight component;
            String language = pagesContext.getLanguage();
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter((Writer)sw, true);
            boolean jsAdded = false;
            if (StringUtil.isDefined((String)pagesContext.getComponentId()) && StringUtil.isDefined((String)this.getName()) && (component = OrganizationControllerProvider.getOrganisationController().getComponentInstLight(pagesContext.getComponentId())) != null && component.isWorkflow()) {
                out.append("<script type=\"text/javascript\" src=\"/weblib/workflows/").append(component.getName()).append("/").append(this.getName()).append(".js\"></script>\n");
                jsAdded = true;
            }
            if (!jsAdded) {
                out.append(this.getJavascriptSnippet());
            }
            PagesContext pc = new PagesContext(pagesContext);
            pc.incCurrentFieldIndex(1);
            out.append(Util.getJavascriptIncludes(language)).append("\n<script type=\"text/javascript\">\n").append("  var errorNb = 0;\n").append("  var errorMsg = \"\";\n").append("function addXMLError(message) {\n").append("  errorMsg+=\"  - \"+message+\"\\n\";\n").append("  errorNb++;\n").append("}\n").append("function getXMLField(fieldName) {\n").append("  return document.getElementById(fieldName);\n").append("}\n");
            this.printJavascriptIgnoreMandatorySnippet(out);
            this.printJavascriptSkippableSnippet(out);
            Object functionName = "ifCorrectFormExecute";
            if (pagesContext.isMultiFormInPage()) {
                functionName = "ifCorrectForm" + pagesContext.getFormIndex() + "Execute";
            }
            String initFunctionName = ((String)functionName).replaceAll("Execute$", "Init");
            out.append("function ").append((CharSequence)functionName).append("(callback) {\n").append("  errorMsg = \"\";\n").append("  errorNb = 0;\n").append("  if (typeof ").append(initFunctionName).append(" === 'function') {\n").append("    ").append(initFunctionName).append("();\n").append("  }\n").append("  var field;\n").append("\n\n");
            out.append("if (ignoreForm) {\n").append("callback.call(this);return;\n").append("}\n");
            for (FieldTemplate fieldTemplate : this.fieldTemplates) {
                if (fieldTemplate == null) continue;
                String fieldDisplayerName = fieldTemplate.getDisplayerName();
                String fieldType = fieldTemplate.getTypeName();
                String fieldName = fieldTemplate.getFieldName();
                boolean mandatory = fieldTemplate.isMandatory();
                this.displayFieldTemplate(out, pc, fieldTemplate, fieldDisplayerName, fieldType, fieldName, mandatory);
            }
            out.append("\n\n").append("  switch(errorNb)\n").append("  {\n").append("  case 0 :\n").append("    callback.call(this);\n").append("    break;\n").append("  case 1 :\n").append("    errorMsg = \"").append(Util.getString("GML.ThisFormContains", language)).append(" 1 ").append(Util.getString("GML.error", language)).append(" : \\n \" + errorMsg;\n").append("   jQuery.popup.error(errorMsg);\n").append("   break;\n").append("  default :\n").append("   errorMsg = \"").append(Util.getString("GML.ThisFormContains", language)).append(" \" + errorNb + \" ").append(Util.getString("GML.errors", language)).append(" :\\n \" + errorMsg;\n").append("   jQuery.popup.error(errorMsg);\n").append(" }\n").append("}\n").append("\n\n");
            out.append("function showOneMoreField(fieldName) {\n");
            out.append("$('.field_'+fieldName+' .field-occurrence-hidden:first').removeClass('field-occurrence-hidden').addClass('field-occurrence-shown');\n");
            out.append("if ($('.field_'+fieldName+' .field-occurrence-hidden').length == 0) {\n");
            out.append(" $('#form-row-'+fieldName+' #moreField-'+fieldName).hide();\n");
            out.append("}\n");
            out.append("}\n");
            out.append("</script>\n");
            out.flush();
            jw.write(sw.toString());
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    private void displayFieldTemplate(PrintWriter out, PagesContext pc, FieldTemplate fieldTemplate, String fieldDisplayerName, String fieldType, String fieldName, boolean mandatory) throws IOException {
        try {
            FieldDisplayer fieldDisplayer;
            if (fieldDisplayerName == null || fieldDisplayerName.isEmpty()) {
                fieldDisplayerName = this.getTypeManager().getDisplayerName(fieldType);
            }
            if ((fieldDisplayer = this.getTypeManager().getDisplayer(fieldType, fieldDisplayerName)) != null) {
                int nbFieldsToDisplay = fieldTemplate.getMaximumNumberOfOccurrences();
                for (int i = 0; i < nbFieldsToDisplay; ++i) {
                    String currentFieldName = Util.getFieldOccurrenceName(fieldName, i);
                    ((GenericFieldTemplate)fieldTemplate).setFieldName(currentFieldName);
                    if (i > 0) {
                        ((GenericFieldTemplate)fieldTemplate).setMandatory(false);
                    }
                    out.append("  field = document.getElementById(\"").append(currentFieldName).append("\");\n");
                    out.append("  if (field == null) {\n");
                    out.append("  var $field = $(\"input[name='").append(currentFieldName).append("']\");\n");
                    out.append("  field = $field.length ? $field[0] : null;\n");
                    out.println("}");
                    out.append(" if (field != null) {\n");
                    fieldDisplayer.displayScripts(out, fieldTemplate, pc);
                    out.println("}");
                    pc.incCurrentFieldIndex(fieldDisplayer.getNbHtmlObjectsDisplayed(fieldTemplate, pc));
                }
                ((GenericFieldTemplate)fieldTemplate).setFieldName(fieldName);
                ((GenericFieldTemplate)fieldTemplate).setMandatory(mandatory);
            }
        }
        catch (FormException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public abstract void display(JspWriter var1, PagesContext var2, DataRecord var3);

    @Override
    public void display(JspWriter out, PagesContext pagesContext) {
        this.display(out, pagesContext, this.getData());
    }

    @Override
    public List<String> update(List<FileItem> items, DataRecord record, PagesContext pagesContext) {
        return this.update(items, record, pagesContext, true);
    }

    @Override
    public List<String> update(List<FileItem> items, DataRecord record, PagesContext pagesContext, boolean updateWysiwyg) {
        ArrayList<String> attachmentIds = new ArrayList<String>();
        for (FieldTemplate fieldTemplate : this.fieldTemplates) {
            if (!fieldTemplate.isReadOnly()) {
                this.updateField(items, record, pagesContext, updateWysiwyg, attachmentIds, fieldTemplate);
                continue;
            }
            SilverLogger.getLogger((Object)this).debug("Field {0} is ignored as it is read only", new Object[]{fieldTemplate.getFieldName()});
        }
        return attachmentIds;
    }

    private void updateField(List<FileItem> items, DataRecord record, PagesContext pagesContext, boolean updateWysiwyg, List<String> attachmentIds, FieldTemplate fieldTemplate) {
        String fieldName = fieldTemplate.getFieldName();
        String fieldType = fieldTemplate.getTypeName();
        String fieldDisplayerName = fieldTemplate.getDisplayerName();
        try {
            FieldDisplayer<Field> fieldDisplayer;
            if (fieldDisplayerName == null || fieldDisplayerName.isEmpty()) {
                fieldDisplayerName = this.getTypeManager().getDisplayerName(fieldType);
            }
            if ((!"wysiwyg".equals(fieldDisplayerName) || updateWysiwyg) && (fieldDisplayer = this.getTypeManager().getDisplayer(fieldType, fieldDisplayerName)) != null) {
                for (int occ = 0; occ < fieldTemplate.getMaximumNumberOfOccurrences(); ++occ) {
                    attachmentIds.addAll(fieldDisplayer.update(items, record.getField(fieldName, occ), fieldTemplate, pagesContext));
                }
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            SilverpeasTransverseErrorUtil.throwTransverseErrorIfAny(e, pagesContext.getLanguage());
        }
    }

    @Override
    public List<String> updateWysiwyg(List<FileItem> items, DataRecord record, PagesContext pagesContext) {
        ArrayList<String> attachmentIds = new ArrayList<String>();
        for (FieldTemplate fieldTemplate : this.fieldTemplates) {
            this.updateWysiwygField(items, record, pagesContext, attachmentIds, fieldTemplate);
        }
        return attachmentIds;
    }

    private void updateWysiwygField(List<FileItem> items, DataRecord record, PagesContext pagesContext, List<String> attachmentIds, FieldTemplate fieldTemplate) {
        if (fieldTemplate != null) {
            String fieldName = fieldTemplate.getFieldName();
            String fieldType = fieldTemplate.getTypeName();
            String fieldDisplayerName = fieldTemplate.getDisplayerName();
            try {
                FieldDisplayer<Field> fieldDisplayer;
                if (fieldDisplayerName == null || fieldDisplayerName.isEmpty()) {
                    fieldDisplayerName = this.getTypeManager().getDisplayerName(fieldType);
                }
                if ("wysiwyg".equals(fieldDisplayerName) && (fieldDisplayer = this.getTypeManager().getDisplayer(fieldType, fieldDisplayerName)) != null) {
                    attachmentIds.addAll(fieldDisplayer.update(items, record.getField(fieldName), fieldTemplate, pagesContext));
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public boolean isEmpty(List<FileItem> items, DataRecord record, PagesContext pagesContext) {
        boolean isEmpty = true;
        for (FieldTemplate fieldTemplate : this.fieldTemplates) {
            if (fieldTemplate != null) {
                isEmpty = this.checkFieldIsEmpty(items, pagesContext, isEmpty, fieldTemplate);
            }
            if (isEmpty) continue;
            break;
        }
        return isEmpty;
    }

    private boolean checkFieldIsEmpty(List<FileItem> items, PagesContext pagesContext, boolean isEmpty, FieldTemplate fieldTemplate) {
        String fieldType = fieldTemplate.getTypeName();
        String fieldDisplayerName = fieldTemplate.getDisplayerName();
        try {
            FieldDisplayer fieldDisplayer;
            if (!StringUtil.isDefined((String)fieldDisplayerName)) {
                fieldDisplayerName = this.getTypeManager().getDisplayerName(fieldType);
            }
            if ((fieldDisplayer = this.getTypeManager().getDisplayer(fieldType, fieldDisplayerName)) != null) {
                String itemValue;
                String itemName = fieldTemplate.getFieldName();
                FileItem item = this.getParameter(items, itemName);
                isEmpty = item != null && !item.isFormField() && StringUtil.isDefined((String)item.getName()) ? false : !StringUtil.isDefined((String)(itemValue = this.getParameterValue(items, itemName, pagesContext.getEncoding())));
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
        return isEmpty;
    }

    private String getParameterValue(List<FileItem> items, String parameterName, String encoding) throws UnsupportedEncodingException {
        FileItem item = this.getParameter(items, parameterName);
        if (item != null && item.isFormField()) {
            return item.getString(encoding);
        }
        return null;
    }

    private FileItem getParameter(List<FileItem> items, String parameterName) {
        FileItem fileItem = null;
        for (FileItem item : items) {
            if (!parameterName.equals(item.getFieldName())) continue;
            fileItem = item;
            break;
        }
        return fileItem;
    }

    private TypeManager getTypeManager() {
        return TypeManager.getInstance();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected Field getSureField(FieldTemplate fieldTemplate, DataRecord record, int occurrence) {
        Field field = null;
        try {
            field = record.getField(fieldTemplate.getFieldName(), occurrence);
            if (field == null) {
                field = fieldTemplate.getEmptyField(occurrence);
            }
        }
        catch (FormException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
        }
        return field;
    }

    @Override
    public DataRecord getData() {
        return this.data;
    }

    @Override
    public void setData(DataRecord data) {
        this.data = data;
    }

    @Override
    public void setViewForm(boolean viewForm) {
        this.viewForm = viewForm;
    }

    public boolean isViewForm() {
        return this.viewForm;
    }

    protected <T extends Field> FieldDisplayer<T> getFieldDisplayer(FieldTemplate fieldTemplate) {
        try {
            String fieldDisplayerName = fieldTemplate.getDisplayerName();
            String fieldType = fieldTemplate.getTypeName();
            if (!StringUtil.isDefined((String)fieldDisplayerName)) {
                fieldDisplayerName = this.getTypeManager().getDisplayerName(fieldType);
            }
            return this.getTypeManager().getDisplayer(fieldType, fieldDisplayerName);
        }
        catch (FormException fe) {
            SilverLogger.getLogger((Object)this).error("getting a field displayer instance", (Throwable)((Object)fe));
            return null;
        }
    }

    protected String getJavascriptSnippet() {
        FieldTemplate fieldTemplate;
        if (!this.fieldTemplates.isEmpty() && StringUtil.isDefined((String)(fieldTemplate = this.fieldTemplates.get(0)).getTemplateName())) {
            return "<script type=\"text/javascript\" src=\"/weblib/xmlForms/" + fieldTemplate.getTemplateName() + ".js\"></script>\n";
        }
        return "";
    }

    @Override
    public String toString(PagesContext pageContext) {
        return this.toString(pageContext, this.getData());
    }

    protected String getSkippableSnippet(PagesContext pageContext) {
        if (!pageContext.isFormSkippable()) {
            return "";
        }
        Div div = new Div();
        div.setClass("buttonPanel");
        A a = new A();
        a.addElement(Util.getString("form.skip.label", pageContext.language));
        a.setHref("#");
        a.setClass("ignoreForm");
        a.setOnClick("ignoringForm('" + pageContext.getElementToHideWhenSkipping() + "');return false;");
        div.addElement((Element)a);
        Input input2 = new Input();
        input2.setType("hidden");
        input2.setName("ignoreThisForm");
        input2.setID("ignoreThisForm");
        return String.valueOf(div) + input2.toString();
    }

    private void printJavascriptSkippableSnippet(PrintWriter out) {
        out.append("var ignoreForm = false;\n").append("function ignoringForm(idToHide) {\n").append("ignoreForm = true;\n").append("$('#'+idToHide).hide();\n").append("$('#ignoreThisForm').val('true');\n").append("}\n");
    }

    private void printJavascriptIgnoreMandatorySnippet(PrintWriter out) {
        out.append("var ignoreMandatory = false;\n");
        out.append("function ifCorrectFormAndIgnoringMandatoryExecute(callback) {\n").append("ignoreMandatory = true;\n").append("ifCorrectFormExecute(callback);\n").append("}\n");
    }
}

