/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.webdav.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.RemoteContentDescriptor;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.webdav.WebdavRepository;
import org.silverpeas.core.contribution.attachment.webdav.impl.WebdavContentDescriptor;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.persistence.jcr.JcrDataConverter;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

@Repository
public class WebdavDocumentRepository
implements WebdavRepository {
    @Override
    public void createAttachmentNode(Session session, SimpleDocument attachment) throws RepositoryException, IOException {
        String lang;
        Node rootNode = session.getRootNode();
        Node attachmentFolder = this.addFolder(rootNode, "webdav");
        attachmentFolder = this.addFolder(attachmentFolder, DocumentType.attachment.getFolderName());
        Node contextFolder = this.addFolder(attachmentFolder, attachment.getInstanceId());
        if (attachment.getId() != null) {
            contextFolder = this.addFolder(contextFolder, attachment.getId());
        }
        if (!StringUtil.isDefined((String)(lang = attachment.getLanguage()))) {
            lang = I18NHelper.DEFAULT_LANGUAGE;
        }
        contextFolder = this.addExclusiveFolder(contextFolder, lang);
        this.addFile(contextFolder, attachment);
    }

    @Override
    public void updateNodeAttachment(Session session, SimpleDocument attachment) throws RepositoryException, IOException {
        Node rootNode = session.getRootNode();
        try {
            Node fileNode = rootNode.getNode(attachment.getWebdavJcrPath());
            this.setContent(fileNode, attachment);
        }
        catch (PathNotFoundException pex) {
            this.createAttachmentNode(session, attachment);
        }
    }

    @Override
    public void moveNodeAttachment(Session session, SimpleDocument attachment, String targetComponentInstanceId) throws RepositoryException {
        Node nodeToMove;
        if (attachment.getPk() != null && StringUtil.isDefined((String)targetComponentInstanceId) && !attachment.getInstanceId().equals(targetComponentInstanceId) && (nodeToMove = this.getDocumentIdentifierNode(session, attachment)) != null) {
            Node nodeToPurge = nodeToMove.getParent();
            Node rootNode = session.getRootNode();
            Node webdavNode = this.addFolder(rootNode, "webdav");
            Node documentTypeNode = this.addFolder(webdavNode, DocumentType.attachment.getFolderName());
            Node destinationNode = this.addFolder(documentTypeNode, targetComponentInstanceId);
            session.save();
            session.getWorkspace().move(nodeToMove.getPath(), destinationNode.getPath() + "/" + attachment.getId());
            this.purgeWebdavFromNode(nodeToPurge);
        }
    }

    protected Node getDocumentIdentifierNode(Session session, SimpleDocument attachment) throws RepositoryException {
        return this.getDocumentNode(session, attachment, null);
    }

    protected Node getDocumentContentLanguageNode(Session session, SimpleDocument attachment, String language) throws RepositoryException {
        Node documentContentLanguageNode = null;
        if (StringUtil.isDefined((String)language)) {
            documentContentLanguageNode = this.getDocumentNode(session, attachment, "/" + language);
        }
        return documentContentLanguageNode;
    }

    private Node getDocumentNode(Session session, SimpleDocument attachment, String suffixPathPattern) throws RepositoryException {
        if (StringUtil.isDefined((String)attachment.getId())) {
            Pattern pattern = Pattern.compile(".*/" + attachment.getId() + StringUtil.defaultStringIfNotDefined((String)suffixPathPattern, (String)""));
            Matcher matcher = pattern.matcher(attachment.getWebdavJcrPath());
            if (!matcher.find()) {
                return null;
            }
            String webdavPath = matcher.group();
            try {
                Node rootNode = session.getRootNode();
                return rootNode.getNode(webdavPath);
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void deleteAttachmentNode(Session session, SimpleDocument attachment) throws RepositoryException {
        Node rootNode = session.getRootNode();
        try {
            Node fileNode = this.getDocumentIdentifierNode(session, attachment);
            if (fileNode == null) {
                fileNode = rootNode.getNode(attachment.getWebdavJcrPath());
            }
            Node parentNode = fileNode.getParent();
            fileNode.remove();
            this.purgeWebdavFromNode(parentNode);
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void deleteAttachmentContentNode(Session session, SimpleDocument attachment, String language) throws RepositoryException {
        Node fileNode = this.getDocumentContentLanguageNode(session, attachment, language);
        if (fileNode != null) {
            Node parentNode = fileNode.getParent();
            fileNode.remove();
            this.purgeWebdavFromNode(parentNode);
        }
    }

    private void purgeWebdavFromNode(Node parentNodeOfDeletedOne) throws RepositoryException {
        Node currentNode = parentNodeOfDeletedOne;
        if (currentNode != null) {
            while (!currentNode.hasNodes() && !"webdav".equals(currentNode.getName())) {
                Node nodeToRemove = currentNode;
                currentNode = currentNode.getParent();
                nodeToRemove.remove();
            }
            if (!currentNode.hasNodes()) {
                currentNode.remove();
            }
        }
    }

    @Override
    public boolean isNodeLocked(Session session, SimpleDocument attachment) throws RepositoryException {
        return this.getDescriptor(session, attachment).map(RemoteContentDescriptor::isOfficeEditorLock).orElse(false);
    }

    @Override
    public boolean unlockLockedNode(Session session, SimpleDocument attachment) throws RepositoryException {
        Optional<Node> webdavNode;
        if (this.isNodeLocked(session, attachment) && (webdavNode = this.getWebdavNode(session, attachment).map(Pair::getFirst)).isPresent()) {
            webdavNode.get().removeMixin("{http://www.jcp.org/jcr/mix/1.0}lockable");
            session.save();
            webdavNode.get().addMixin("{http://www.jcp.org/jcr/mix/1.0}lockable");
            session.save();
            return this.isNodeLocked(session, attachment);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAttachmentBinaryContent(Session session, SimpleDocument attachment) throws RepositoryException, IOException {
        Node rootNode = session.getRootNode();
        Node webdavFileNode = rootNode.getNode(attachment.getWebdavJcrPath());
        Binary webdavBinary = webdavFileNode.getNode("{http://www.jcp.org/jcr/1.0}content").getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary();
        try (InputStream in = webdavBinary.getStream();
             FileOutputStream out = FileUtils.openOutputStream((File)new File(attachment.getAttachmentPath()));){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            webdavBinary.dispose();
        }
    }

    protected Node addFolder(Node parent, String name) throws RepositoryException {
        try {
            return parent.getNode(name);
        }
        catch (PathNotFoundException e) {
            return parent.addNode(name, "{http://www.jcp.org/jcr/nt/1.0}folder");
        }
    }

    protected Node addExclusiveFolder(Node parent, String name) throws RepositoryException {
        try {
            NodeIterator nodeIt = parent.getNodes();
            while (nodeIt.hasNext()) {
                Node currentNode = nodeIt.nextNode();
                if (currentNode.getName().equals(name)) continue;
                currentNode.remove();
            }
            return parent.getNode(name);
        }
        catch (PathNotFoundException e) {
            return parent.addNode(name, "{http://www.jcp.org/jcr/nt/1.0}folder");
        }
    }

    protected Node addFile(Node folder, SimpleDocument attachment) throws RepositoryException, IOException {
        NodeIterator fileNodeIt = folder.getNodes();
        while (fileNodeIt.hasNext()) {
            fileNodeIt.nextNode().remove();
        }
        String escapedName = JcrDataConverter.escapeIllegalJcrChars(attachment.getFilename());
        Node fileNode = folder.addNode(escapedName, "{http://www.jcp.org/jcr/nt/1.0}file");
        if (attachment.getEditedBy() != null) {
            fileNode.addMixin("slv:ownable");
            fileNode.setProperty("slv:owner", attachment.getEditedBy());
        }
        Node contentNode = fileNode.addNode("{http://www.jcp.org/jcr/1.0}content", "{http://www.jcp.org/jcr/nt/1.0}resource");
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", attachment.getContentType());
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}encoding", "");
        this.setContent(fileNode, attachment);
        return fileNode;
    }

    private void setContent(Node fileNode, SimpleDocument attachment) throws RepositoryException, IOException {
        try (FileInputStream in = FileUtils.openInputStream((File)new File(attachment.getAttachmentPath()));){
            this.setContent(fileNode, in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContent(Node fileNode, InputStream input2) throws RepositoryException {
        Binary attachmentBinary = fileNode.getSession().getValueFactory().createBinary(input2);
        try {
            Node contentNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content");
            contentNode.setProperty("{http://www.jcp.org/jcr/1.0}lastModified", Calendar.getInstance());
            contentNode.setProperty("{http://www.jcp.org/jcr/1.0}data", attachmentBinary);
        }
        finally {
            attachmentBinary.dispose();
        }
    }

    @Override
    public String getContentEditionLanguage(Session session, SimpleDocument attachment) throws RepositoryException {
        Pattern pattern;
        Matcher matcher;
        String contentEditionLanguage = null;
        if (StringUtil.isDefined((String)attachment.getId()) && (matcher = (pattern = Pattern.compile("(?i).*/" + attachment.getId() + "/")).matcher(attachment.getWebdavJcrPath())).find()) {
            Node rootNode = session.getRootNode();
            try {
                Node webdavNode = rootNode.getNode(matcher.group());
                NodeIterator webdavNodeIt = webdavNode.getNodes();
                Date creationDate = null;
                while (webdavNodeIt.hasNext()) {
                    Node currentLanguageNode = webdavNodeIt.nextNode();
                    Node currentFileNode = currentLanguageNode.getNodes().nextNode();
                    if (creationDate != null && !creationDate.before(currentFileNode.getProperty("{http://www.jcp.org/jcr/1.0}created").getDate().getTime())) continue;
                    creationDate = currentFileNode.getProperty("{http://www.jcp.org/jcr/1.0}created").getDate().getTime();
                    contentEditionLanguage = currentLanguageNode.getName();
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
        return contentEditionLanguage;
    }

    @Override
    public long getContentEditionSize(Session session, SimpleDocument attachment) throws RepositoryException {
        Long size = this.getWebdavFileValue(session, attachment, n -> n.getNode("{http://www.jcp.org/jcr/1.0}content").getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary().getSize());
        return size != null ? size : -1L;
    }

    @Override
    public Optional<WebdavContentDescriptor> getDescriptor(Session session, SimpleDocument attachment) throws RepositoryException {
        Optional<Pair<Node, String>> webdavFileNode = this.getWebdavNode(session, attachment);
        if (webdavFileNode.isPresent()) {
            Node fileNode = (Node)webdavFileNode.get().getFirst();
            Node contentNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content");
            WebdavContentDescriptor descriptor = new WebdavContentDescriptor(attachment);
            String identifier = contentNode.getIdentifier();
            String language = (String)webdavFileNode.get().getSecond();
            long size = contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary().getSize();
            Date time = contentNode.getProperty("{http://www.jcp.org/jcr/1.0}lastModified").getDate().getTime();
            descriptor.set(identifier, language, size, OffsetDateTime.ofInstant(time.toInstant(), ZoneId.systemDefault()), fileNode.isLocked());
            return Optional.of(descriptor);
        }
        return Optional.empty();
    }

    @Override
    public void updateContentFrom(Session session, SimpleDocument document, InputStream input2) throws RepositoryException {
        Optional<Pair<Node, String>> webdavFileNode = this.getWebdavNode(session, document);
        if (webdavFileNode.isPresent()) {
            this.setContent((Node)webdavFileNode.get().getFirst(), input2);
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadContentInto(Session session, SimpleDocument document, OutputStream output) throws RepositoryException, IOException {
        Optional<Pair<Node, String>> webdavFileNode = this.getWebdavNode(session, document);
        if (webdavFileNode.isPresent()) {
            Node contentNode = ((Node)webdavFileNode.get().getFirst()).getNode("{http://www.jcp.org/jcr/1.0}content");
            Binary binary = contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary();
            try (InputStream input2 = binary.getStream();){
                IOUtils.copy((InputStream)input2, (OutputStream)output);
            }
            finally {
                binary.dispose();
            }
        }
    }

    private <T> T getWebdavFileValue(Session session, SimpleDocument attachment, WebdavFunction<Node, T> provider) throws RepositoryException {
        Optional<Pair<Node, String>> webdavFileNode = this.getWebdavNode(session, attachment);
        if (webdavFileNode.isPresent()) {
            return provider.apply((Node)webdavFileNode.get().getFirst());
        }
        return null;
    }

    private Optional<Pair<Node, String>> getWebdavNode(Session session, SimpleDocument attachment) throws RepositoryException {
        String currentLanguage = attachment.getLanguage();
        String webDavJcrPath = attachment.getWebdavJcrPath().replaceFirst("/[^/]+$", "");
        String languageInWebDav = this.getContentEditionLanguage(session, attachment);
        if (languageInWebDav != null) {
            if (!currentLanguage.equals(languageInWebDav)) {
                String before = attachment.getId() + "/" + currentLanguage;
                String after = attachment.getId() + "/" + languageInWebDav;
                webDavJcrPath = webDavJcrPath.replace(before, after);
            }
            try {
                Node fileNode = session.getRootNode().getNode(webDavJcrPath).getNodes().nextNode();
                return Optional.of(Pair.of((Object)fileNode, (Object)languageInWebDav));
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @FunctionalInterface
    private static interface WebdavFunction<T, R> {
        public R apply(T var1) throws RepositoryException;
    }
}

