/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.model;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.attachment.AttachmentService;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.CoreContributionType;
import org.silverpeas.core.contribution.model.I18nContribution;
import org.silverpeas.core.contribution.model.LocalizedAttachment;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.kernel.exception.NotFoundException;
import org.silverpeas.kernel.util.StringUtil;

public class Document
implements I18nContribution,
LocalizedAttachment {
    private final ContributionIdentifier id;
    private final SimpleDocument master;

    public Document(ContributionIdentifier id) {
        this.id = id;
        this.master = this.selectTranslation(null);
    }

    public Document(SimpleDocument master) {
        this.id = master.getIdentifier();
        this.master = master;
    }

    public ContributionIdentifier getIdentifier() {
        return this.id;
    }

    public ContributionIdentifier getSourceContribution() {
        SimpleDocument document = this.getMasterDocument();
        return ContributionIdentifier.from((String)document.getInstanceId(), (String)document.getForeignId(), (CoreContributionType)CoreContributionType.UNKNOWN);
    }

    public String getTitle() {
        return this.getMasterDocument().getTitle();
    }

    public String getContentType() {
        return this.getMasterDocument().getContentType();
    }

    public String getDisplayIcon() {
        return this.getMasterDocument().getDisplayIcon();
    }

    public String getFilename() {
        return this.getMasterDocument().getFilename();
    }

    public long getSize() {
        return this.getMasterDocument().getSize();
    }

    public String getAttachmentPath() {
        return this.getMasterDocument().getAttachmentPath();
    }

    public boolean isVersioned() {
        return this.getMasterDocument().isVersioned();
    }

    public int getMinorVersion() {
        return this.getMasterDocument().getMinorVersion();
    }

    public int getMajorVersion() {
        return this.getMasterDocument().getMajorVersion();
    }

    public SimpleDocument getTranslation(String language) {
        SimpleDocument translation = this.getMasterDocument().getLanguage().equals(language) ? this.master : this.selectTranslation(language);
        return translation == null ? this.master : translation;
    }

    public List<SimpleDocument> getAllTranslations() {
        AttachmentService service = AttachmentService.get();
        SimpleDocumentPK pk = new SimpleDocumentPK(this.id.getLocalId(), this.id.getComponentInstanceId());
        return I18NHelper.getLanguages().stream().map(l -> service.searchDocumentById(pk, (String)l)).collect(Collectors.toList());
    }

    public Date getCreationDate() {
        return this.getMasterDocument().getCreationDate();
    }

    public Date getLastUpdateDate() {
        return this.getMasterDocument().getLastUpdateDate();
    }

    public User getCreator() {
        return this.getMasterDocument().getCreator();
    }

    public User getLastUpdater() {
        return this.getMasterDocument().getLastUpdater();
    }

    private SimpleDocument getMasterDocument() {
        return this.master;
    }

    private SimpleDocument selectTranslation(String language) {
        SimpleDocumentPK pk;
        String lang = StringUtil.isDefined((String)language) ? language : I18NHelper.DEFAULT_LANGUAGE;
        AttachmentService service = AttachmentService.get();
        SimpleDocument document = service.searchDocumentById(pk = new SimpleDocumentPK(this.id.getLocalId(), this.id.getComponentInstanceId()), lang);
        if (document == null) {
            return I18NHelper.getLanguages().stream().map(l -> service.searchDocumentById(pk, (String)l)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new NotFoundException("No such document " + this.id.asString() + " in whatever language"));
        }
        return document;
    }

    public boolean isReadOnly() {
        return this.getMasterDocument().isReadOnly();
    }

    public boolean isEdited() {
        return this.getMasterDocument().isEdited();
    }

    public boolean isEditedBy(User user) {
        return this.getMasterDocument().isEditedBy(user);
    }

    public boolean isSharingAllowedForRolesFrom(User user) {
        return this.getMasterDocument().isSharingAllowedForRolesFrom(user);
    }

    public boolean canBeAccessedBy(User user) {
        return this.getMasterDocument().canBeAccessedBy(user);
    }

    public boolean canBeModifiedBy(User user) {
        return this.getMasterDocument().canBeModifiedBy(user);
    }

    public boolean isDownloadAllowedForRolesFrom(User user) {
        return this.getMasterDocument().isDownloadAllowedForRolesFrom(user);
    }

    public boolean isDownloadAllowedForRoles(Set<SilverpeasRole> roles) {
        return this.getMasterDocument().isDownloadAllowedForRoles(roles);
    }

    public boolean isDownloadAllowedForReaders() {
        return this.getMasterDocument().isDownloadAllowedForReaders();
    }
}

