/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.model;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.Collator;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.domain.model.DomainProperties;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserReference;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.persistence.EntityReference;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.personalization.service.PersonalizationServiceProvider;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.session.SessionManagement;
import org.silverpeas.core.security.session.SessionManagementProvider;
import org.silverpeas.core.security.token.exception.TokenException;
import org.silverpeas.core.security.token.exception.TokenRuntimeException;
import org.silverpeas.core.security.token.persistent.PersistentResourceToken;
import org.silverpeas.core.socialnetwork.invitation.Invitation;
import org.silverpeas.core.socialnetwork.invitation.InvitationService;
import org.silverpeas.core.socialnetwork.relationship.RelationShipService;
import org.silverpeas.core.socialnetwork.status.StatusService;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.comparator.AbstractComplexComparator;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class UserDetail
implements User {
    public static final String BLANK_NAME = "_Anonymous_";
    public static final String SYSTEM_USER_ID = "-1";
    public static final String USER_COMPONENT = "users";
    private static final long serialVersionUID = -109886153681824159L;
    private static final String ANONYMOUS_ID_PROPERTY = "anonymousId";
    private static final String DEFAULT_AVATAR_PROPERTY = "login";
    private static final String AVATAR_PROPERTY = ResourceLocator.getGeneralSettingBundle().getString("avatar.property", "login");
    private static final String AVATAR_EXTENSION = ResourceLocator.getGeneralSettingBundle().getString("avatar.extension", "jpg");
    private static final String AVATAR_BASE_URI = "/display/avatar/";
    private static final SettingBundle generalSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.lookAndFeel.generalLook");
    private String id = null;
    private String specificId = null;
    private String domainId = null;
    private String login = null;
    private String firstName = "";
    private String lastName = "";
    private String eMail = "";
    private UserAccessLevel accessLevel = UserAccessLevel.from(null);
    private String loginQuestion = "";
    private String loginAnswer = "";
    private Date creationDate = null;
    private Date saveDate = null;
    private int version = 0;
    private Date tosAcceptanceDate = null;
    private Date lastLoginDate = null;
    private int nbSuccessfulLoginAttempts = 0;
    private Date lastLoginCredentialUpdateDate = null;
    private Date expirationDate = null;
    private UserState state = UserState.from(null);
    private Date stateSaveDate = null;
    private Integer notifManualReceiverLimit;
    private UserPreferences preferences = null;
    private boolean sensitiveData;

    public static UserDetail from(User user) {
        return (UserDetail)user;
    }

    public static UserDetail getById(String userId) {
        return (UserDetail)User.getById((String)userId);
    }

    public static UserDetail getCurrentRequester() {
        return (UserDetail)User.getCurrentRequester();
    }

    public static UserDetail getSystemUser() {
        return (UserDetail)User.getSystemUser();
    }

    public static List<UserDetail> getAll() {
        return Arrays.asList((UserDetail[])UserDetail.getOrganisationController().getAllUsers());
    }

    public UserDetail() {
    }

    public UserDetail(UserDetail otherUser) {
        this.id = otherUser.getId();
        this.specificId = otherUser.getSpecificId();
        this.domainId = otherUser.getDomainId();
        this.login = otherUser.getLogin();
        this.firstName = otherUser.getFirstName();
        this.lastName = otherUser.getLastName();
        this.eMail = otherUser.getEmailAddress();
        this.accessLevel = otherUser.getAccessLevel();
        this.loginQuestion = otherUser.getLoginQuestion();
        this.loginAnswer = otherUser.getLoginAnswer();
        this.creationDate = otherUser.getCreationDate();
        this.saveDate = otherUser.getSaveDate();
        this.version = otherUser.getVersion();
        this.tosAcceptanceDate = otherUser.getTosAcceptanceDate();
        this.lastLoginDate = otherUser.getLastLoginDate();
        this.nbSuccessfulLoginAttempts = otherUser.getNbSuccessfulLoginAttempts();
        this.lastLoginCredentialUpdateDate = otherUser.getLastLoginCredentialUpdateDate();
        this.expirationDate = otherUser.getExpirationDate();
        this.state = otherUser.getState();
        this.stateSaveDate = otherUser.getStateSaveDate();
        this.notifManualReceiverLimit = otherUser.getNotifManualReceiverLimit();
        this.sensitiveData = otherUser.hasSensitiveData();
        this.preferences = otherUser.preferences;
    }

    public boolean hasSensitiveData() {
        return this.sensitiveData;
    }

    public void setSensitiveData(boolean sensitive) {
        this.sensitiveData = sensitive;
    }

    public String getLoginQuestion() {
        return this.loginQuestion;
    }

    public void setLoginQuestion(String loginQuestion) {
        this.loginQuestion = loginQuestion;
    }

    public String getLoginAnswer() {
        return this.loginAnswer;
    }

    public void setLoginAnswer(String loginAnswer) {
        this.loginAnswer = loginAnswer;
    }

    public Date getTosAcceptanceDate() {
        return this.tosAcceptanceDate;
    }

    public void setTosAcceptanceDate(Date tosAcceptanceDate) {
        this.tosAcceptanceDate = tosAcceptanceDate;
    }

    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    public int getNbSuccessfulLoginAttempts() {
        return this.nbSuccessfulLoginAttempts;
    }

    public void setNbSuccessfulLoginAttempts(int nbSuccessfulLoginAttempts) {
        this.nbSuccessfulLoginAttempts = nbSuccessfulLoginAttempts;
    }

    public Date getLastLoginCredentialUpdateDate() {
        return this.lastLoginCredentialUpdateDate;
    }

    public void setLastLoginCredentialUpdateDate(Date lastLoginCredentialUpdateDate) {
        this.lastLoginCredentialUpdateDate = lastLoginCredentialUpdateDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public UserState getState() {
        return this.state;
    }

    public void setState(UserState state) {
        this.state = state != null ? state : UserState.from(null);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getSaveDate() {
        return this.saveDate;
    }

    public void setSaveDate(Date saveDate) {
        this.saveDate = saveDate;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Date getStateSaveDate() {
        return this.stateSaveDate;
    }

    public void setStateSaveDate(Date stateSaveDate) {
        this.stateSaveDate = stateSaveDate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSpecificId() {
        return this.specificId;
    }

    public void setSpecificId(String specificId) {
        this.specificId = specificId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = Objects.requireNonNullElse(login, "");
    }

    public String getFirstName() {
        String result = this.firstName;
        if (BLANK_NAME.equals(this.firstName)) {
            User user = User.getCurrentRequester();
            String language = user != null ? user.getUserPreferences().getLanguage() : DisplayI18NHelper.getDefaultLanguage();
            LocalizationBundle generalBundle = ResourceLocator.getGeneralLocalizationBundle((String)language);
            result = generalBundle.getString("GML.Anonymous");
        }
        return result;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName != null ? firstName.trim() : "";
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String sLastName) {
        this.lastName = sLastName != null ? sLastName.trim() : "";
    }

    public void setEmailAddress(String emailAddress) {
        this.eMail = Objects.requireNonNullElse(emailAddress, "");
    }

    public String getEmailAddress() {
        return this.eMail;
    }

    public UserAccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public void setAccessLevel(UserAccessLevel accessLevel) {
        this.accessLevel = Objects.requireNonNullElse(accessLevel, UserAccessLevel.USER);
    }

    public Domain getDomain() {
        return UserDetail.getOrganisationController().getDomain(this.getDomainId());
    }

    public boolean isDomainRestricted() {
        return (DomainProperties.areDomainsNonVisibleToOthers() || DomainProperties.areDomainsVisibleOnlyToDefaultOne() && !DomainProperties.isDefaultDomain(this.getDomainId())) && !this.isAccessAdmin();
    }

    public boolean isDomainAdminRestricted() {
        return !DomainProperties.areDomainsVisibleToAll() && !this.isAccessAdmin() && (!DomainProperties.areDomainsVisibleOnlyToDefaultOne() || !DomainProperties.isDefaultDomain(this.getDomainId()));
    }

    public boolean isBackOfficeVisible() {
        return this.isAccessPdcManager() || this.isAccessAdmin() || this.isAccessDomainManager();
    }

    public boolean isAccessAdmin() {
        return UserAccessLevel.ADMINISTRATOR.equals((Object)this.accessLevel);
    }

    public boolean isAccessDomainManager() {
        return UserAccessLevel.DOMAIN_ADMINISTRATOR.equals((Object)this.accessLevel);
    }

    public boolean isAccessPdcManager() {
        return UserAccessLevel.PDC_MANAGER.equals((Object)this.accessLevel);
    }

    public boolean isAccessUser() {
        return UserAccessLevel.USER.equals((Object)this.accessLevel);
    }

    public boolean isAccessGuest() {
        return UserAccessLevel.GUEST.equals((Object)this.accessLevel);
    }

    public boolean isAccessUnknown() {
        return UserAccessLevel.UNKNOWN.equals((Object)this.accessLevel);
    }

    public boolean isPlayingAdminRole(String instanceId) {
        if (this.isAccessAdmin()) {
            return true;
        }
        Set roles = ComponentAccessControl.get().getUserRoles(this.getId(), (Object)instanceId, AccessControlContext.init());
        return roles.contains(SilverpeasRole.ADMIN);
    }

    public boolean isActivatedState() {
        return !this.isAnonymous() && !this.isDeletedState() && !this.isRemovedState() && !this.isDeactivatedState();
    }

    public boolean isValidState() {
        return this.isAnonymous() || !UserState.UNKNOWN.equals((Object)this.state) && !this.isDeletedState() && !this.isRemovedState() && !this.isBlockedState() && !this.isDeactivatedState() && !this.isExpiredState();
    }

    public boolean isDeletedState() {
        return UserState.DELETED.equals((Object)this.state);
    }

    public boolean isRemovedState() {
        return UserState.REMOVED.equals((Object)this.state);
    }

    public boolean isBlockedState() {
        return UserState.BLOCKED.equals((Object)this.state);
    }

    public boolean isDeactivatedState() {
        return UserState.DEACTIVATED.equals((Object)this.state);
    }

    public boolean isExpiredState() {
        return UserState.EXPIRED.equals((Object)this.state) || this.getExpirationDate() != null && this.getExpirationDate().compareTo(DateUtil.getDate()) < 0;
    }

    public boolean isSystem() {
        return this.getId().equals(SYSTEM_USER_ID);
    }

    public boolean isAnonymous() {
        return this.getId() != null && UserDetail.isAnonymousUser(this.getId());
    }

    public boolean isBlanked() {
        return this.isDeletedState() && this.firstName.equals(BLANK_NAME);
    }

    public static UserDetail getAnonymousUser() {
        UserDetail anonymousUser = null;
        if (UserDetail.isAnonymousUserExist()) {
            anonymousUser = (UserDetail)OrganizationControllerProvider.getOrganisationController().getUserDetail(UserDetail.getAnonymousUserId());
        }
        return anonymousUser;
    }

    public String getToken() {
        try {
            UserReference ref = UserReference.fromUser((User)this);
            return PersistentResourceToken.getOrCreateToken((EntityReference)ref).getValue();
        }
        catch (TokenException e) {
            throw new TokenRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof UserDetail) {
            UserDetail cmpUser = (UserDetail)other;
            return Objects.equals(this.id, cmpUser.getId()) && Objects.equals(this.specificId, cmpUser.getSpecificId()) && Objects.equals(this.domainId, cmpUser.getDomainId()) && Objects.equals(this.login, cmpUser.getLogin()) && Objects.equals(this.firstName, cmpUser.getFirstName()) && Objects.equals(this.lastName, cmpUser.getLastName()) && Objects.equals(this.eMail, cmpUser.getEmailAddress()) && Objects.equals(this.accessLevel, cmpUser.getAccessLevel());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.specificId, this.domainId, this.login, this.firstName, this.lastName, this.eMail, this.accessLevel);
    }

    public void traceUser() {
        SilverLogger.getLogger((Object)this).info("User data:\nspecificId = {0}\ndomainId = {1}\nfirstName = {2}\nlastName = {3}", new Object[]{this.specificId, this.domainId, this.firstName, this.lastName});
    }

    public int compareTo(User other) {
        String otherFirstName;
        String myFirstName;
        String otherLastName;
        String myLastName;
        Collator collator = Collator.getInstance();
        int result = collator.compare(myLastName = this.getLastName().toLowerCase(I18NHelper.defaultLocale), otherLastName = other.getLastName().toLowerCase(I18NHelper.defaultLocale));
        if (result == 0 && (result = collator.compare(myFirstName = this.getFirstName().toLowerCase(I18NHelper.defaultLocale), otherFirstName = other.getFirstName().toLowerCase(I18NHelper.defaultLocale))) == 0) {
            String myId = this.getId();
            String otherId = other.getId();
            result = myId.compareTo(otherId);
        }
        return result;
    }

    public String getAvatar() {
        File avatar = this.getAvatarFile();
        if (avatar.exists() && avatar.isFile()) {
            return AVATAR_BASE_URI + avatar.getName();
        }
        return "/directory/jsp/icons/avatar.png";
    }

    public String getSmallAvatar() {
        String avatar = this.getAvatar();
        if (avatar.startsWith(AVATAR_BASE_URI)) {
            return FileServerUtils.getImageURL(avatar, "image.size.avatar.profil");
        }
        return avatar;
    }

    public boolean isAvatarDefined() {
        return this.getAvatarFile().exists();
    }

    public String getAvatarFileName() {
        String propertyValue = this.getLogin();
        if (!AVATAR_PROPERTY.equals(DEFAULT_AVATAR_PROPERTY)) {
            try {
                String getterName = "get" + Character.toUpperCase(AVATAR_PROPERTY.charAt(0)) + AVATAR_PROPERTY.substring(1);
                Method getter = this.getClass().getMethod(getterName, new Class[0]);
                propertyValue = getter.invoke((Object)this, new Object[0]).toString();
                if (!StringUtil.isDefined((String)propertyValue)) {
                    propertyValue = this.getLogin();
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                SilverLogger.getLogger((Object)this).silent((Throwable)e);
            }
        }
        return propertyValue + "." + AVATAR_EXTENSION;
    }

    private File getAvatarFile() {
        return new File(FileRepositoryManager.getAvatarPath(), this.getAvatarFileName());
    }

    public String getStatus() {
        StatusService statusService = (StatusService)ServiceProvider.getService(StatusService.class, (Annotation[])new Annotation[0]);
        String status = statusService.getLastStatus(Integer.parseInt(this.getId())).getDescription();
        if (StringUtil.isDefined((String)status)) {
            return status;
        }
        return "";
    }

    public UserPreferences getUserPreferences() {
        if (this.preferences == null) {
            this.preferences = PersonalizationServiceProvider.getPersonalizationService().getUserSettings(this.getId());
        }
        return this.preferences;
    }

    public boolean isInRelationWith(String userId) {
        RelationShipService relation = RelationShipService.get();
        try {
            return relation.isInRelationShip(Integer.parseInt(userId), Integer.parseInt(this.getId()));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            return false;
        }
    }

    public Invitation getInvitationSentTo(String userId) {
        return this.getInvitation(this.getId(), userId);
    }

    public Invitation getInvitationReceivedFrom(String userId) {
        return this.getInvitation(userId, this.getId());
    }

    private Invitation getInvitation(String fromUserId, String toUserId) {
        InvitationService invitationService = InvitationService.get();
        Invitation invitation = null;
        try {
            invitation = invitationService.getInvitation(Integer.parseInt(fromUserId), Integer.parseInt(toUserId));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        return invitation;
    }

    public boolean isConnected() {
        SessionManagement sessionManagement = SessionManagementProvider.getSessionManagement();
        return sessionManagement.isUserConnected(this);
    }

    public static boolean isAnonymousUserExist() {
        return StringUtil.isDefined((String)UserDetail.getAnonymousUserId());
    }

    public static boolean isAnonymousUser(String userId) {
        return UserDetail.isAnonymousUserExist() && UserDetail.getAnonymousUserId().equals(userId);
    }

    public boolean isFullyDefined() {
        return StringUtil.isDefined((String)this.getId()) && StringUtil.isDefined((String)this.getLogin()) && StringUtil.isDefined((String)this.getLastName());
    }

    public String getDisplayedName() {
        return super.getDisplayedName();
    }

    public long getDurationOfCurrentSession() {
        if (this.isConnected()) {
            return new Date().getTime() - this.getLastLoginDate().getTime();
        }
        return 0L;
    }

    public boolean isUserManualNotificationUserReceiverLimit() {
        return this.getUserManualNotificationUserReceiverLimitValue() > 0;
    }

    public int getUserManualNotificationUserReceiverLimitValue() {
        int limit = 0;
        if (NotificationManagerSettings.isUserManualNotificationRecipientLimitEnabled() && (this.isAccessUser() || this.isAccessGuest() || this.isAnonymous() || this.isAccessUnknown())) {
            limit = !this.isAnonymous() && !this.isAccessUnknown() && this.getNotifManualReceiverLimit() != null ? this.getNotifManualReceiverLimit() : NotificationManagerSettings.getUserManualNotificationRecipientLimit();
        }
        return limit;
    }

    public void setUserManualNotificationUserReceiverLimit(Integer limit) {
        if (NotificationManagerSettings.isUserManualNotificationRecipientLimitEnabled() && (this.isAccessUser() || this.isAccessGuest())) {
            if (limit != null && (limit <= -1 || limit == NotificationManagerSettings.getUserManualNotificationRecipientLimit())) {
                limit = null;
            }
            this.setNotifManualReceiverLimit(limit);
        }
    }

    public void setNotifManualReceiverLimit(Integer notifManualReceiverLimit) {
        this.notifManualReceiverLimit = notifManualReceiverLimit;
    }

    public Integer getNotifManualReceiverLimit() {
        return this.notifManualReceiverLimit;
    }

    protected static String getAnonymousUserId() {
        return generalSettings.getString(ANONYMOUS_ID_PROPERTY, null);
    }

    protected static OrganizationController getOrganisationController() {
        return OrganizationControllerProvider.getOrganisationController();
    }

    public static class OnCreationDate
    extends AbstractComplexComparator<User> {
        @Override
        protected AbstractComplexComparator.ValueBuffer getValuesToCompare(User user) {
            long creationDateTime = 0L;
            if (user.getCreationDate() != null) {
                creationDateTime = user.getCreationDate().getTime();
            }
            return new AbstractComplexComparator.ValueBuffer().append(creationDateTime);
        }
    }

    public static class OnFirstNameAndLastName
    extends AbstractComplexComparator<UserDetail> {
        @Override
        protected AbstractComplexComparator.ValueBuffer getValuesToCompare(UserDetail user) {
            return new AbstractComplexComparator.ValueBuffer().append(user.getLastName()).append(user.getFirstName());
        }
    }
}

