/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.space;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.silverpeas.core.BasicIdentifier;
import org.silverpeas.core.Identifiable;
import org.silverpeas.core.admin.persistence.SpaceRow;
import org.silverpeas.core.admin.space.SpaceI18N;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.model.SpacePath;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.i18n.AbstractI18NBean;
import org.silverpeas.core.i18n.LocalizedResource;
import org.silverpeas.core.security.Securable;
import org.silverpeas.core.security.authorization.SpaceAccessControl;
import org.silverpeas.kernel.bundle.ResourceLocator;

public class SpaceInstLight
extends AbstractI18NBean<SpaceI18N>
implements Serializable,
LocalizedResource,
Identifiable,
Securable,
Comparable<SpaceInstLight> {
    private static final long serialVersionUID = 8772050454345960478L;
    private String id = null;
    private int orderNum = 0;
    private int level = -1;
    private String fatherId = null;
    private Date createDate = null;
    private Date updateDate = null;
    private Date removeDate = null;
    private String status = null;
    private int createdBy = -1;
    private int updatedBy = -1;
    private int removedBy = -1;
    private String creatorName = null;
    private String updaterName = null;
    private String removerName = null;
    private String look = null;
    private boolean displaySpaceFirst = true;
    private boolean isPersonalSpace = false;
    private boolean inheritanceBlocked = false;

    @Override
    protected Class<SpaceI18N> getTranslationType() {
        return SpaceI18N.class;
    }

    public SpaceInstLight() {
        this.id = "";
        this.fatherId = "";
        this.orderNum = 0;
        this.level = -1;
        this.displaySpaceFirst = true;
        this.isPersonalSpace = false;
        this.inheritanceBlocked = false;
    }

    public SpaceInstLight(SpaceRow spaceRow) {
        if (spaceRow != null) {
            this.setLocalId(spaceRow.id);
            this.setName(spaceRow.name);
            this.setFatherId(spaceRow.domainFatherId);
            this.setDescription(spaceRow.description);
            this.orderNum = spaceRow.orderNum;
            if (spaceRow.createTime != null) {
                this.createDate = new Date(Long.parseLong(spaceRow.createTime));
            }
            if (spaceRow.updateTime != null) {
                this.updateDate = new Date(Long.parseLong(spaceRow.updateTime));
            }
            if (spaceRow.removeTime != null) {
                this.removeDate = new Date(Long.parseLong(spaceRow.removeTime));
            }
            this.status = spaceRow.status;
            this.createdBy = spaceRow.createdBy;
            this.updatedBy = spaceRow.updatedBy;
            this.removedBy = spaceRow.removedBy;
            this.look = spaceRow.look;
            this.displaySpaceFirst = spaceRow.displaySpaceFirst == 1;
            this.isPersonalSpace = spaceRow.isPersonalSpace == 1;
            this.inheritanceBlocked = spaceRow.inheritanceBlocked == 1;
        }
    }

    public SpaceInstLight(SpaceInst spaceInst) {
        if (spaceInst != null) {
            this.setLocalId(spaceInst.getLocalId());
            this.setName(spaceInst.getName());
            this.setFatherId(spaceInst.getDomainFatherId());
            this.setDescription(spaceInst.getDescription());
            this.orderNum = spaceInst.getOrderNum();
            this.setLevel(spaceInst.getLevel());
            this.createDate = spaceInst.getCreationDate();
            this.updateDate = spaceInst.getLastUpdateDate();
            this.removeDate = spaceInst.getRemovalDate();
            this.status = spaceInst.getStatus();
            this.look = spaceInst.getLook();
            this.setTranslations(spaceInst.getTranslations());
            this.displaySpaceFirst = spaceInst.isDisplaySpaceFirst();
            this.isPersonalSpace = spaceInst.isPersonalSpace();
            this.inheritanceBlocked = spaceInst.isInheritanceBlocked();
        }
    }

    public String getId() {
        return "WA" + this.getLocalId();
    }

    public BasicIdentifier getIdentifier() {
        return new BasicIdentifier(this.getLocalId(), this.getId());
    }

    public String getFatherId() {
        return this.fatherId;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public String getName(String language) {
        if (this.isPersonalSpace) {
            return ResourceLocator.getGeneralLocalizationBundle((String)language).getString("GML.personalSpace");
        }
        return super.getName(language);
    }

    public void setFatherId(int fatherId) {
        this.fatherId = Integer.toString(fatherId);
    }

    public void setFatherId(String fatherId) {
        this.fatherId = fatherId;
    }

    public void setLocalId(int id) {
        this.id = Integer.toString(id);
    }

    public int getLocalId() {
        return Integer.parseInt(this.id);
    }

    public void setLevel(int i) {
        this.level = i;
    }

    public boolean isRoot() {
        return SpaceInstLight.isRoot(this.getFatherId());
    }

    public static boolean isRoot(String spaceId) {
        return "0".equals(spaceId);
    }

    public int getOrderNum() {
        return this.orderNum;
    }

    public void setOrderNum(int orderNum) {
        this.orderNum = orderNum;
    }

    public Date getCreationDate() {
        return this.createDate;
    }

    public Date getRemovalDate() {
        return this.removeDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getLastUpdateDate() {
        return this.updateDate;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getRemoverName() {
        return this.removerName;
    }

    public void setRemoverName(String removerName) {
        this.removerName = removerName;
    }

    public String getUpdaterName() {
        return this.updaterName;
    }

    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    public int getCreatedBy() {
        return this.createdBy;
    }

    public int getRemovedBy() {
        return this.removedBy;
    }

    public int getUpdatedBy() {
        return this.updatedBy;
    }

    public User getCreator() {
        return User.getById((String)String.valueOf(this.getCreatedBy()));
    }

    public User getLastUpdater() {
        if (this.updatedBy < 0) {
            return this.getCreator();
        }
        return User.getById((String)String.valueOf(this.getUpdatedBy()));
    }

    @Override
    public int compareTo(SpaceInstLight o) {
        return this.getOrderNum() - o.getOrderNum();
    }

    public String getPath(String separator) {
        String myPath;
        if (this.isRoot()) {
            myPath = "";
        } else {
            SpacePath spacePath = SpacePath.getPath(this.getFatherId());
            myPath = spacePath.format(this.getLanguage(), true, separator);
        }
        return myPath;
    }

    public String getLook() {
        return this.look;
    }

    public void setLook(String look) {
        this.look = look;
    }

    public boolean isDisplaySpaceFirst() {
        return this.displaySpaceFirst;
    }

    public void setDisplaySpaceFirst(boolean displaySpaceFirst) {
        this.displaySpaceFirst = displaySpaceFirst;
    }

    public boolean isPersonalSpace() {
        return this.isPersonalSpace;
    }

    public void setPersonalSpace(boolean isPersonalSpace) {
        this.isPersonalSpace = isPersonalSpace;
    }

    public boolean isInheritanceBlocked() {
        return this.inheritanceBlocked;
    }

    public void setInheritanceBlocked(boolean isInheritanceBlocked) {
        this.inheritanceBlocked = isInheritanceBlocked;
    }

    public boolean isRemoved() {
        return "R".equals(this.getStatus());
    }

    public boolean canBeAccessedBy(User user) {
        return SpaceAccessControl.get().isUserAuthorized(user.getId(), (Object)this.getId());
    }

    public boolean canBeModifiedBy(User user) {
        return SpaceAccessControl.get().hasUserSpaceManagementAuthorization(user.getId(), this.getId());
    }

    public boolean canBeFiledInBy(User user) {
        return this.canBeModifiedBy(user);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpaceInstLight other = (SpaceInstLight)obj;
        return Objects.equals(this.getId(), other.getId());
    }
}

