/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import org.silverpeas.kernel.util.StringUtil;

public class RightAssignationContext {
    private MODE mode = MODE.COPY;
    private String sourceId;
    private RESOURCE_TYPE sourceType;
    private String targetId;
    private RESOURCE_TYPE targetType;
    private boolean assignObjectRights = true;
    private String author = null;

    public static RightAssignationContext copy() {
        RightAssignationContext instance = new RightAssignationContext();
        instance.setMode(MODE.COPY);
        return instance;
    }

    public static RightAssignationContext replace() {
        RightAssignationContext instance = new RightAssignationContext();
        instance.setMode(MODE.REPLACE);
        return instance;
    }

    private RightAssignationContext() {
    }

    public void verifySourceAndTargetAreDefined() {
        if (StringUtil.isNotDefined((String)this.sourceId) || StringUtil.isNotDefined((String)this.targetId)) {
            throw new IllegalArgumentException("source or target is not defined");
        }
    }

    public boolean areSourceAndTargetEqual() {
        this.verifySourceAndTargetAreDefined();
        String sourceVerify = this.sourceId + "@" + String.valueOf((Object)this.sourceType);
        String targetVerify = this.targetId + "@" + String.valueOf((Object)this.targetType);
        return sourceVerify.equals(targetVerify);
    }

    private void setMode(MODE mode) {
        this.mode = mode;
    }

    public RightAssignationContext fromUserId(String userId) {
        this.setSourceId(userId, RESOURCE_TYPE.USER);
        return this;
    }

    public RightAssignationContext fromGroupId(String groupId) {
        this.setSourceId(groupId, RESOURCE_TYPE.GROUP);
        return this;
    }

    private void setSourceId(String sourceId, RESOURCE_TYPE sourceType) {
        this.sourceId = sourceId;
        this.sourceType = sourceType;
    }

    public RightAssignationContext toUserId(String userId) {
        this.setTargetId(userId, RESOURCE_TYPE.USER);
        return this;
    }

    public RightAssignationContext toGroupId(String groupId) {
        this.setTargetId(groupId, RESOURCE_TYPE.GROUP);
        return this;
    }

    private void setTargetId(String targetId, RESOURCE_TYPE targetType) {
        this.targetId = targetId;
        this.targetType = targetType;
    }

    public RightAssignationContext withoutAssigningComponentObjectRights() {
        this.assignObjectRights = false;
        return this;
    }

    public RightAssignationContext setAuthor(String author) {
        this.author = author;
        return this;
    }

    public MODE getMode() {
        return this.mode;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public RESOURCE_TYPE getSourceType() {
        return this.sourceType;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public RESOURCE_TYPE getTargetType() {
        return this.targetType;
    }

    public boolean isAssignObjectRights() {
        return this.assignObjectRights;
    }

    public String getAuthor() {
        return this.author;
    }

    static enum RESOURCE_TYPE {
        USER,
        GROUP;

    }

    public static enum MODE {
        COPY,
        REPLACE;

    }
}

