/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.persistence;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.silverpeas.core.admin.persistence.DomainRow;
import org.silverpeas.core.admin.persistence.Table;
import org.silverpeas.core.annotation.Repository;

@Repository
public class DomainTable
extends Table<DomainRow> {
    private static final String DOMAIN_COLUMNS = "id,name,description,propFileName,className,authenticationServer,theTimeStamp,silverpeasServerURL";
    private static final String SELECT_DOMAIN_BY_ID = "select id,name,description,propFileName,className,authenticationServer,theTimeStamp,silverpeasServerURL from ST_Domain where id = ?";
    private static final String SELECT_ALL_DOMAINS = "select id,name,description,propFileName,className,authenticationServer,theTimeStamp,silverpeasServerURL from ST_Domain where not id=-1 order by name asc";
    private static final String INSERT_DOMAIN = "INSERT INTO ST_Domain (id, name, description, propFileName, className, authenticationServer, theTimeStamp, silverpeasServerURL) VALUES  (? ,? ,?, ? ,?, ?, ?, ?)";
    private static final String UPDATE_DOMAIN = "update ST_Domain set name = ?, description = ?, propFileName = ?, className = ?, authenticationServer = ?, theTimeStamp = ?, silverpeasServerURL = ? where id = ?";
    private static final String DELETE_DOMAIN = "delete from ST_Domain where id = ?";

    DomainTable() {
        super("ST_Domain");
    }

    protected DomainRow fetchDomain(ResultSet rs) throws SQLException {
        DomainRow d = new DomainRow();
        d.id = rs.getInt(1);
        d.name = rs.getString(2);
        d.description = rs.getString(3);
        d.propFileName = rs.getString(4);
        d.className = rs.getString(5);
        d.authenticationServer = rs.getString(6);
        d.theTimeStamp = rs.getString(7);
        d.silverpeasServerURL = rs.getString(8);
        return d;
    }

    public DomainRow getDomain(int id) throws SQLException {
        return (DomainRow)this.getUniqueRow(SELECT_DOMAIN_BY_ID, id);
    }

    public DomainRow[] getAllDomains() throws SQLException {
        List rows = this.getRows(SELECT_ALL_DOMAINS);
        return rows.toArray(new DomainRow[rows.size()]);
    }

    public void createDomain(DomainRow domain) throws SQLException {
        this.insertRow(INSERT_DOMAIN, domain);
    }

    protected void prepareInsert(String insertQuery, PreparedStatement insert, DomainRow row) throws SQLException {
        if (row.id == -1) {
            row.id = this.getNextId();
        }
        insert.setInt(1, row.id);
        insert.setString(2, this.truncate(row.name, 100));
        insert.setString(3, this.truncate(row.description, 400));
        insert.setString(4, this.truncate(row.propFileName, 100));
        insert.setString(5, this.truncate(row.className, 100));
        insert.setString(6, this.truncate(row.authenticationServer, 100));
        String valueTimeStamp = this.truncate(row.theTimeStamp, 100);
        if (valueTimeStamp == null || valueTimeStamp.length() == 0) {
            valueTimeStamp = "0";
        }
        insert.setString(7, valueTimeStamp);
        insert.setString(8, this.truncate(row.silverpeasServerURL, 400));
    }

    public void updateDomain(DomainRow domain) throws SQLException {
        this.updateRow(UPDATE_DOMAIN, domain);
    }

    protected void prepareUpdate(String updateQuery, PreparedStatement update, DomainRow row) throws SQLException {
        update.setString(1, this.truncate(row.name, 100));
        update.setString(2, this.truncate(row.description, 400));
        update.setString(3, this.truncate(row.propFileName, 100));
        update.setString(4, this.truncate(row.className, 100));
        update.setString(5, this.truncate(row.authenticationServer, 100));
        String valueTimeStamp = this.truncate(row.theTimeStamp, 100);
        if (valueTimeStamp == null || valueTimeStamp.length() == 0) {
            valueTimeStamp = "0";
        }
        update.setString(6, valueTimeStamp);
        update.setString(7, this.truncate(row.silverpeasServerURL, 400));
        update.setInt(8, row.id);
    }

    public void removeDomain(int id) throws SQLException {
        DomainRow domain = this.getDomain(id);
        if (domain == null) {
            return;
        }
        this.updateRelation(DELETE_DOMAIN, id);
    }

    protected DomainRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchDomain(rs);
    }
}

