/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.silverpeas.core.admin.component.WAComponentRegistry;
import org.silverpeas.core.admin.component.model.AbstractSilverpeasComponent;
import org.silverpeas.core.admin.component.model.ComponentBehavior;
import org.silverpeas.core.admin.component.model.ComponentBehaviors;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.GroupOfParameters;
import org.silverpeas.core.admin.component.model.MultilangHashMapAdapter;
import org.silverpeas.core.admin.component.model.Parameter;
import org.silverpeas.core.admin.component.model.Profile;
import org.silverpeas.core.i18n.I18NHelper;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="WAComponentType", propOrder={"name", "behaviors", "label", "description", "suite", "inheritSpaceRightsByDefault", "publicByDefault", "visible", "visibleInPersonalSpace", "portlet", "router", "profiles", "groupsOfParameters", "parameters"})
public class WAComponent
extends AbstractSilverpeasComponent {
    @XmlElement(required=true)
    protected String name;
    protected ComponentBehaviors behaviors;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=MultilangHashMapAdapter.class)
    protected Map<String, String> label;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=MultilangHashMapAdapter.class)
    protected Map<String, String> description;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=MultilangHashMapAdapter.class)
    protected Map<String, String> suite;
    protected boolean inheritSpaceRightsByDefault = true;
    protected boolean publicByDefault = false;
    protected boolean visible;
    protected boolean visibleInPersonalSpace = false;
    protected boolean portlet;
    protected String router;
    @XmlElementWrapper(name="profiles")
    @XmlElement(name="profile", required=true)
    protected List<Profile> profiles;
    @XmlElementWrapper(name="groupsOfParameters")
    @XmlElement(name="groupOfParameters")
    protected List<GroupOfParameters> groupsOfParameters;
    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    protected List<Parameter> parameters;

    public static Optional<WAComponent> getByName(String componentName) {
        return WAComponentRegistry.get().getWAComponent(componentName);
    }

    public static Optional<WAComponent> getByInstanceId(String componentInstanceId) {
        return WAComponent.getByName(ComponentInst.getComponentName(componentInstanceId));
    }

    public static Collection<WAComponent> getAll() {
        return WAComponentRegistry.get().getAllWAComponents().values();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ComponentBehaviors getBehaviors() {
        return this.behaviors;
    }

    public void setBehaviors(ComponentBehaviors value) {
        this.behaviors = value;
    }

    @Override
    protected Map<String, String> getLabel() {
        if (this.label == null) {
            this.label = new HashMap<String, String>();
        }
        return this.label;
    }

    public void putLabel(String language, String label) {
        this.getLabel().put(I18NHelper.checkLanguage(language), label);
    }

    @Override
    protected Map<String, String> getDescription() {
        if (this.description == null) {
            this.description = new HashMap<String, String>();
        }
        return this.description;
    }

    public void putDescription(String language, String description) {
        this.getDescription().put(I18NHelper.checkLanguage(language), description);
    }

    protected Map<String, String> getSuite() {
        if (this.suite == null) {
            this.suite = new HashMap<String, String>();
        }
        return this.suite;
    }

    public void putSuite(String language, String suite) {
        this.getSuite().put(I18NHelper.checkLanguage(language), suite);
    }

    @Override
    public boolean isInheritSpaceRightsByDefault() {
        return this.inheritSpaceRightsByDefault;
    }

    public void setInheritSpaceRightsByDefault(boolean inheritSpaceRightsByDefault) {
        this.inheritSpaceRightsByDefault = inheritSpaceRightsByDefault;
    }

    @Override
    public boolean isPublicByDefault() {
        return this.publicByDefault;
    }

    public void setPublicByDefault(boolean publicByDefault) {
        this.publicByDefault = publicByDefault;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public boolean isVisibleInPersonalSpace() {
        return this.visibleInPersonalSpace;
    }

    public void setVisibleInPersonalSpace(boolean value) {
        this.visibleInPersonalSpace = value;
    }

    public boolean isPortlet() {
        return this.portlet;
    }

    public void setPortlet(boolean value) {
        this.portlet = value;
    }

    public String getRouter() {
        return this.router;
    }

    public void setRouter(String value) {
        this.router = value;
    }

    public List<Profile> getProfiles() {
        if (this.profiles == null) {
            this.profiles = new ArrayList<Profile>();
        }
        return this.profiles;
    }

    public Profile getProfile(String name) {
        for (Profile profile : this.getProfiles()) {
            if (!profile.getName().equals(name)) continue;
            return profile;
        }
        return null;
    }

    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    @Override
    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        this.indexedParametersByName.clear();
    }

    @Override
    public boolean hasParameterDefined(String parameterName) {
        return this.getIndexedParametersByName().get(parameterName) != null;
    }

    @Override
    public List<GroupOfParameters> getGroupsOfParameters() {
        if (this.groupsOfParameters == null) {
            this.groupsOfParameters = new ArrayList<GroupOfParameters>();
        }
        return this.groupsOfParameters;
    }

    @Override
    public boolean isWorkflow() {
        return this.getBehaviors() != null && this.getBehaviors().getBehavior().contains((Object)ComponentBehavior.WORKFLOW);
    }

    @Override
    public boolean isTopicTracker() {
        return this.getBehaviors() != null && this.getBehaviors().getBehavior().contains((Object)ComponentBehavior.TOPIC_TRACKER);
    }
}

