/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.util.List;
import java.util.Optional;
import org.silverpeas.core.admin.component.model.AbstractSilverpeasComponent;
import org.silverpeas.core.admin.component.model.GroupOfParameters;
import org.silverpeas.core.admin.component.model.Parameter;
import org.silverpeas.core.admin.component.model.ParameterList;
import org.silverpeas.core.admin.component.model.PersonalComponent;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.kernel.util.StringUtil;

public interface SilverpeasComponent {
    public static Optional<SilverpeasComponent> getByName(String componentName) {
        if (!StringUtil.isDefined((String)componentName)) {
            return Optional.empty();
        }
        Optional<AbstractSilverpeasComponent> component = WAComponent.getByName(componentName);
        if (component.isEmpty()) {
            component = PersonalComponent.getByName(componentName);
        }
        return Optional.ofNullable(component.orElse(null));
    }

    public static Optional<SilverpeasComponent> getByInstanceId(String componentInstanceId) {
        if (!StringUtil.isDefined((String)componentInstanceId)) {
            return Optional.empty();
        }
        Optional<AbstractSilverpeasComponent> component = WAComponent.getByInstanceId(componentInstanceId);
        if (component.isEmpty()) {
            component = PersonalComponent.getByInstanceId(componentInstanceId);
        }
        return Optional.ofNullable(component.orElse(null));
    }

    public String getName();

    public String getLabel(String var1);

    public String getDescription(String var1);

    default public boolean isPersonal() {
        return false;
    }

    default public boolean isInheritSpaceRightsByDefault() {
        return true;
    }

    default public boolean isPublicByDefault() {
        return false;
    }

    public boolean isVisible();

    public List<Parameter> getParameters();

    public boolean hasParameterDefined(String var1);

    public List<Parameter> getSortedParameters();

    public List<GroupOfParameters> getSortedGroupsOfParameters();

    default public ParameterList getAllParameters() {
        ParameterList result = new ParameterList();
        result.addAll(this.getParameters());
        for (GroupOfParameters group : this.getGroupsOfParameters()) {
            result.addAll(group.getParameters());
        }
        return result;
    }

    public List<GroupOfParameters> getGroupsOfParameters();

    default public boolean isWorkflow() {
        return false;
    }

    default public boolean isTopicTracker() {
        return false;
    }
}

