/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration.version;

import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.migration.version.VersionCopier;
import org.apache.jackrabbit.oak.plugins.migration.version.VersionCopyConfiguration;
import org.apache.jackrabbit.oak.plugins.migration.version.VersionHistoryUtil;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.version.ReadWriteVersionManager;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionableEditor
extends DefaultEditor {
    private static final Logger logger = LoggerFactory.getLogger(VersionableEditor.class);
    private static final Set<String> SKIPPED_PATHS = Set.of("/oak:index", "/jcr:system/jcr:versionStorage");
    private final Provider provider;
    private final NodeBuilder rootBuilder;
    private final NodeBuilder versionStorage;
    private final TypePredicate isReferenceable;
    private final TypePredicate isVersionable;
    private final VersionCopier versionCopier;
    private final ReadWriteVersionManager vMgr;
    private String path;

    private VersionableEditor(Provider provider, NodeBuilder rootBuilder) {
        this.rootBuilder = rootBuilder;
        this.versionStorage = VersionHistoryUtil.createVersionStorage(rootBuilder);
        this.vMgr = new ReadWriteVersionManager(this.versionStorage, rootBuilder);
        this.provider = provider;
        this.isVersionable = new TypePredicate(rootBuilder.getNodeState(), "mix:versionable");
        this.isReferenceable = new TypePredicate(rootBuilder.getNodeState(), "mix:referenceable");
        this.versionCopier = new VersionCopier(rootBuilder, VersionHistoryUtil.getVersionStorage(provider.sourceRoot), this.versionStorage);
        this.path = "/";
    }

    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        String path = PathUtils.concat((String)this.path, (String)name);
        if (after == null || SKIPPED_PATHS.contains(path)) {
            return null;
        }
        this.path = path;
        VersionCopyConfiguration c = this.provider.config;
        if (this.isVersionable.test(after)) {
            String versionableUuid = (String)VersionableEditor.getProperty(after, "jcr:uuid", Type.STRING);
            if (c.isCopyVersions() && c.skipOrphanedVersionsCopy()) {
                this.copyVersionHistory(after);
            } else if (c.isCopyVersions() && !c.skipOrphanedVersionsCopy() && c.getOrphanedMinDate().after(c.getVersionsMinDate())) {
                this.copyVersionHistory(after);
            }
            if (this.isVersionHistoryExists(versionableUuid)) {
                this.setVersionablePath(versionableUuid);
            } else {
                NodeBuilder versionableBuilder = VersionableEditor.getNodeBuilder(this.rootBuilder, this.path);
                VersionHistoryUtil.removeVersionProperties(versionableBuilder, this.isReferenceable);
                if (this.isVersionable.test(versionableBuilder.getNodeState())) {
                    logger.warn("Node {} is still versionable due to node type constraints. Creating initial version history.", (Object)path);
                    this.createInitialHistory(versionableBuilder);
                }
            }
        }
        return this;
    }

    private boolean copyVersionHistory(NodeState versionable) {
        assert (versionable.exists());
        String versionableUuid = (String)versionable.getProperty("jcr:uuid").getValue(Type.STRING);
        return this.versionCopier.copyVersionHistory(versionableUuid, this.provider.config.getVersionsMinDate(), this.provider.config.preserveOnTarget());
    }

    private void setVersionablePath(String versionableUuid) {
        NodeBuilder versionHistory = VersionHistoryUtil.getVersionHistoryBuilder(this.versionStorage, versionableUuid);
        if (!versionHistory.hasProperty(this.provider.workspaceName)) {
            versionHistory.setProperty(this.provider.workspaceName, (Object)this.path, Type.PATH);
        }
        VersionHistoryUtil.addMixin(versionHistory, "rep:VersionablePaths");
    }

    private boolean isVersionHistoryExists(String versionableUuid) {
        return VersionHistoryUtil.getVersionHistoryBuilder(this.versionStorage, versionableUuid).exists();
    }

    private void createInitialHistory(NodeBuilder versionable) throws CommitFailedException {
        this.vMgr.getOrCreateVersionHistory(versionable, Collections.emptyMap());
    }

    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        return this.childNodeAdded(name, after);
    }

    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        return this.childNodeAdded(name, null);
    }

    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        this.path = PathUtils.getParentPath((String)this.path);
    }

    private static <T> T getProperty(NodeState state, String name, Type<T> type) {
        if (state.hasProperty(name)) {
            return (T)state.getProperty(name).getValue(type);
        }
        return null;
    }

    private static NodeBuilder getNodeBuilder(NodeBuilder root, String path) {
        NodeBuilder builder = root;
        for (String name : PathUtils.elements((String)path)) {
            builder = builder.getChildNode(name);
        }
        return builder;
    }

    public static class Provider
    implements EditorProvider {
        private final NodeState sourceRoot;
        private final String workspaceName;
        private final VersionCopyConfiguration config;

        public Provider(NodeState sourceRoot, String workspaceName, VersionCopyConfiguration config) {
            this.sourceRoot = sourceRoot;
            this.workspaceName = workspaceName;
            this.config = config;
        }

        public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder rootBuilder, CommitInfo info) throws CommitFailedException {
            return new VersionableEditor(this, rootBuilder);
        }
    }
}

