/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.documenttemplate;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.silverpeas.core.documenttemplate.DefaultDocumentTemplateRepository;
import org.silverpeas.core.documenttemplate.JsonDocumentTemplate;
import org.silverpeas.core.i18n.I18n;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.viewer.service.ViewerContext;
import org.silverpeas.kernel.util.StringUtil;

public class DocumentTemplate
implements Serializable {
    private static final long serialVersionUID = -1458951974587553231L;
    private static final String DOCUMENT_TEMPLATE = "documentTemplate";
    private final JsonDocumentTemplate json;
    private String extension;

    public DocumentTemplate() {
        this(new JsonDocumentTemplate(), null);
    }

    DocumentTemplate(DocumentTemplate other) {
        this.json = new JsonDocumentTemplate(other.json);
        this.extension = other.extension;
    }

    DocumentTemplate(JsonDocumentTemplate json, String extension) {
        this.json = json;
        this.extension = extension;
    }

    public String getId() {
        return this.json.getId();
    }

    void setId(String id) {
        this.json.setId(id);
    }

    public boolean isPersisted() {
        return StringUtil.isDefined((String)this.getId());
    }

    public int getPosition() {
        return this.json.getPosition();
    }

    public void setPosition(int position) {
        this.json.setPosition(position);
    }

    public boolean existNameTranslationIn(String language) {
        return this.json.getNameTranslations().containsKey((Object)language);
    }

    public String getName(String language) {
        return this.json.getNameTranslations().get((Object)language);
    }

    public void setName(String name, String language) {
        this.json.getNameTranslations().put(language, name);
    }

    public boolean existDescriptionTranslationIn(String language) {
        return this.json.getDescriptionTranslations().containsKey((Object)language);
    }

    public String getDescription(String language) {
        return this.json.getDescriptionTranslations().get((Object)language);
    }

    public void setDescription(String description, String language) {
        this.json.getDescriptionTranslations().put(language, description);
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setRestrictedToSpaceIds(List<String> spacesIds) {
        this.json.getRestrictions().setSpaceIds(spacesIds);
    }

    public List<String> getRestrictedToSpaceIds() {
        return this.json.getRestrictions().getSpaceIds();
    }

    public ViewerContext getViewerContext(String language) {
        return new ViewerContext(this.getId(), DOCUMENT_TEMPLATE, this.getName(language), this.getContentFilePath().toFile(), I18n.get().getDefaultLanguage()).withUniqueDocumentId(language + "-" + this.getId());
    }

    public String getContentType() {
        return FileUtil.getMimeType((String)this.getContentFilePath().toString());
    }

    public InputStream openInputStream() throws IOException {
        return Files.newInputStream(this.getContentFilePath(), new OpenOption[0]);
    }

    Path getContentFilePath() {
        return Paths.get(DefaultDocumentTemplateRepository.getDocumentTemplateRepositoryPath().toString(), this.getId() + "." + this.getExtension());
    }

    Path getDescriptorFilePath() {
        return Paths.get(DefaultDocumentTemplateRepository.getDocumentTemplateRepositoryPath().toString(), this.getId() + ".json");
    }

    JsonDocumentTemplate getJson() {
        return this.json;
    }
}

