/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import java.io.File;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.ListUtils;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.tool.PrintingDiff;
import org.apache.jackrabbit.oak.segment.tool.Revisions;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public class Diff {
    private final String path;
    private final String interval;
    private final boolean incremental;
    private final File out;
    private final String filter;
    private final boolean ignoreMissingSegments;
    private final ReadOnlyFileStore store;
    private final Revisions.RevisionsProcessor processor;

    public static Builder builder() {
        return new Builder();
    }

    private Diff(Builder builder) {
        this.path = builder.path;
        this.store = builder.store;
        this.interval = builder.interval;
        this.incremental = builder.incremental;
        this.out = builder.out;
        this.filter = builder.filter;
        this.ignoreMissingSegments = builder.ignoreMissingSegments;
        this.processor = builder.processor;
    }

    public int run() {
        try {
            this.diff();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return 1;
        }
    }

    private void diff() throws Exception {
        long start;
        block17: {
            RecordId idR;
            RecordId idL;
            System.out.println("Store " + this.path);
            System.out.println("Writing diff to " + this.out);
            String[] tokens = this.interval.trim().split("\\.\\.");
            if (tokens.length != 2) {
                System.out.println("Error parsing revision interval '" + this.interval + "'.");
                return;
            }
            SegmentIdProvider idProvider = this.store.getSegmentIdProvider();
            try {
                idL = tokens[0].equalsIgnoreCase("head") ? this.store.getRevisions().getHead() : RecordId.fromString(idProvider, tokens[0]);
            }
            catch (IllegalArgumentException e) {
                System.out.println("Invalid left endpoint for interval " + this.interval);
                return;
            }
            try {
                idR = tokens[1].equalsIgnoreCase("head") ? this.store.getRevisions().getHead() : RecordId.fromString(idProvider, tokens[1]);
            }
            catch (IllegalArgumentException e) {
                System.out.println("Invalid left endpoint for interval " + this.interval);
                return;
            }
            start = System.currentTimeMillis();
            try (PrintWriter pw = new PrintWriter(this.out);){
                if (this.incremental) {
                    List<String> revs = this.processor.process(this.path);
                    System.out.println("Generating diff between " + idL + " and " + idR + " incrementally. Found " + revs.size() + " revisions.");
                    int s = revs.indexOf(idL.toString10());
                    int e = revs.indexOf(idR.toString10());
                    if (s == -1 || e == -1) {
                        System.out.println("Unable to match input revisions with FileStore.");
                        return;
                    }
                    List revDiffs = revs.subList(Math.min(s, e), Math.max(s, e) + 1);
                    if (s > e) {
                        revDiffs = ListUtils.reverse(revDiffs);
                    }
                    if (revDiffs.size() < 2) {
                        System.out.println("Nothing to diff: " + revDiffs);
                        return;
                    }
                    Iterator revDiffsIt = revDiffs.iterator();
                    RecordId idLt = RecordId.fromString(idProvider, (String)revDiffsIt.next());
                    while (revDiffsIt.hasNext()) {
                        RecordId idRt = RecordId.fromString(idProvider, (String)revDiffsIt.next());
                        boolean good = this.diff(this.store, idLt, idRt, pw);
                        idLt = idRt;
                        if (good || this.ignoreMissingSegments) continue;
                        break block17;
                    }
                    break block17;
                }
                System.out.println("Generating diff between " + idL + " and " + idR);
                this.diff(this.store, idL, idR, pw);
            }
        }
        long dur = System.currentTimeMillis() - start;
        System.out.println("Finished in " + dur + " ms.");
    }

    private boolean diff(ReadOnlyFileStore store, RecordId idL, RecordId idR, PrintWriter pw) {
        pw.println("rev " + idL + ".." + idR);
        try {
            NodeState before = store.getReader().readNode(idL).getChildNode("root");
            NodeState after = store.getReader().readNode(idR).getChildNode("root");
            for (String name : PathUtils.elements((String)this.filter)) {
                before = before.getChildNode(name);
                after = after.getChildNode(name);
            }
            after.compareAgainstBaseState(before, (NodeStateDiff)new PrintingDiff(pw, this.filter));
            return true;
        }
        catch (SegmentNotFoundException ex) {
            System.out.println(ex.getMessage());
            pw.println("#SNFE " + ex.getSegmentId());
            return false;
        }
    }

    public static class Builder {
        private String path;
        private ReadOnlyFileStore store;
        private String interval;
        private boolean incremental;
        private File out;
        private String filter;
        private boolean ignoreMissingSegments;
        private Revisions.RevisionsProcessor processor;

        private Builder() {
        }

        public Builder withPath(String path) {
            this.path = Objects.requireNonNull(path);
            return this;
        }

        public Builder withReadOnlyFileStore(ReadOnlyFileStore store) {
            this.store = Objects.requireNonNull(store);
            return this;
        }

        public Builder withInterval(String interval) {
            this.interval = Objects.requireNonNull(interval);
            return this;
        }

        public Builder withIncremental(boolean incremental) {
            this.incremental = incremental;
            return this;
        }

        public Builder withOutput(File file) {
            this.out = Objects.requireNonNull(file);
            return this;
        }

        public Builder withFilter(String filter) {
            this.filter = Objects.requireNonNull(filter);
            return this;
        }

        public Builder withIgnoreMissingSegments(boolean ignoreMissingSegments) {
            this.ignoreMissingSegments = ignoreMissingSegments;
            return this;
        }

        public Builder withRevisionsProcessor(Revisions.RevisionsProcessor processor) {
            this.processor = processor;
            return this;
        }

        public Diff build() {
            Objects.requireNonNull(this.path);
            Objects.requireNonNull(this.interval);
            Objects.requireNonNull(this.out);
            Objects.requireNonNull(this.filter);
            return new Diff(this);
        }
    }
}

