/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.PortletEvent;
import com.sun.portal.container.PortletID;
import com.sun.portal.container.service.EventHolder;
import com.sun.portal.container.service.PortletDescriptorHolder;
import com.sun.portal.container.service.PortletDescriptorHolderFactory;
import com.sun.portal.container.service.PublicRenderParameterHolder;
import com.sun.portal.portletcontainer.common.PortletContainerRequest;
import com.sun.portal.portletcontainer.common.PortletContainerResponse;
import com.sun.portal.portletcontainer.common.descriptor.EventDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.PortletResponseImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletRequest;
import javax.portlet.StateAwareResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StateAwareResponseImpl
extends PortletResponseImpl
implements StateAwareResponse {
    private PortletRequest portletRequest;
    private static Logger logger = ContainerLogger.getLogger(StateAwareResponseImpl.class, (String)"PAELogMessages");

    @Override
    protected void init(HttpServletRequest request, HttpServletResponse response, PortletContainerRequest pcRequest, PortletContainerResponse pcResponse, PortletRequest portletRequest, PortletAppDescriptor portletAppDescriptor, PortletDescriptor portletDescriptor) {
        super.init(request, response, pcRequest, pcResponse, portletRequest, portletAppDescriptor, portletDescriptor);
        this.portletRequest = portletRequest;
    }

    @Override
    protected void clear() {
        super.clear();
        this.portletRequest = null;
    }

    protected void checkRenderParameterMap(Map<String, String[]> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("The passed in map should not be null");
        }
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            String key = entry.getKey();
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("The keys in the map must be of type String");
            }
            String[] value = entry.getValue();
            if (value instanceof String[]) continue;
            throw new IllegalArgumentException("The values in the map must be of type String[]");
        }
    }

    protected List<String> getDeletedRenderParameterList(String key, String value, List<String> deletedRenderParameters) {
        if (value == null) {
            if (deletedRenderParameters == null || deletedRenderParameters.size() == 0) {
                deletedRenderParameters = new ArrayList<String>();
            }
            deletedRenderParameters.add(key);
        }
        return deletedRenderParameters;
    }

    protected Map<String, String[]> getRenderParameterMap(String key, String value, Map<String, String[]> renderMap) {
        if (value == null) {
            if (renderMap != null && renderMap.size() != 0) {
                renderMap.remove(key);
            }
        } else {
            String[] values = new String[]{value};
            renderMap = this.getRenderParameterMap(key, values, renderMap);
        }
        return renderMap;
    }

    protected Map<String, String[]> getRenderParameterMap(String key, String[] values, Map<String, String[]> renderMap) {
        if (key == null || values == null) {
            throw new IllegalArgumentException("Key or value argument should not be null.");
        }
        HashMap<String, String[]> modifiableRenderMap = renderMap == null || renderMap.size() == 0 ? new HashMap<String, String[]>() : new HashMap<String, String[]>(renderMap);
        modifiableRenderMap.put(key, values);
        return modifiableRenderMap;
    }

    public void setEvent(QName name, Serializable value) {
        this.setEventQueue(name, value);
    }

    public void setEvent(String name, Serializable value) {
        if (name == null) {
            throw new IllegalArgumentException("The event name must not be null");
        }
        QName qname = new QName(this.getPortletAppDescriptor().getDefaultNamespace(), name);
        this.setEventQueue(qname, value);
    }

    private void setEventQueue(QName qname, Serializable value) {
        if (qname == null) {
            throw new IllegalArgumentException("The event name must not be null");
        }
        if (value != null && !(value instanceof Serializable)) {
            throw new IllegalArgumentException("The event value is not serializable");
        }
        EventDescriptor eventDescriptor = this.getPortletAppDescriptor().getEventDescriptor(qname);
        if (eventDescriptor == null) {
            logger.log(Level.WARNING, "PSPL_PAECSPPI0031", qname);
            return;
        }
        EventHolder eventHolder = null;
        try {
            PortletDescriptorHolder portletDescriptorHolder = PortletDescriptorHolderFactory.getPortletDescriptorHolder();
            eventHolder = portletDescriptorHolder.verifySupportedPublishingEvent(this.getPortletContainerRequest().getEntityID(), eventDescriptor.getEventHolder());
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "PSPL_PAECSPPI0030", ex);
        }
        if (eventHolder == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "PSPL_PAECSPPI0032", new Object[]{qname, this.getPortletContainerRequest().getEntityID()});
            }
            return;
        }
        if (value != null) {
            String valueType = eventHolder.getValueType();
            String inputValueType = value.getClass().getName();
            if (!inputValueType.equals(valueType)) {
                throw new IllegalArgumentException("The object type of the value is " + inputValueType + ". But the value-type in portlet deployment descriptor is " + valueType + " for the event " + qname);
            }
        }
        PortletEvent event = new PortletEvent(eventHolder, qname, value);
        this.setEventQueue(event);
    }

    protected boolean checkIfPublicRenderParameter(String name) {
        PortletID portletID;
        if (name == null) {
            throw new IllegalArgumentException("The public render parameter to be removed cannot be null");
        }
        boolean found = false;
        Map<PortletID, List<PublicRenderParameterHolder>> publicRenderParameters = this.getPortletAppDescriptor().getPublicRenderParameters();
        List<PublicRenderParameterHolder> publicRenderParameterHolders = publicRenderParameters.get(portletID = this.getPortletContainerRequest().getEntityID().getPortletID());
        if (publicRenderParameterHolders != null) {
            for (PublicRenderParameterHolder publicRenderParameterHolder : publicRenderParameterHolders) {
                if (!name.equals(publicRenderParameterHolder.getIdentifier())) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            logger.log(Level.WARNING, "PSPL_PAECSPPI0042", name);
        }
        return found;
    }

    protected abstract void setEventQueue(PortletEvent var1);
}

