/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.container.ChannelMode;
import com.sun.portal.portletcontainer.appengine.PortletAppEngineUtils;
import com.sun.portal.portletcontainer.appengine.StringServletOutputStream;
import com.sun.portal.portletcontainer.common.PortletContainerRenderRequest;
import com.sun.portal.portletcontainer.common.PortletContainerRenderResponse;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.CacheControlImpl;
import com.sun.portal.portletcontainer.portlet.impl.MimeResponseImpl;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.portlet.CacheControl;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderResponseImpl
extends MimeResponseImpl
implements RenderResponse {
    private RenderRequest renderRequest;
    private HttpServletResponse response;
    private PortletContainerRenderRequest pcRenderRequest;
    private PortletContainerRenderResponse pcRenderResponse;
    private Collection<PortletMode> portletModes;

    protected void init(HttpServletRequest request, HttpServletResponse response, PortletContainerRenderRequest pcRenderRequest, PortletContainerRenderResponse pcRenderResponse, RenderRequest renderRequest, PortletAppDescriptor portletAppDescriptor, PortletDescriptor portletDescriptor, StringWriter stringWriter, StringServletOutputStream outputStream) {
        super.init(request, response, pcRenderRequest, pcRenderResponse, (PortletRequest)renderRequest, portletAppDescriptor, portletDescriptor, stringWriter, outputStream);
        this.response = response;
        this.renderRequest = renderRequest;
        this.pcRenderRequest = pcRenderRequest;
        this.pcRenderResponse = pcRenderResponse;
    }

    @Override
    protected void clear() {
        super.clear();
        this.response = null;
        this.renderRequest = null;
        this.pcRenderRequest = null;
        this.pcRenderResponse = null;
    }

    public void setTitle(String title) {
        String tmpTitle;
        if (this.isCommitted()) {
            return;
        }
        String genericPortletTitle = (String)this.renderRequest.getAttribute("com.sun.portal.portletcontainer.portlet.generic.title");
        if (genericPortletTitle != null && genericPortletTitle.equals(title) && (tmpTitle = (String)this.renderRequest.getAttribute("com.sun.portal.portletcontainer.portlet.title")) != null) {
            title = tmpTitle;
        }
        this.pcRenderResponse.setTitle(title);
    }

    @Override
    public void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Property name should not be null.");
        }
        if (key.equals("portlet.expiration-cache")) {
            int cacheVal = this.pcRenderResponse.getCacheControl().getExpirationTime();
            if (cacheVal != -999) {
                try {
                    cacheVal = Integer.parseInt(value);
                }
                catch (NumberFormatException ne) {
                    // empty catch block
                }
                this.pcRenderResponse.getCacheControl().setExpirationTime(cacheVal);
            }
        } else if (key.equals("portlet.cache-scope")) {
            if (this.pcRenderResponse.getCacheControl().getExpirationTime() != -999) {
                this.pcRenderResponse.getCacheControl().setPublicScope("portlet.public-scope".equals(value));
            }
        } else if (key.equals("portlet.public-scope")) {
            this.pcRenderResponse.getCacheControl().setPublicScope("true".equals(value));
        } else if (key.equals("portlet.private-scope")) {
            this.pcRenderResponse.getCacheControl().setPublicScope("false".equals(value));
        } else if (key.equals("portlet.ETag")) {
            this.pcRenderResponse.getCacheControl().setETag(value);
        } else if (key.equals("portlet.use-cached-content")) {
            boolean useCachedContent = Boolean.parseBoolean(value);
            this.pcRenderResponse.getCacheControl().setUseCachedContent(useCachedContent);
        } else {
            super.setProperty(key, value);
        }
    }

    public void setNextPossiblePortletModes(Collection<PortletMode> portletModes) {
        if (portletModes == null || portletModes.isEmpty()) {
            List<ChannelMode> channelModes = this.pcRenderRequest.getAllowablePortletWindowModes();
            this.portletModes = new ArrayList<PortletMode>(channelModes.size());
            for (ChannelMode channelMode : channelModes) {
                this.portletModes.add(PortletAppEngineUtils.getPortletMode(channelMode));
            }
        } else {
            PortletMode[] inputPortletModes = portletModes.toArray(new PortletMode[0]);
            PortletMode[] outputPortletModes = new PortletMode[inputPortletModes.length];
            System.arraycopy(inputPortletModes, 0, outputPortletModes, 0, inputPortletModes.length);
            this.portletModes = Arrays.asList(outputPortletModes);
        }
    }

    @Override
    public CacheControl getCacheControl() {
        return new CacheControlImpl(this.pcRenderResponse.getCacheControl());
    }

    @Override
    protected void setCacheability(ResourceURL resourceURL) {
        resourceURL.setCacheability("cacheLevelPage");
    }
}

