/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.ContainerUtil;
import com.sun.portal.portletcontainer.common.PortletContainerRequest;
import com.sun.portal.portletcontainer.common.descriptor.SharedSessionAttributeDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.PortletSessionImpl;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;

public class PortletSharedSessionImpl
extends PortletSessionImpl {
    private static Logger logger = ContainerLogger.getLogger(PortletSharedSessionImpl.class, (String)"PAELogMessages");
    private PortletContainerRequest pcRequest;

    public PortletSharedSessionImpl(HttpSession session, PortletContext portletContext, String windowID, PortletContainerRequest pcRequest) {
        super(session, portletContext, windowID);
        this.pcRequest = pcRequest;
    }

    protected void updatePortletContainerRequest(PortletContainerRequest pcRequest) {
        this.pcRequest = pcRequest;
    }

    public Object getAttribute(String name, int scope) {
        Object value = super.getAttribute(name, scope);
        SharedSessionAttributeDescriptor sharedSessionAttributeDescriptor = this.getSharedSessionAttributeDescriptor(name, scope);
        if (sharedSessionAttributeDescriptor != null) {
            value = this.pcRequest.getSharedSessionAttribute(name);
            value = this.getDeserializedValue(sharedSessionAttributeDescriptor.getValueType(), value);
        }
        return value;
    }

    public void removeAttribute(String name, int scope) {
        super.removeAttribute(name, scope);
        SharedSessionAttributeDescriptor sharedSessionAttributeDescriptor = this.getSharedSessionAttributeDescriptor(name, scope);
        if (sharedSessionAttributeDescriptor != null) {
            this.pcRequest.removeSharedSessionAttribute(name);
        }
    }

    public void setAttribute(String name, Object value, int scope) {
        super.setAttribute(name, value, scope);
        SharedSessionAttributeDescriptor sharedSessionAttributeDescriptor = this.getSharedSessionAttributeDescriptor(name, scope);
        if (sharedSessionAttributeDescriptor != null) {
            if (value == null) {
                this.removeAttribute(name, scope);
            } else {
                if (!(value instanceof Serializable)) {
                    throw new IllegalArgumentException("The shared session attribute value is not serializable");
                }
                this.pcRequest.addSharedSessionAttribute(name, this.getSerializableValue(name, value));
            }
        }
    }

    private SharedSessionAttributeDescriptor getSharedSessionAttributeDescriptor(String name, int scope) {
        if (scope != 1) {
            return null;
        }
        List<SharedSessionAttributeDescriptor> sharedSessionAttributeDescriptors = this.pcRequest.getSharedSessionAttributeDescriptors();
        if (sharedSessionAttributeDescriptors != null) {
            for (SharedSessionAttributeDescriptor sharedSessionAttributeDescriptor : sharedSessionAttributeDescriptors) {
                if (!name.equals(sharedSessionAttributeDescriptor.getName())) continue;
                return sharedSessionAttributeDescriptor;
            }
        }
        return null;
    }

    private Serializable getSerializableValue(String name, Object value) {
        Serializable serializedValue;
        block2: {
            serializedValue = null;
            QName qname = new QName(name);
            try {
                serializedValue = ContainerUtil.serializeJavaToXml((QName)qname, (Serializable)((Serializable)value));
            }
            catch (Exception ex) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.log(Level.WARNING, "PSPL_PAECSPPI0048", new String[]{name, ex.toString()});
            }
        }
        return serializedValue;
    }

    private Serializable getDeserializedValue(String valueType, Object value) {
        Serializable deserializedValue;
        block2: {
            deserializedValue = null;
            try {
                deserializedValue = ContainerUtil.deserializeXmlToJava((String)valueType, (Serializable)((Serializable)value));
            }
            catch (Exception ex) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.log(Level.WARNING, "PSPL_PAECSPPI0049", new String[]{valueType, ex.toString()});
            }
        }
        return deserializedValue;
    }
}

